/*
 * Decompiled with CFR 0.152.
 */
package net.zetetic.database.sqlcipher;

import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.database.CursorWindow;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.zetetic.database.DatabaseUtils;
import net.zetetic.database.sqlcipher.SQLiteCursorDriver;
import net.zetetic.database.sqlcipher.SQLiteDatabase;
import net.zetetic.database.sqlcipher.SQLiteQuery;

public class SQLiteCursor
extends AbstractWindowedCursor {
    static final String TAG = "SQLiteCursor";
    static final int NO_COUNT = -1;
    private static final int CURSOR_WINDOW_EXTRA = 512;
    private static boolean CURSOR_WINDOW_NEEDS_RECREATED = false;
    private static final int DEFAULT_CURSOR_WINDOW_SIZE;
    public static int PREFERRED_CURSOR_WINDOW_SIZE;
    private final String mEditTable;
    private final String[] mColumns;
    private final SQLiteQuery mQuery;
    private final SQLiteCursorDriver mDriver;
    private int mCount = -1;
    private int mCursorWindowCapacity;
    private Map<String, Integer> mColumnNameMap;

    @Deprecated
    public SQLiteCursor(SQLiteDatabase db, SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        this(driver, editTable, query);
    }

    public SQLiteCursor(SQLiteCursorDriver driver, String editTable, SQLiteQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("query object cannot be null");
        }
        this.mDriver = driver;
        this.mEditTable = editTable;
        this.mColumnNameMap = null;
        this.mQuery = query;
        this.mColumns = query.getColumnNames();
    }

    public SQLiteDatabase getDatabase() {
        return this.mQuery.getDatabase();
    }

    public boolean onMove(int oldPosition, int newPosition) {
        if (this.mWindow == null || newPosition < this.mWindow.getStartPosition() || newPosition >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
            this.fillWindow(newPosition);
        }
        return true;
    }

    public int getCount() {
        if (this.mCount == -1) {
            this.fillWindow(0);
        }
        return this.mCount;
    }

    public static void setCursorWindowSize(int size) {
        PREFERRED_CURSOR_WINDOW_SIZE = size;
        CURSOR_WINDOW_NEEDS_RECREATED = true;
    }

    public static void resetCursorWindowSize() {
        PREFERRED_CURSOR_WINDOW_SIZE = DEFAULT_CURSOR_WINDOW_SIZE;
        CURSOR_WINDOW_NEEDS_RECREATED = true;
    }

    private void awc_clearOrCreateWindow(String name) {
        CursorWindow win;
        int cursorWindowAllocationSize = PREFERRED_CURSOR_WINDOW_SIZE + 512;
        if (CURSOR_WINDOW_NEEDS_RECREATED) {
            this.awc_closeWindow();
            CURSOR_WINDOW_NEEDS_RECREATED = false;
        }
        if ((win = this.getWindow()) == null) {
            if (Build.VERSION.SDK_INT >= 28) {
                win = new CursorWindow(name, (long)cursorWindowAllocationSize);
            } else {
                try {
                    Field field = CursorWindow.class.getDeclaredField("sCursorWindowSize");
                    if (field != null) {
                        field.setAccessible(true);
                        field.set(null, cursorWindowAllocationSize);
                        Log.i((String)TAG, (String)String.format("Set CursorWindow allocation size to %s", cursorWindowAllocationSize));
                    }
                }
                catch (Exception ex) {
                    Log.e((String)TAG, (String)"Failed to override CursorWindow allocation size", (Throwable)ex);
                }
                win = new CursorWindow(name);
            }
            this.setWindow(win);
        } else {
            win.clear();
        }
    }

    private void awc_closeWindow() {
        this.setWindow(null);
    }

    private void fillWindow(int requiredPos) {
        this.awc_clearOrCreateWindow(this.getDatabase().getPath());
        try {
            if (this.mCount == -1) {
                int startPos = DatabaseUtils.cursorPickFillWindowStartPosition(requiredPos, 0);
                this.mCount = this.mQuery.fillWindow(this.mWindow, startPos, requiredPos, true);
                this.mCursorWindowCapacity = this.mWindow.getNumRows();
                if (Log.isLoggable((String)TAG, (int)3)) {
                    Log.d((String)TAG, (String)("received count(*) from native_fill_window: " + this.mCount));
                }
            } else {
                int startPos = DatabaseUtils.cursorPickFillWindowStartPosition(requiredPos, this.mCursorWindowCapacity);
                this.mQuery.fillWindow(this.mWindow, startPos, requiredPos, false);
            }
        }
        catch (RuntimeException ex) {
            this.awc_closeWindow();
            throw ex;
        }
    }

    public int getColumnIndex(String columnName) {
        Integer i;
        int periodIndex;
        if (this.mColumnNameMap == null) {
            String[] columns = this.mColumns;
            int columnCount = columns.length;
            HashMap<String, Integer> map = new HashMap<String, Integer>(columnCount, 1.0f);
            for (int i2 = 0; i2 < columnCount; ++i2) {
                map.put(columns[i2], i2);
            }
            this.mColumnNameMap = map;
        }
        if ((periodIndex = columnName.lastIndexOf(46)) != -1) {
            Exception e = new Exception();
            Log.e((String)TAG, (String)("requesting column name with table name -- " + columnName), (Throwable)e);
            columnName = columnName.substring(periodIndex + 1);
        }
        if ((i = this.mColumnNameMap.get(columnName)) != null) {
            return i;
        }
        return -1;
    }

    public String[] getColumnNames() {
        return this.mColumns;
    }

    public void deactivate() {
        super.deactivate();
        this.mDriver.cursorDeactivated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            this.mQuery.close();
            this.mDriver.cursorClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requery() {
        if (this.isClosed()) {
            return false;
        }
        SQLiteCursor sQLiteCursor = this;
        synchronized (sQLiteCursor) {
            if (!this.mQuery.getDatabase().isOpen()) {
                return false;
            }
            if (this.mWindow != null) {
                this.mWindow.clear();
            }
            this.mPos = -1;
            this.mCount = -1;
            this.mDriver.cursorRequeried((Cursor)this);
        }
        try {
            return super.requery();
        }
        catch (IllegalStateException e) {
            Log.w((String)TAG, (String)("requery() failed " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void setWindow(CursorWindow window) {
        super.setWindow(window);
        this.mCount = -1;
    }

    public void setSelectionArguments(String[] selectionArgs) {
        this.mDriver.setBindArguments(selectionArgs);
    }

    protected void finalize() {
        try {
            if (this.mWindow != null) {
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        PREFERRED_CURSOR_WINDOW_SIZE = DEFAULT_CURSOR_WINDOW_SIZE = (int)(8.0 * Math.pow(1024.0, 2.0));
    }
}

