/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import android.os.SystemClock;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteProgram;

public class SQLiteStatement
extends SQLiteProgram {
    SQLiteStatement(SQLiteDatabase db, String sql) {
        super(db, sql);
    }

    public void execute() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeInsert() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
            long l = this.mDatabase.lastChangeCount() > 0 ? this.mDatabase.lastInsertRow() : -1L;
            return l;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdateDelete() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            this.native_execute();
            int n = this.mDatabase.lastChangeCount();
            return n;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long simpleQueryForLong() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            long retValue;
            long l = retValue = this.native_1x1_long();
            return l;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String simpleQueryForString() {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        long timeStart = SystemClock.uptimeMillis();
        this.mDatabase.lock();
        this.acquireReference();
        try {
            String retValue;
            String string = retValue = this.native_1x1_string();
            return string;
        }
        finally {
            this.releaseReference();
            this.mDatabase.unlock();
        }
    }

    private final native void native_execute();

    private final native long native_1x1_long();

    private final native String native_1x1_string();
}

