/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.template;

import java.util.Objects;
import java.util.Optional;
import net.yetamine.template.Symbol;
import net.yetamine.template.TemplateCallback;
import net.yetamine.template.TemplateParser;
import net.yetamine.template.TokenScanner;

public final class TokenParser
implements TemplateParser {
    private final TokenScanner<? extends Symbol> scanner;
    private final String input;
    private int position;
    private Symbol symbol;
    private int symbolOpen;
    private int symbolDone;
    private boolean done;

    public TokenParser(TokenScanner<? extends Symbol> symbolScanner, String template) {
        this.scanner = Objects.requireNonNull(symbolScanner);
        this.input = Objects.requireNonNull(template);
    }

    public String toString() {
        return String.format("TemplateParser[input=%s, position=%d, scanner=%s]", this.input, this.position, this.scanner);
    }

    @Override
    public <R> R next(TemplateCallback<? extends R> callback) {
        Objects.requireNonNull(callback);
        assert (0 <= this.position && this.position <= this.input.length());
        assert (0 <= this.symbolOpen && this.symbolOpen <= this.symbolDone && this.symbolDone <= this.input.length());
        if (this.done) {
            return callback.none();
        }
        if (this.position == this.input.length()) {
            R result = this.input.isEmpty() ? callback.literal(this.input) : callback.none();
            this.done = true;
            return result;
        }
        if (this.position == this.symbolDone) {
            this.symbol = Optional.ofNullable(this.scanner.find(this.input, this.position)).map(token -> {
                this.symbolOpen = token.from();
                this.symbolDone = token.to();
                return (Symbol)token.value();
            }).orElseGet(() -> {
                this.symbolDone = this.symbolOpen = this.input.length();
                return null;
            });
        }
        if (this.position == this.symbolOpen) {
            assert (this.symbol != null);
            String val = this.symbol.value();
            String def = this.symbol.toString();
            R result = this.symbol.constant() ? callback.constant(def, val) : callback.reference(def, val);
            this.position = this.symbolDone;
            return result;
        }
        assert (this.position < this.symbolOpen);
        R result = callback.literal(this.input.substring(this.position, this.symbolOpen));
        this.position = this.symbolOpen;
        return result;
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public String input() {
        return this.input;
    }
}

