/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.template;

import java.util.Objects;

public final class Token<T> {
    private final T value;
    private final int from;
    private final int to;

    public Token(T payload, int positionFrom, int positionTo) {
        if (positionFrom < 0 || positionTo < positionFrom) {
            String f = "Given bounds do not satisfy condition 0 <= %d <= %d.";
            throw new IllegalArgumentException(String.format("Given bounds do not satisfy condition 0 <= %d <= %d.", positionFrom, positionTo));
        }
        this.from = positionFrom;
        this.to = positionTo;
        this.value = payload;
    }

    public String toString() {
        return String.format("Token[position=[%d, %d), value=%s]", this.from, this.to, this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Token) {
            Token o = (Token)obj;
            return this.from == o.from && this.to == o.to && Objects.equals(this.value, o.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.value);
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public int length() {
        return this.to - this.from;
    }

    public T value() {
        return this.value;
    }
}

