/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.yetamine.template.Template;
import net.yetamine.template.TemplateLiteral;
import net.yetamine.template.TemplateParser;

public final class TemplateSequence
implements Template {
    private static final Template[] EMPTY = new Template[0];
    private final Template[] fragments;

    private TemplateSequence(Template ... sequence) {
        this.fragments = sequence;
    }

    public static Template composition(Template ... templates) {
        return TemplateSequence.composed(TemplateSequence.checked((Template[])templates.clone()));
    }

    public static Template composition(Collection<? extends Template> templates) {
        return TemplateSequence.composed(TemplateSequence.checked(templates.toArray(EMPTY)));
    }

    public static Template composition(TemplateParser parser) {
        Template current;
        Template head = parser.next();
        if (head == null) {
            assert (parser.done());
            return TemplateLiteral.empty();
        }
        Template next = parser.next();
        if (next == null) {
            assert (parser.done());
            return head;
        }
        ArrayList<Template> fragments = new ArrayList<Template>();
        fragments.add(head);
        fragments.add(next);
        while ((current = parser.next()) != null) {
            fragments.add(current);
        }
        assert (parser.done());
        return new TemplateSequence(fragments.toArray(EMPTY));
    }

    @Override
    public String toString() {
        return Stream.of(this.fragments).map(Object::toString).collect(Collectors.joining());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof TemplateSequence && Arrays.equals(this.fragments, ((TemplateSequence)obj).fragments);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fragments);
    }

    @Override
    public String apply(Function<? super String, String> resolver) {
        Objects.requireNonNull(resolver);
        return Stream.of(this.fragments).map(fragment -> fragment.apply(resolver)).collect(Collectors.joining());
    }

    private static Template[] checked(Template[] templates) {
        for (Template template : templates) {
            Objects.requireNonNull(template);
        }
        return templates;
    }

    private static Template composed(Template[] templates) {
        switch (templates.length) {
            case 0: {
                return TemplateLiteral.empty();
            }
            case 1: {
                return templates[0];
            }
        }
        return new TemplateSequence(templates);
    }
}

