/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.template;

import java.util.Objects;
import java.util.function.Function;
import net.yetamine.template.Symbol;
import net.yetamine.template.Template;

public final class TemplateReference
implements Template,
Symbol {
    private final String value;
    private final String definition;

    private TemplateReference(String def, String ref) {
        this.definition = Objects.requireNonNull(def);
        this.value = ref;
    }

    public static TemplateReference from(String def, String ref) {
        return new TemplateReference(def, ref);
    }

    public static Template instance(String def, String ref) {
        return TemplateReference.from(def, ref);
    }

    @Override
    public String toString() {
        return this.definition;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TemplateReference) {
            TemplateReference o = (TemplateReference)obj;
            return this.definition.equals(o.definition) && Objects.equals(this.value, o.value);
        }
        return false;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    @Override
    public String apply(Function<? super String, String> resolver) {
        String result = resolver.apply(this.value);
        return result != null ? result : this.definition;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public boolean constant() {
        return false;
    }

    @Deprecated
    public String reference() {
        return this.value();
    }
}

