/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.yetamine.template.Interpolation;
import net.yetamine.template.Template;
import net.yetamine.template.TemplateFormat;
import net.yetamine.template.TemplateLiteral;
import net.yetamine.template.TemplateSyntaxException;

public final class TemplateRecursion<T>
implements UnaryOperator<String> {
    final Linking<T> linking;
    final Function<? super T, Binding<T>> lookup;
    final RecursionFailureHandler<T> recursionFailureHandler;
    private final Map<T, Nullable<String>> cache;

    TemplateRecursion(Builder<T> builder) {
        this.lookup = Objects.requireNonNull(builder.lookup);
        this.linking = Objects.requireNonNull(builder.linking);
        this.recursionFailureHandler = Objects.requireNonNull(builder.recursionFailureHandler);
        this.cache = builder.caching ? new ConcurrentHashMap() : null;
    }

    public static <T> Builder<T> builder(Linking<T> linking, Function<? super T, Binding<T>> lookup) {
        return new Builder<T>(linking, lookup);
    }

    public static <T> Source<T> source(Linking<T> linking) {
        return new Source<T>(linking);
    }

    public static Source<String> source() {
        return new Source<String>((placeholder, context) -> placeholder);
    }

    public static <T> Builder<T> with(Source<T> source) {
        return new Builder<T>(source.linking(), source.lookup());
    }

    public static Builder<String> with(Function<? super String, String> templates, Function<? super String, String> fallback) {
        return TemplateRecursion.with(TemplateRecursion.source().templates(templates).onDeliveryMissed(fallback));
    }

    public static Builder<String> with(Function<? super String, String> templates) {
        return TemplateRecursion.with(TemplateRecursion.source().templates(templates));
    }

    @Override
    public String apply(String placeholder) {
        return this.resolve(this.linking.apply(placeholder));
    }

    public String resolve(T reference) {
        if (reference == null) {
            return null;
        }
        Nullable<String> cached = this.cached(reference);
        if (cached != null) {
            return cached.value();
        }
        Binding<T> resolvable = this.lookup.apply(reference);
        if (resolvable == null) {
            return null;
        }
        Map resolved = new Resolution().add(reference, resolvable).resolve();
        if (this.cache != null) {
            this.cache.putAll(resolved);
        }
        return Nullable.toValue(resolved.get(reference));
    }

    Nullable<String> cached(T reference) {
        return this.cache != null ? this.cache.get(reference) : null;
    }

    private final class Resolution {
        private Map<Binding<T>, T> references = new HashMap();
        private Map<T, Binding<T>> vertices = new HashMap();
        private Map<Binding<T>, Set<Binding<T>>> incoming = new HashMap();
        private Map<Binding<T>, Set<Binding<T>>> outgoing;
        private Map<T, Nullable<String>> resolved;

        public String toString() {
            return String.format("Resolution[incoming=%s, outgoing=%s, resolved=%s]", this.incoming, this.outgoing, this.resolved);
        }

        public Resolution add(T reference, Binding<T> definition) {
            if (this.vertices == null) {
                throw new IllegalStateException();
            }
            this.putAll(reference, definition);
            return this;
        }

        public Map<T, Nullable<String>> resolve() {
            if (this.resolved != null) {
                return this.resolved;
            }
            assert (this.vertices.size() == this.references.size());
            assert (this.vertices.size() == this.incoming.size());
            this.outgoing = new HashMap();
            this.incoming.forEach((vertex, dependsOn) -> dependsOn.forEach(dependency -> this.outgoing.computeIfAbsent((Binding)dependency, k -> new HashSet()).add(vertex)));
            this.resolved = new HashMap();
            if (!this.resolveTrees()) {
                Set cycles = this.discoverCycles();
                this.resolveRecursionFailures(cycles);
                this.incoming.keySet().removeAll(cycles);
                boolean done = this.resolveTrees();
                assert (done);
            }
            assert (this.vertices.size() == this.resolved.size());
            this.references = null;
            this.vertices = null;
            this.incoming = null;
            this.outgoing = null;
            return this.resolved;
        }

        private String resolved(T reference) {
            return reference != null ? Nullable.toValue(this.resolved.get(reference)) : null;
        }

        private void finished(Binding<T> vertex) {
            Collection targets = this.outgoing.remove(vertex);
            if (targets == null) {
                return;
            }
            targets.forEach(target -> this.incoming.get(target).remove(vertex));
        }

        private boolean resolveTrees() {
            boolean unstable;
            Set entries = this.incoming.entrySet();
            do {
                unstable = false;
                Iterator it = entries.iterator();
                while (it.hasNext()) {
                    Map.Entry next = it.next();
                    Set sources = next.getValue();
                    if (!sources.isEmpty()) continue;
                    Binding vertex = next.getKey();
                    unstable = true;
                    Nullable<String> resolution = Nullable.of(vertex.apply(placeholder -> this.resolved(TemplateRecursion.this.linking.apply((String)placeholder, vertex.context()))));
                    Nullable<String> previous = this.resolved.put(this.references.get(vertex), resolution);
                    assert (previous == null);
                    this.finished(vertex);
                    it.remove();
                }
            } while (unstable);
            return this.incoming.isEmpty();
        }

        private void resolveRecursionFailures(Collection<Binding<T>> failed) {
            HashMap resolutions = new HashMap(failed.size());
            for (Binding vertex : failed) {
                Object placeholder = this.references.get(vertex);
                assert (!this.resolved.containsKey(placeholder));
                Nullable<String> resolution = this.handleRecursionFailure(placeholder, vertex);
                Nullable<String> previous = resolutions.put(placeholder, resolution);
                assert (previous == null);
                this.finished(vertex);
            }
            this.resolved.putAll(resolutions);
        }

        private Nullable<String> handleRecursionFailure(T reference, Binding<T> definition) {
            return Nullable.of(TemplateRecursion.this.recursionFailureHandler.handle(reference, definition, this::resolved));
        }

        private Set<Binding<T>> discoverCycles() {
            HashSet result = new HashSet();
            HashSet visited = new HashSet();
            ArrayList path = new ArrayList();
            HashMap depth = new HashMap();
            this.incoming.keySet().forEach(template -> this.discoverCycles(result::add, visited, (Binding)template, path, depth));
            return result;
        }

        private void discoverCycles(Consumer<? super Binding<T>> found, Set<Binding<T>> visited, Binding<T> vertex, List<Binding<T>> path, Map<Binding<T>, Integer> depth) {
            if (visited.contains(vertex)) {
                return;
            }
            int currentDepth = path.size();
            Integer existing = depth.putIfAbsent(vertex, currentDepth);
            if (existing != null) {
                path.listIterator(existing).forEachRemaining(found);
                return;
            }
            path.add(vertex);
            Optional.ofNullable(this.incoming.get(vertex)).ifPresent(dependsOn -> dependsOn.forEach(source -> this.discoverCycles(found, visited, (Binding)source, path, depth)));
            Integer removed = depth.remove(vertex);
            assert (removed == currentDepth);
            path.remove(currentDepth);
            assert (path.size() == currentDepth);
            visited.add(vertex);
        }

        private Binding<T> putAll(T reference, Binding<T> definition) {
            assert (this.references != null);
            assert (this.vertices != null);
            assert (this.incoming != null);
            Binding before = this.vertices.get(Objects.requireNonNull(reference));
            if (before != null) {
                assert (before.equals(definition));
                return before;
            }
            Nullable<String> cached = TemplateRecursion.this.cached(reference);
            if (cached != null) {
                return this.put(reference, cached.value(), Collections.emptySet());
            }
            HashSet placeholders = new HashSet();
            String resolution = this.decompose(definition, placeholders::add);
            if (placeholders.isEmpty()) {
                return this.put(reference, resolution, Collections.emptySet());
            }
            this.put(reference, definition);
            placeholders.forEach(placeholder -> {
                Object target = TemplateRecursion.this.linking.apply((String)placeholder, definition.context());
                if (target != null) {
                    this.incoming.computeIfAbsent(definition, k -> new HashSet()).add(this.dereference(target));
                }
            });
            this.incoming.putIfAbsent(definition, Collections.emptySet());
            return definition;
        }

        private String decompose(Template template, Consumer<? super String> placeholders) {
            return template.apply(placeholder -> {
                placeholders.accept((String)placeholder);
                return null;
            });
        }

        private Binding<T> dereference(T reference) {
            assert (reference != null);
            assert (this.vertices != null);
            assert (this.incoming != null);
            Nullable<String> cached = TemplateRecursion.this.cached(reference);
            if (cached != null) {
                return this.put(reference, cached.value(), Collections.emptySet());
            }
            Binding found = TemplateRecursion.this.lookup.apply(reference);
            if (found == null) {
                return this.put(reference, null, Collections.emptySet());
            }
            return this.putAll(reference, found);
        }

        private Binding<T> put(T reference, String value, Set<Binding<T>> dependsOn) {
            Binding result = value != null ? Binding.of(value, reference) : MissingTemplate.bind(reference);
            this.incoming.put(result, dependsOn);
            return this.put(reference, result);
        }

        private Binding<T> put(T placeholder, Binding<T> template) {
            assert (template != null);
            assert (placeholder != null);
            assert (this.vertices.size() == this.references.size());
            this.references.put(template, placeholder);
            this.vertices.put(placeholder, template);
            assert (this.vertices.size() == this.references.size());
            return template;
        }
    }

    private static final class MissingTemplate
    implements Template {
        private static final Template INSTANCE = new MissingTemplate();

        private MissingTemplate() {
        }

        public static <T> Binding<T> bind(T scope) {
            return Binding.of(INSTANCE, scope);
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public String apply(Function<? super String, String> resolver) {
            return null;
        }
    }

    private static final class Nullable<T> {
        private static final Nullable<Object> NULL = new Nullable<Object>(null);
        private final T value;

        private Nullable(T content) {
            this.value = content;
        }

        public static <T> Nullable<T> of(T value) {
            return value != null ? new Nullable<T>(value) : NULL;
        }

        public static <T> T toValue(Nullable<? extends T> nullable) {
            return nullable != null ? (T)nullable.value() : null;
        }

        public String toString() {
            return this.value != null ? String.format("Nullable[value=%s]", this.value) : "Nullable[null]";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof Nullable && Objects.equals(this.value, ((Nullable)obj).value);
        }

        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        public T value() {
            return this.value;
        }
    }

    public static final class Builder<T> {
        final Linking<T> linking;
        final Function<? super T, Binding<T>> lookup;
        RecursionFailureHandler<T> recursionFailureHandler = RecursionFailureHandler.defaultHandling();
        boolean caching;

        Builder(Linking<T> linkingStrategy, Function<? super T, Binding<T>> lookupStrategy) {
            this.linking = Objects.requireNonNull(linkingStrategy);
            this.lookup = Objects.requireNonNull(lookupStrategy);
        }

        public Builder<T> onRecursionFailure(RecursionFailureHandler<T> handler) {
            this.recursionFailureHandler = Objects.requireNonNull(handler);
            return this;
        }

        public Builder<T> caching(boolean value) {
            this.caching = value;
            return this;
        }

        public boolean caching() {
            return this.caching;
        }

        public TemplateRecursion<T> build() {
            return new TemplateRecursion(this);
        }
    }

    public static final class Source<T> {
        private static final Function<Object, String> MISSED = reference -> null;
        private final Linking<T> linking;
        private Function<? super T, String> deliveryMissedHandler = MISSED;
        private Function<? super T, String> constantHandler = MISSED;
        private Function<? super T, String> templateHandler = MISSED;
        private TemplateFormat format = Interpolation.standard();
        private ParsingFailureHandler<? super T> parsingFailureHandler = ParsingFailureHandler.defaultHandling();

        Source(Linking<T> linkStrategy) {
            this.linking = Objects.requireNonNull(linkStrategy);
        }

        public Source<T> format(TemplateFormat value) {
            this.format = Objects.requireNonNull(value);
            return this;
        }

        public TemplateFormat format() {
            return this.format;
        }

        public Source<T> constants(Function<? super T, String> handler) {
            this.constantHandler = Objects.requireNonNull(handler);
            return this;
        }

        public Source<T> templates(Function<? super T, String> handler) {
            this.templateHandler = Objects.requireNonNull(handler);
            return this;
        }

        public Source<T> onDeliveryMissed(Function<? super T, String> handler) {
            this.deliveryMissedHandler = Objects.requireNonNull(handler);
            return this;
        }

        public Source<T> onParsingFailure(ParsingFailureHandler<? super T> handler) {
            this.parsingFailureHandler = Objects.requireNonNull(handler);
            return this;
        }

        public Function<T, Binding<T>> lookup() {
            TemplateFormat templateFormat = this.format;
            Function constants = this.constantHandler;
            Function templates = this.templateHandler;
            ParsingFailureHandler parsingFailure = this.parsingFailureHandler;
            Function deliveryMissed = this.deliveryMissedHandler;
            return reference -> {
                String fallback;
                block5: {
                    if (reference == null) {
                        return null;
                    }
                    String constant = (String)constants.apply(reference);
                    if (constant != null) {
                        return Binding.of(constant, reference);
                    }
                    String template = (String)templates.apply(reference);
                    if (template != null) {
                        try {
                            return Binding.of(templateFormat.parse(template), reference);
                        }
                        catch (TemplateSyntaxException e) {
                            String fallback2 = parsingFailure.handle(reference, template, e);
                            if (fallback2 == null) break block5;
                            return Binding.of(fallback2, reference);
                        }
                    }
                }
                return (fallback = (String)deliveryMissed.apply(reference)) != null ? Binding.of(fallback, reference) : null;
            };
        }

        public Linking<T> linking() {
            return this.linking;
        }
    }

    @FunctionalInterface
    public static interface RecursionFailureHandler<T> {
        public String handle(T var1, Binding<T> var2, Function<T, String> var3);

        public static <T> RecursionFailureHandler<T> defaultHandling() {
            return (reference, definition, resolved) -> null;
        }
    }

    @FunctionalInterface
    public static interface ParsingFailureHandler<T> {
        public String handle(T var1, String var2, TemplateSyntaxException var3);

        public static <T> ParsingFailureHandler<T> defaultHandling() {
            return (reference, definition, e) -> null;
        }
    }

    public static final class Binding<T>
    implements Template {
        private final Template template;
        private final T context;

        private Binding(Template definition, T scope) {
            this.template = Objects.requireNonNull(definition);
            this.context = scope;
        }

        public static <T> Binding<T> of(Template definition, T scope) {
            return new Binding<T>(definition, scope);
        }

        public static <T> Binding<T> of(String value, T scope) {
            return Binding.of(TemplateLiteral.of(value), scope);
        }

        @Override
        public String toString() {
            return this.template.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Binding) {
                Binding o = (Binding)obj;
                return this.template.equals(o.template) && Objects.equals(this.context, o.context);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.template, this.context);
        }

        @Override
        public String apply(Function<? super String, String> resolver) {
            return this.template.apply(resolver);
        }

        public T context() {
            return this.context;
        }
    }

    @FunctionalInterface
    public static interface Linking<T>
    extends Function<String, T> {
        @Override
        default public T apply(String placeholder) {
            return this.apply(placeholder, null);
        }

        public T apply(String var1, T var2);
    }
}

