/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.template;

import java.util.Objects;
import java.util.function.Function;
import net.yetamine.template.Template;
import net.yetamine.template.TemplateDefinition;
import net.yetamine.template.TemplateFormat;
import net.yetamine.template.TemplateResolvingException;
import net.yetamine.template.TemplateSyntaxException;

final class TemplateDefinitionUnparsed
implements TemplateDefinition {
    private final String definition;
    private final TemplateFormat format;
    private volatile Template template;

    public TemplateDefinitionUnparsed(String templateDefinition, TemplateFormat templateFormat) {
        this.definition = Objects.requireNonNull(templateDefinition);
        this.format = Objects.requireNonNull(templateFormat);
    }

    @Override
    public String toString() {
        return this.definition;
    }

    @Override
    public String apply(Function<? super String, String> resolver) {
        return this.parsed().apply(resolver);
    }

    @Override
    public TemplateFormat format() {
        return this.format;
    }

    private Template parsed() {
        Template result = this.template;
        if (result == null) {
            try {
                result = this.format.parse(this.definition);
            }
            catch (TemplateSyntaxException e) {
                throw new TemplateResolvingException(e);
            }
            this.template = result;
        }
        return result;
    }
}

