/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.template;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.yetamine.template.Template;
import net.yetamine.template.TemplateCallback;
import net.yetamine.template.TemplateDefinition;
import net.yetamine.template.TemplateFactory;
import net.yetamine.template.TemplateFormat;
import net.yetamine.template.TemplateLiteral;
import net.yetamine.template.TemplateSyntaxException;

public final class Source {
    private final String value;
    private final boolean literal;

    private Source(String val, boolean lit) {
        this.value = Objects.requireNonNull(val);
        this.literal = lit;
    }

    public static Source literal(String literal) {
        return new Source(literal, true);
    }

    public static Source template(String template) {
        return new Source(template, false);
    }

    public static Source parse(String text, TemplateFormat format) {
        return new Source(text, Source.isLiteral(format, text));
    }

    public static Optional<Source> parseable(String text, TemplateFormat format) {
        try {
            return Optional.of(Source.parse(text, format));
        }
        catch (TemplateSyntaxException e) {
            return Optional.empty();
        }
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Source) {
            Source o = (Source)obj;
            return o.literal == this.literal && this.value.equals(o.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.literal, this.value);
    }

    public String literal() {
        return this.isLiteral() ? this.value : null;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public Optional<String> asLiteral() {
        return this.isLiteral() ? Optional.of(this.value) : Optional.empty();
    }

    public String template() {
        return this.isLiteral() ? null : this.value;
    }

    public boolean isTemplate() {
        return !this.literal;
    }

    public Optional<String> asTemplate() {
        return this.isLiteral() ? Optional.empty() : Optional.of(this.value);
    }

    public Template toTemplate(TemplateFormat format) {
        return this.literal ? TemplateLiteral.of(this.value) : format.parse(this.value);
    }

    public TemplateDefinition toDefinition(TemplateFormat format) {
        return TemplateDefinition.parsed(this.toTemplate(format), format);
    }

    public static Stream<Template> decomposition(TemplateFormat format, String template) {
        return format.parser(template).with(TemplateFactory.instance()).stream();
    }

    public static boolean isLiteral(TemplateFormat format, String input) {
        return format.parser(input).with(LiteralScanner.instance()).stream().allMatch(Boolean.TRUE::equals);
    }

    public static Predicate<String> isLiteral(TemplateFormat format) {
        Objects.requireNonNull(format);
        return template -> Source.isLiteral(format, template);
    }

    public static boolean isParseable(TemplateFormat format, String input) {
        try {
            return Source.isLiteral(format, input) | true;
        }
        catch (TemplateSyntaxException e) {
            return false;
        }
    }

    public static Predicate<String> isParseable(TemplateFormat format) {
        Objects.requireNonNull(format);
        return template -> Source.isParseable(format, template);
    }

    private static final class LiteralScanner
    implements TemplateCallback<Boolean> {
        private static final LiteralScanner INSTANCE = new LiteralScanner();

        private LiteralScanner() {
        }

        public static LiteralScanner instance() {
            return INSTANCE;
        }

        @Override
        public Boolean skipped(String value) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean literal(String value) {
            return Boolean.TRUE;
        }

        @Override
        public Boolean constant(String definition, String value) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean reference(String definition, String reference) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean none() {
            return Boolean.TRUE;
        }
    }
}

