/*
 * Decompiled with CFR 0.152.
 */
package net.yetamine.template;

import java.util.Objects;
import java.util.Optional;
import java.util.function.IntPredicate;
import net.yetamine.template.Symbol;
import net.yetamine.template.TemplateConstant;
import net.yetamine.template.TemplateFormat;
import net.yetamine.template.TemplateParser;
import net.yetamine.template.TemplateReference;
import net.yetamine.template.Token;
import net.yetamine.template.TokenParser;
import net.yetamine.template.TokenScanner;

public final class Interpolation
implements TemplateFormat {
    private static final TemplateFormat STANDARD = new Interpolation("${", "}", "$");
    private static final TemplateFormat REDUCED = new Interpolation("$", Interpolation::isReducedSymbolCharacter, "$");
    private final TokenScanner<? extends Symbol> scanner;
    private final String opening;
    private final String escaping;
    private final String closing;

    private Interpolation(String placeholderOpening, String placeholderClosing, String placeholderEscaping) {
        Objects.requireNonNull(placeholderClosing);
        ClosingScanner closingScanner = (input, offset) -> input.indexOf(placeholderClosing, offset);
        this.scanner = new SymbolScanner(placeholderOpening, placeholderClosing, closingScanner, placeholderEscaping);
        this.escaping = placeholderEscaping;
        this.opening = placeholderOpening;
        this.closing = placeholderClosing;
    }

    private Interpolation(String placeholderOpening, IntPredicate placeholderCharacters, String placeholderEscaping) {
        Objects.requireNonNull(placeholderCharacters);
        ClosingScanner closingScanner = (input, offset) -> Interpolation.reducedClosingScanner(input, offset, placeholderOpening, placeholderEscaping, placeholderCharacters);
        this.scanner = new SymbolScanner(placeholderOpening, null, closingScanner, placeholderEscaping);
        this.escaping = placeholderEscaping;
        this.opening = placeholderOpening;
        this.closing = null;
    }

    public static TemplateFormat with(String placeholderOpening, IntPredicate placeholderCharacters, String placeholderEscaping) {
        if (placeholderEscaping.isEmpty()) {
            throw new IllegalArgumentException("Empty escaping sequence not permitted.");
        }
        return new Interpolation(placeholderOpening, placeholderCharacters, placeholderEscaping);
    }

    public static TemplateFormat with(String placeholderOpening, IntPredicate placeholderCharacters) {
        return new Interpolation(placeholderOpening, placeholderCharacters, "");
    }

    public static TemplateFormat with(String placeholderOpening, String placeholderClosing, String placeholderEscaping) {
        if (placeholderEscaping.isEmpty()) {
            throw new IllegalArgumentException("Empty escaping sequence not permitted.");
        }
        return new Interpolation(placeholderOpening, placeholderClosing, placeholderEscaping);
    }

    public static TemplateFormat with(String placeholderOpening, String placeholderClosing) {
        return new Interpolation(placeholderOpening, placeholderClosing, "");
    }

    public static TemplateFormat standard() {
        return STANDARD;
    }

    public static TemplateFormat reduced() {
        return REDUCED;
    }

    public String toString() {
        return this.closing != null ? String.format("Interpolation[opening=%s, escaping=%s, closing=%s]", this.opening, this.closing, this.escaping) : String.format("Interpolation[opening=%s, escaping=%s]", this.opening, this.escaping);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Interpolation) {
            Interpolation o = (Interpolation)obj;
            if (!(this.opening.equals(o.opening) && this.escaping.equals(o.escaping) && Objects.equals(this.closing, o.closing))) {
                return false;
            }
            return this.closing != null || this.scanner.equals(o.scanner);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.opening, this.closing, this.escaping);
    }

    @Override
    public String constant(String string) {
        if (this.escaping.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.escape(string);
    }

    @Override
    public Optional<String> reproduction(String string) {
        return this.escaping.isEmpty() ? Optional.empty() : Optional.of(this.escape(string));
    }

    @Override
    public TemplateParser parser(String template) {
        return new TokenParser(this.scanner, template);
    }

    private String escape(String string) {
        assert (!this.escaping.isEmpty());
        int next = string.indexOf(this.opening);
        if (next == -1) {
            return string;
        }
        StringBuilder result = new StringBuilder();
        int last = 0;
        while (last < string.length()) {
            result.append(string.substring(last, next));
            result.append(this.escaping).append(this.opening);
            last = next + this.opening.length();
            if ((next = string.indexOf(this.opening, last)) != -1) continue;
            result.append(string.substring(last));
            break;
        }
        return result.toString();
    }

    private static int reducedClosingScanner(String input, int offset, String opening, String escaping, IntPredicate closing) {
        for (int i = offset; i < input.length(); ++i) {
            int escapingLength;
            if (!closing.test(input.charAt(i))) {
                return i;
            }
            int openingLength = opening.length();
            if (input.regionMatches(i, opening, 0, openingLength)) {
                return i;
            }
            if (escaping == null || !input.regionMatches(i, escaping, 0, escapingLength = escaping.length()) || !input.regionMatches(i + escapingLength, opening, 0, openingLength)) continue;
            return i;
        }
        return input.length();
    }

    private static boolean isReducedSymbolCharacter(int character) {
        return 97 <= character && character <= 122 || 65 <= character && character <= 90 || 48 <= character && character <= 57 || character == 95;
    }

    private static final class SymbolScanner
    implements TokenScanner<Symbol> {
        private final String opening;
        private final String escaping;
        private final int closingLength;
        private final ClosingScanner closingScanner;
        private final Symbol escaped;

        public SymbolScanner(String symbolOpening, String symbolClosing, ClosingScanner referenceClosingScanner, String symbolEscaping) {
            if (symbolOpening.isEmpty()) {
                throw new IllegalArgumentException("Opening sequence must not be empty.");
            }
            this.closingLength = symbolClosing != null ? symbolClosing.length() : 0;
            this.closingScanner = Objects.requireNonNull(referenceClosingScanner);
            this.opening = symbolOpening;
            this.escaping = SymbolScanner.escaping(symbolEscaping, this.opening);
            this.escaped = TemplateConstant.from(symbolEscaping + this.opening, this.opening);
        }

        @Override
        public Token<Symbol> find(String input, int offset) {
            int afterOpening;
            int closingIndex;
            int symbolIndex;
            int openingIndex = input.indexOf(this.opening, offset);
            if (openingIndex == -1) {
                return null;
            }
            if (this.escaping == null) {
                int metaLength = this.opening.length();
                if (input.regionMatches(openingIndex + metaLength, this.opening, 0, metaLength)) {
                    int afterSymbol = openingIndex + 2 * metaLength;
                    return new Token<Symbol>(this.escaped, openingIndex, afterSymbol);
                }
            } else if (!this.escaping.isEmpty() && offset <= (symbolIndex = openingIndex - this.escaping.length()) && input.regionMatches(symbolIndex, this.escaping, 0, this.escaping.length())) {
                int afterSymbol = openingIndex + this.opening.length();
                return new Token<Symbol>(this.escaped, symbolIndex, afterSymbol);
            }
            if ((closingIndex = this.closingScanner.find(input, afterOpening = openingIndex + this.opening.length())) == -1) {
                return new Token<Symbol>(this.escaped, openingIndex, afterOpening);
            }
            String value = input.substring(afterOpening, closingIndex);
            int afterSymbol = closingIndex + this.closingLength;
            String definition = input.substring(openingIndex, afterSymbol);
            return new Token<Symbol>(TemplateReference.from(definition, value), openingIndex, afterSymbol);
        }

        private static String escaping(String escaping, String opening) {
            if (escaping.equals(opening)) {
                return null;
            }
            if (escaping.contains(opening)) {
                String f = "Escaping sequence '%s' must not contain the opening sequence '%s'.";
                throw new IllegalArgumentException(String.format("Escaping sequence '%s' must not contain the opening sequence '%s'.", escaping, opening));
            }
            return escaping;
        }
    }

    @FunctionalInterface
    private static interface ClosingScanner {
        public int find(String var1, int var2);
    }
}

