/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.maven.plugins.server;

import java.io.File;
import java.text.MessageFormat;
import net.wasdev.wlp.ant.ServerTask;
import net.wasdev.wlp.maven.plugins.server.StartDebugMojoSupport;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="package-server", defaultPhase=LifecyclePhase.PACKAGE)
public class PackageServerMojo
extends StartDebugMojoSupport {
    @Parameter(property="packageFile")
    private File packageFile = null;
    @Parameter(property="include")
    private String include;
    @Parameter(property="os")
    private String os;
    @Parameter
    private boolean attach;
    @Parameter(property="skipLibertyPackage", defaultValue="false")
    protected boolean skipLibertyPackage = false;

    protected void doExecute() throws Exception {
        if (this.skip || this.skipLibertyPackage) {
            return;
        }
        if (this.isInstall) {
            this.installServerAssembly();
        } else {
            this.log.info((CharSequence)MessageFormat.format(messages.getString("info.install.type.preexisting"), ""));
            this.checkServerHomeExists();
            this.checkServerDirectoryExists();
        }
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.package"), this.serverName));
        ServerTask serverTask = this.initializeJava();
        this.copyConfigFiles();
        serverTask.setOperation("package");
        String fileType = this.getPackageFileType(this.include);
        String projectBuildDir = this.project.getBuild().getDirectory();
        String projectBuildName = this.project.getBuild().getFinalName();
        if (this.packageFile != null) {
            if (this.packageFile.isDirectory()) {
                this.packageFile = new File(this.packageFile, projectBuildName + fileType);
            }
        } else {
            this.packageFile = new File(projectBuildDir, projectBuildName + fileType);
        }
        serverTask.setArchive(this.packageFile);
        serverTask.setInclude(this.include);
        serverTask.setOs(this.os);
        this.log.info((CharSequence)MessageFormat.format(messages.getString("info.server.package.file.location"), this.packageFile.getCanonicalPath()));
        serverTask.execute();
        if (this.attach || this.project != null && "liberty-assembly".equals(this.project.getPackaging())) {
            if (this.project == null) {
                throw new MojoFailureException(MessageFormat.format(messages.getString("error.server.package.no.project"), ""));
            }
            this.project.getArtifact().setFile(this.packageFile);
        }
    }

    private String getPackageFileType(String include) {
        if (include != null && include.contains("runnable")) {
            return ".jar";
        }
        return ".zip";
    }
}

