/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.list.EqualMethodRemover;
import net.vidageek.mirror.list.SameNameMatcher;
import net.vidageek.mirror.list.dsl.MirrorList;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.reflect.dsl.MethodReflector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultMethodReflector
implements MethodReflector {
    private final String methodName;
    private final Class<?> clazz;
    private final ReflectionProvider provider;

    public DefaultMethodReflector(ReflectionProvider provider, String methodName, Class<?> clazz) {
        if (methodName == null || methodName.trim().length() == 0) {
            throw new IllegalArgumentException("methodName cannot be null or empty");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannnot be null");
        }
        this.provider = provider;
        this.methodName = methodName.trim();
        this.clazz = clazz;
    }

    @Override
    public Method withoutArgs() {
        return this.withArgs(new Class[0]);
    }

    @Override
    public Method withArgs(Class<?> ... classes) {
        if (classes == null) {
            throw new IllegalArgumentException("classes cannot be null");
        }
        return this.provider.getClassReflectionProvider(this.clazz).reflectMethod(this.methodName, classes);
    }

    @Override
    public Method withAnyArgs() {
        MirrorList<Method> sameNameList = new Mirror(this.provider).on(this.clazz).reflectAll().methods().matching(new SameNameMatcher(this.methodName));
        if (sameNameList.size() == 0) {
            return null;
        }
        ArrayList<Method> list = new ArrayList<Method>(sameNameList.matching(new EqualMethodRemover((Method)sameNameList.get(0))));
        list.add((Method)sameNameList.get(0));
        if (list.size() == 1) {
            return (Method)list.get(0);
        }
        throw new MirrorException("more than one method named " + this.methodName + " was found on class " + this.clazz.getName() + " while attempting to find a uniquely named method. Methods are: " + list);
    }
}

