/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.provider.java;

import java.lang.reflect.Field;
import net.vidageek.mirror.exception.ReflectionProviderException;
import net.vidageek.mirror.provider.FieldReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PureJavaFieldReflectionProvider
implements FieldReflectionProvider {
    private final Object target;
    private final Class<?> clazz;
    private final Field field;

    public PureJavaFieldReflectionProvider(Object target, Class<?> clazz, Field field) {
        this.target = target;
        this.clazz = clazz;
        this.field = field;
    }

    @Override
    public void setValue(Object value) {
        try {
            this.setAccessible();
            this.field.set(this.target, value);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionProviderException("could not set value " + value + " on field " + this.field.getName() + " of class " + this.clazz.getName());
        }
    }

    @Override
    public Object getValue() {
        try {
            this.setAccessible();
            return this.field.get(this.target);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionProviderException("could not get value for field " + this.field.getName() + " of class " + this.clazz.getName());
        }
    }

    @Override
    public void setAccessible() {
        this.field.setAccessible(true);
    }
}

