/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.provider.experimental.sun15;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.ReflectionProviderException;
import net.vidageek.mirror.provider.ConstructorReflectionProvider;
import net.vidageek.mirror.provider.java.DefaultMirrorReflectionProvider;
import net.vidageek.mirror.provider.java.PureJavaConstructorReflectionProvider;
import sun.misc.Unsafe;
import sun.reflect.ConstructorAccessor;
import sun.reflect.MethodAccessor;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sun15ConstructorReflectionProvider<T>
implements ConstructorReflectionProvider<T> {
    private static Unsafe unsafe;
    private static long constructorAccessorFieldOffset;
    private static MethodAccessor constructorAccessorAcquirer;
    private final ConstructorAccessor accessor;
    private final Class<T> clazz;
    private final Constructor<T> constructor;
    private static final Object[] emptyObjectArray;

    public Sun15ConstructorReflectionProvider(Class<T> clazz, Constructor<T> constructor) {
        this.clazz = clazz;
        this.constructor = constructor;
        ConstructorAccessor accessor = (ConstructorAccessor)unsafe.getObject(constructor, constructorAccessorFieldOffset);
        if (accessor == null) {
            try {
                constructorAccessorAcquirer.invoke(constructor, emptyObjectArray);
            }
            catch (IllegalArgumentException e) {
                throw new ReflectionProviderException("Could not acquire ConstructorAccessor.", e);
            }
            catch (InvocationTargetException e) {
                throw new ReflectionProviderException("Could not acquire ConstructorAccessor.", e);
            }
            accessor = (ConstructorAccessor)unsafe.getObject(constructor, constructorAccessorFieldOffset);
        }
        this.accessor = accessor;
    }

    @Override
    public Class<?>[] getParameters() {
        return new PureJavaConstructorReflectionProvider<T>(this.clazz, this.constructor).getParameters();
    }

    @Override
    public T instantiate(Object ... args) {
        try {
            return (T)this.accessor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionProviderException("could not invoke constructor " + this.constructor.toGenericString() + " on class " + this.clazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new ReflectionProviderException("could not invoke constructor " + this.constructor.toGenericString() + " on class " + this.clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ReflectionProviderException("could not invoke constructor " + this.constructor.toGenericString() + " on class " + this.clazz.getName(), e);
        }
    }

    @Override
    public void setAccessible() {
        this.constructor.setAccessible(true);
    }

    static {
        emptyObjectArray = new Object[0];
        Mirror mirror = new Mirror(new DefaultMirrorReflectionProvider());
        Field accessor = mirror.on(Constructor.class).reflect().field("constructorAccessor");
        Method acquirer = mirror.on(Constructor.class).reflect().method("acquireConstructorAccessor").withoutArgs();
        unsafe = (Unsafe)mirror.on(Unsafe.class).get().field("theUnsafe");
        constructorAccessorFieldOffset = unsafe.objectFieldOffset(accessor);
        constructorAccessorAcquirer = ReflectionFactory.getReflectionFactory().newMethodAccessor(acquirer);
    }
}

