/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.list;

import java.lang.reflect.Method;
import net.vidageek.mirror.list.dsl.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EqualMethodRemover
implements Matcher<Method> {
    private final Method method;

    public EqualMethodRemover(Method method) {
        this.method = method;
    }

    @Override
    public boolean accepts(Method element) {
        return !this.sameMethodName(element) && !this.sameArgs(element);
    }

    private boolean sameArgs(Method element) {
        if (element.getParameterTypes().length != this.method.getParameterTypes().length) {
            return false;
        }
        int i = 0;
        for (Class<?> type : this.method.getParameterTypes()) {
            if (element.getParameterTypes()[i] != type) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean sameMethodName(Method element) {
        return element.getName().equals(this.method);
    }
}

