/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.invoke;

import java.lang.reflect.Constructor;
import net.vidageek.mirror.invoke.dsl.ConstructorHandler;
import net.vidageek.mirror.provider.ConstructorBypassingReflectionProvider;
import net.vidageek.mirror.provider.ConstructorReflectionProvider;
import net.vidageek.mirror.provider.ReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstructorHandlerByConstructor<T>
implements ConstructorHandler<T> {
    private final Constructor<T> constructor;
    private final Class<T> clazz;
    private final ReflectionProvider provider;

    public ConstructorHandlerByConstructor(ReflectionProvider provider, Class<T> clazz, Constructor<T> con) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (con == null) {
            throw new IllegalArgumentException("constructor cannot be null");
        }
        if (!clazz.equals(con.getDeclaringClass())) {
            throw new IllegalArgumentException("constructor declaring type should be " + clazz.getName() + " but was " + con.getDeclaringClass().getName());
        }
        this.provider = provider;
        this.clazz = clazz;
        this.constructor = con;
    }

    @Override
    public T withArgs(Object ... args) {
        ConstructorReflectionProvider<T> constructorReflectionProvider = this.provider.getConstructorReflectionProvider(this.clazz, this.constructor);
        constructorReflectionProvider.setAccessible();
        return constructorReflectionProvider.instantiate(args);
    }

    @Override
    public T withoutArgs() {
        return this.withArgs(new Object[0]);
    }

    @Override
    public T bypasser() {
        ConstructorBypassingReflectionProvider<T> bypassingProvider = this.provider.getConstructorBypassingReflectionProvider(this.clazz);
        return bypassingProvider.bypassConstructor();
    }
}

