/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.set;

import java.lang.reflect.Field;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.set.FieldSetterByField;
import net.vidageek.mirror.set.FieldSetterByName;
import net.vidageek.mirror.set.dsl.FieldSetter;
import net.vidageek.mirror.set.dsl.SetterHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultSetterHandler
implements SetterHandler {
    private final Object target;
    private final Class<?> clazz;
    private final ReflectionProvider provider;

    public DefaultSetterHandler(ReflectionProvider provider, Object target) {
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        this.provider = provider;
        this.target = target;
        this.clazz = target.getClass();
    }

    public DefaultSetterHandler(ReflectionProvider provider, Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        this.provider = provider;
        this.clazz = clazz;
        this.target = null;
    }

    @Override
    public FieldSetter field(String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            throw new IllegalArgumentException("fieldName cannot be null or empty.");
        }
        return new FieldSetterByName(this.provider, fieldName, this.target, this.clazz);
    }

    @Override
    public FieldSetter field(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("parameter field cannot be null.");
        }
        return new FieldSetterByField(this.provider, this.target, this.clazz, field);
    }
}

