/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.mirror.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.vidageek.mirror.config.Item;
import net.vidageek.mirror.dsl.Mirror;
import net.vidageek.mirror.exception.MirrorException;
import net.vidageek.mirror.provider.ReflectionProvider;
import net.vidageek.mirror.provider.java.PureJavaReflectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MirrorProviderBuilder {
    private final URL configurationFile;

    public MirrorProviderBuilder(URL configurationFile) {
        this.configurationFile = configurationFile;
    }

    public ReflectionProvider createProvider() {
        if (this.configurationFile == null) {
            return new PureJavaReflectionProvider();
        }
        Map<Item, String> cfg = this.processProperties(this.configurationFile);
        Mirror mirror = new Mirror(new PureJavaReflectionProvider());
        return (ReflectionProvider)mirror.on(cfg.get((Object)Item.REFLECTION_PROVIDER)).invoke().constructor().withoutArgs();
    }

    private Map<Item, String> processProperties(URL file) {
        HashMap<Item, String> map = new HashMap<Item, String>();
        map.put(Item.REFLECTION_PROVIDER, PureJavaReflectionProvider.class.getName());
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(file.toURI())));
            for (Item item : Item.values()) {
                if (!properties.containsKey(item.getPropertyKey())) continue;
                map.put(item, properties.getProperty(item.getPropertyKey()).trim());
            }
        }
        catch (IOException e) {
            throw new MirrorException("could not ready file " + file, e);
        }
        catch (URISyntaxException e) {
            throw new MirrorException("could not ready file " + file, e);
        }
        return map;
    }
}

