/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.security;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.unmz.java.util.security.MD5Utils;
import net.unmz.java.util.xml.XmlUtils;
import org.apache.commons.lang3.StringUtils;

public class SignUtils {
    public static String getSign(Map<String, String> params) {
        TreeMap<String, String> sortMap = new TreeMap<String, String>(params);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry s : sortMap.entrySet()) {
            String k = (String)s.getKey();
            String v = (String)s.getValue();
            if (StringUtils.isBlank((CharSequence)v) || k.equalsIgnoreCase("sign")) continue;
            builder.append(k).append("=").append(v).append("&");
        }
        if (!sortMap.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static boolean checkSign(String xmlString) {
        Map<String, String> map = null;
        try {
            map = XmlUtils.toMap(xmlString.getBytes(), "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (map != null) {
            String signFromAPIResponse = map.get("sign");
            if (StringUtils.isBlank((CharSequence)signFromAPIResponse)) {
                System.out.println("API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6709\u53ef\u80fd\u88ab\u7b2c\u4e09\u65b9\u7be1\u6539");
                return false;
            }
            System.out.println("\u56de\u8c03\u91cc\u9762\u7684\u7b7e\u540d\u662f:" + signFromAPIResponse);
            String signForAPIResponse = SignUtils.getSign(map);
            if (!signForAPIResponse.equals(signFromAPIResponse)) {
                System.out.println("API\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u6709\u53ef\u80fd\u88ab\u7b2c\u4e09\u65b9\u7be1\u6539 signForAPIResponse\u751f\u6210\u7684\u7b7e\u540d\u4e3a " + signForAPIResponse);
                return false;
            }
            System.out.println("\u606d\u559c\uff0cAPI\u8fd4\u56de\u7684\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u901a\u8fc7");
            return true;
        }
        System.out.println("\u89e3\u6790xml\u4e3a\u7a7a\uff0c\u6570\u636e\u5f02\u5e38\u6216\u88ab\u7be1\u6539");
        return false;
    }

    public static boolean checkParam(Map<String, String> params, String key) {
        boolean result = false;
        if (params.containsKey("sign")) {
            String sign = params.get("sign");
            params.remove("sign");
            StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
            SignUtils.buildPayParams(buf, params, false);
            String preStr = buf.toString();
            String signReceive = MD5Utils.sign(preStr, "&key=" + key, "utf-8");
            result = sign.equalsIgnoreCase(signReceive);
        }
        return result;
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>(sArray.size());
        if (sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign")) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String payParamsToString(Map<String, String> payParams) {
        return SignUtils.payParamsToString(payParams, false);
    }

    public static String payParamsToString(Map<String, String> payParams, boolean encoding) {
        return SignUtils.payParamsToString(new StringBuilder(), payParams, encoding);
    }

    public static String payParamsToString(StringBuilder sb, Map<String, String> payParams, boolean encoding) {
        SignUtils.buildPayParams(sb, payParams, encoding);
        return sb.toString();
    }

    public static void buildPayParams(StringBuilder sb, Map<String, String> payParams, boolean encoding) {
        ArrayList<String> keys = new ArrayList<String>(payParams.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key).append("=");
            if (encoding) {
                sb.append(SignUtils.urlEncode(payParams.get(key)));
            } else {
                sb.append(payParams.get(key));
            }
            sb.append("&");
        }
        sb.setLength(sb.length() - 1);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Throwable e) {
            return str;
        }
    }
}

