/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.security;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.unmz.java.util.security.MD5Utils;
import org.apache.commons.lang3.StringUtils;

public class SignUtils {
    public static String getSign(Map<String, String> params) {
        TreeMap<String, String> sortMap = new TreeMap<String, String>(params);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry s : sortMap.entrySet()) {
            String k = (String)s.getKey();
            String v = (String)s.getValue();
            if (StringUtils.isBlank((CharSequence)v) || k.equalsIgnoreCase("sign")) continue;
            builder.append(k).append("=").append(v).append("&");
        }
        if (!sortMap.isEmpty()) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public static boolean checkParam(Map<String, String> params, String key) {
        boolean result = false;
        if (params.containsKey("sign")) {
            String sign = params.get("sign");
            params.remove("sign");
            StringBuilder buf = new StringBuilder((params.size() + 1) * 10);
            SignUtils.buildPayParams(buf, params, false);
            String preStr = buf.toString();
            String signReceive = MD5Utils.sign(preStr, "&key=" + key, "utf-8");
            result = sign.equalsIgnoreCase(signReceive);
        }
        return result;
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>(sArray.size());
        if (sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign")) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String payParamsToString(Map<String, String> payParams) {
        return SignUtils.payParamsToString(payParams, false);
    }

    public static String payParamsToString(Map<String, String> payParams, boolean encoding) {
        return SignUtils.payParamsToString(new StringBuilder(), payParams, encoding);
    }

    public static String payParamsToString(StringBuilder sb, Map<String, String> payParams, boolean encoding) {
        SignUtils.buildPayParams(sb, payParams, encoding);
        return sb.toString();
    }

    public static void buildPayParams(StringBuilder sb, Map<String, String> payParams, boolean encoding) {
        ArrayList<String> keys = new ArrayList<String>(payParams.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key).append("=");
            if (encoding) {
                sb.append(SignUtils.urlEncode(payParams.get(key)));
            } else {
                sb.append(payParams.get(key));
            }
            sb.append("&");
        }
        sb.setLength(sb.length() - 1);
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Throwable e) {
            return str;
        }
    }
}

