/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static final String DATE_FORMAT_DATE_ONLY = "yyyy-MM-dd";
    public static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DATETIME_14 = "yyyyMMddHHmmss";
    public static final String SHORT_DATE_FORMAT = "yyyyMMdd";
    public static final String HMS_FORMAT = "HH:mm:ss";
    private static DateUtils dateUtil = new DateUtils();
    public static final String ISO_DATE_FORMAT = "yyyyMMdd";
    public static final String ISO_EXPANDED_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_SHORT_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    public static String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String CHINESE_EXPANDED_DATE_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String TAIWAN_DATE_FORMAT = "yyyy/MM/ddHHmm";
    private static boolean LENIENT_DATE = false;

    private DateUtils() {
    }

    public static DateUtils getInstance() {
        return dateUtil;
    }

    public static Date dateFormart(Date date) {
        return DateUtils.stringToDate(DateUtils.dateToString(date, "yyyy-MM-dd"));
    }

    protected static final float normalizedJulian(float JD) {
        float f = (float)Math.round(JD + 0.5f) - 0.5f;
        return f;
    }

    public static String getGrpEndDate(String effdate, String loadEndDate, String loadBeginDate) {
        long qoutDays = DateUtils.getDateQuot(effdate, loadEndDate);
        String endDate = "";
        endDate = qoutDays >= 365L ? DateUtils.dateToString(DateUtils.addDay(DateUtils.addYear(DateUtils.stringToDate(loadBeginDate), 1), -1), "yyyy-MM-dd") : loadEndDate;
        return endDate;
    }

    public static final Date toDate(float JD) {
        float Z = DateUtils.normalizedJulian(JD) + 0.5f;
        float W = (int)((Z - 1867216.2f) / 36524.25f);
        float X = (int)(W / 4.0f);
        float A = Z + 1.0f + W - X;
        float B = A + 1524.0f;
        float C = (int)(((double)B - 122.1) / 365.25);
        float D = (int)(365.25f * C);
        float E = (int)((double)(B - D) / 30.6001);
        float F = (int)(30.6001f * E);
        int day = (int)(B - D - F);
        int month = (int)(E - 1.0f);
        if (month > 12) {
            month -= 12;
        }
        int year = (int)(C - 4715.0f);
        if (month > 2) {
            --year;
        }
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return c.getTime();
    }

    public static final int daysBetween(Date early, Date late) {
        GregorianCalendar calst = new GregorianCalendar();
        GregorianCalendar caled = new GregorianCalendar();
        calst.setTime(early);
        caled.setTime(late);
        calst.set(11, 0);
        calst.set(12, 0);
        calst.set(13, 0);
        caled.set(11, 0);
        caled.set(12, 0);
        caled.set(13, 0);
        int days = ((int)(caled.getTime().getTime() / 1000L) - (int)(calst.getTime().getTime() / 1000L)) / 3600 / 24;
        return days;
    }

    public static final int daysBetween(Calendar early, Calendar late) {
        return (int)(DateUtils.toJulian(late) - DateUtils.toJulian(early));
    }

    public static final float toJulian(Calendar c) {
        int Y = c.get(1);
        int M = c.get(2);
        int D = c.get(5);
        int A = Y / 100;
        int B = A / 4;
        int C = 2 - A + B;
        float E = (int)(365.25f * (float)(Y + 4716));
        float F = (int)(30.6001f * (float)(M + 1));
        float JD = (float)(C + D) + E + F - 1524.5f;
        return JD;
    }

    public static final float toJulian(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return DateUtils.toJulian(c);
    }

    public static final String dateIncrease(String isoString, String fmt, int field, int amount) {
        try {
            Calendar cal = GregorianCalendar.getInstance();
            cal.setTime(DateUtils.stringToDate(isoString, fmt, true));
            cal.add(field, amount);
            return DateUtils.dateToString(cal.getTime(), fmt);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static final String roll(String isoString, String fmt, int field, boolean up) throws ParseException {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(DateUtils.stringToDate(isoString, fmt));
        cal.roll(field, up);
        return DateUtils.dateToString(cal.getTime(), fmt);
    }

    public static final String roll(String isoString, int field, boolean up) throws ParseException {
        return DateUtils.roll(isoString, DATETIME_PATTERN, field, up);
    }

    public static Date stringToDate(String dateText, String format, boolean lenient) {
        if (dateText == null) {
            return null;
        }
        SimpleDateFormat df = null;
        try {
            df = format == null ? new SimpleDateFormat() : new SimpleDateFormat(format);
            df.setLenient(false);
            return df.parse(dateText);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date stringToDate(String dateString, String format) {
        return DateUtils.stringToDate(dateString, format, LENIENT_DATE);
    }

    public static Date stringToDate(String dateString) {
        if (!"".equals(dateString) && dateString != null) {
            if (dateString.trim().length() == 8) {
                return DateUtils.stringToDate(dateString, "yyyyMMdd", LENIENT_DATE);
            }
            if (dateString.trim().length() == 10) {
                return DateUtils.stringToDate(dateString, "yyyy-MM-dd", LENIENT_DATE);
            }
            if (dateString.trim().length() == 19) {
                return DateUtils.stringToDate(dateString, DATETIME_PATTERN, LENIENT_DATE);
            }
            if (dateString.trim().length() == 11) {
                return DateUtils.stringToDate(dateString, CHINESE_EXPANDED_DATE_FORMAT, LENIENT_DATE);
            }
        }
        return null;
    }

    public static String dateToString(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat sfDate = new SimpleDateFormat(pattern);
            sfDate.setLenient(false);
            return sfDate.format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String dateToString(Date date) {
        return DateUtils.dateToString(date, "yyyy-MM-dd");
    }

    public static Date getCurrentDateTime() {
        Calendar calNow = Calendar.getInstance();
        Date dtNow = calNow.getTime();
        return dtNow;
    }

    public static String getCurrentDateString(String pattern) {
        return DateUtils.dateToString(DateUtils.getCurrentDateTime(), pattern);
    }

    public static String getCurrentDateString() {
        return DateUtils.dateToString(DateUtils.getCurrentDateTime(), "yyyy-MM-dd");
    }

    public static String dateToStringWithTime(Date date) {
        return DateUtils.dateToString(date, DATETIME_PATTERN);
    }

    public static Date dateIncreaseByDay(Date date, int days) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static Date dateIncreaseByMonth(Date date, int mnt) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.add(2, mnt);
        return cal.getTime();
    }

    public static Date dateIncreaseByYear(Date date, int mnt) {
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date);
        cal.add(1, mnt);
        return cal.getTime();
    }

    public static String dateIncreaseByYearforString(String date, int mnt) {
        Date date1 = DateUtils.stringToDate(date);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTime(date1);
        cal.add(1, mnt);
        String ss = DateUtils.dateToString(cal.getTime(), "yyyyMMdd");
        return DateUtils.dateIncreaseByDay(ss, -1);
    }

    public static String dateIncreaseByDay(String date, int days) {
        return DateUtils.dateIncreaseByDay(date, "yyyyMMdd", days);
    }

    public static String dateIncreaseByDay(String date, String fmt, int days) {
        return DateUtils.dateIncrease(date, fmt, 5, days);
    }

    public static String stringToString(String dateString, String desfmt) {
        if (dateString.trim().length() == 8) {
            return DateUtils.stringToString(dateString, "yyyyMMdd", desfmt);
        }
        if (dateString.trim().length() == 10) {
            return DateUtils.stringToString(dateString, "yyyy-MM-dd", desfmt);
        }
        if (dateString.trim().length() == 19) {
            return DateUtils.stringToString(dateString.substring(0, 10), "yyyy-MM-dd", desfmt);
        }
        if (dateString.trim().length() == 11) {
            return DateUtils.stringToString(dateString, CHINESE_EXPANDED_DATE_FORMAT, desfmt);
        }
        return null;
    }

    public static String stringToString(String src, String srcfmt, String desfmt) {
        return DateUtils.dateToString(DateUtils.stringToDate(src, srcfmt), desfmt);
    }

    public static String getPolicyEndDate(String src, String srcfmt, String desfmt) {
        if (src == null || src.trim().equals("") || src.length() < 23) {
            return null;
        }
        src = src.substring(12, 23);
        return DateUtils.stringToString(src, srcfmt, desfmt);
    }

    public static String getPolicyEffDate(String src, String srcfmt, String desfmt) {
        if (src == null || src.trim().equals("") || src.length() < 23) {
            return null;
        }
        src = src.substring(0, 11);
        return DateUtils.stringToString(src, srcfmt, desfmt);
    }

    public static String getChineseDate(String src) {
        String renStr = null;
        if (!"".equals(src) && src != null) {
            renStr = src.substring(0, 4) + "\u5e74" + src.substring(5, 6) + "\u6708" + src.substring(6, 8) + "\u65e5";
        }
        return renStr;
    }

    public static long getDateQuot(String time1, String time2) {
        long quot = 0L;
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date1 = ft.parse(time1);
            Date date2 = ft.parse(time2);
            quot = date2.getTime() - date1.getTime();
            quot = quot / 1000L / 60L / 60L / 24L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return quot;
    }

    public static Date addYear(Date date1, int addYear) {
        Date resultDate = null;
        Calendar c = Calendar.getInstance();
        c.setTime(date1);
        c.add(1, addYear);
        resultDate = c.getTime();
        return resultDate;
    }

    public static Date addMonth(Date date1, int addMonth) {
        Date resultDate = null;
        Calendar c = Calendar.getInstance();
        c.setTime(date1);
        c.add(2, addMonth);
        resultDate = c.getTime();
        return resultDate;
    }

    public static Date addDay(Date date1, int addDay) {
        Date resultDate = null;
        Calendar c = Calendar.getInstance();
        c.setTime(date1);
        c.add(5, addDay);
        resultDate = c.getTime();
        return resultDate;
    }

    public static String addDayByString(String date, int addDay) {
        String retDate = "";
        if (date == null || "".equals(date) || "".equals(date.replaceAll("-", "").trim())) {
            return retDate;
        }
        Date date1 = DateUtils.stringToDate(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date1);
        c.add(5, addDay);
        Date resultDate = c.getTime();
        return DateUtils.dateToString(resultDate);
    }

    public static String getFirstDayOfMonth(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        return DateUtils.dateToString(firstDate);
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(5, 1);
        Date firstDate = ca.getTime();
        return DateUtils.addDay(DateUtils.addMonth(firstDate, 1), -1);
    }

    public static Date getDateStart(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(10, 0);
        ca.set(12, 0);
        ca.set(13, 0);
        return ca.getTime();
    }

    public static Date getDateEnd(Date date) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.set(10, 23);
        ca.set(12, 59);
        ca.set(13, 59);
        return ca.getTime();
    }

    public ArrayList<Date> getDateList(Date startTime, Date endTime) {
        ArrayList<Date> timeList = new ArrayList<Date>();
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        timeList.add(cal.getTime());
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(startTime);
        endCalendar.setTime(endTime);
        long startMill = startCalendar.getTimeInMillis();
        long endMill = endCalendar.getTimeInMillis();
        while (startMill < endMill) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(startMill += 86400000L);
            timeList.add(calendar.getTime());
        }
        return timeList;
    }

    public static String getPreOrNextDay(Date date, int num) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, num);
        Date firstDate = ca.getTime();
        return DateUtils.dateToString(firstDate);
    }
}

