/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.express;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.unmz.java.util.express.ExpResultInfoVo;
import net.unmz.java.util.http.HttpUtils;
import net.unmz.java.util.json.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class QueryExpInfoUtils {
    public static String queryExpInfoPrintStr(String orderNo, String type) {
        QueryHeard queryHeard = new QueryHeard(orderNo, type).invoke();
        String host = queryHeard.getHost();
        String path = queryHeard.getPath();
        Map<String, String> headers = queryHeard.getHeaders();
        Map<String, String> queries = queryHeard.getQueries();
        ExpResultInfoVo dto = null;
        try {
            dto = QueryExpInfoUtils.getExpResultInfoDto(host, path, headers, queries);
            StringBuilder str = new StringBuilder();
            for (ExpResultInfoVo.ExpResultListVo.ExpResultListResultVo list : dto.getResult().getList()) {
                str.append(list.getTime()).append(" ").append(list.getStatus()).append("\n");
            }
            return str.toString();
        }
        catch (Exception e) {
            return dto != null ? dto.getMsg() : null;
        }
    }

    public static List<String> queryExpInfoPrintList(String orderNo, String type) {
        QueryHeard queryHeard = new QueryHeard(orderNo, type).invoke();
        String host = queryHeard.getHost();
        String path = queryHeard.getPath();
        Map<String, String> headers = queryHeard.getHeaders();
        Map<String, String> queries = queryHeard.getQueries();
        ExpResultInfoVo dto = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            dto = QueryExpInfoUtils.getExpResultInfoDto(host, path, headers, queries);
            StringBuilder str = new StringBuilder();
            for (ExpResultInfoVo.ExpResultListVo.ExpResultListResultVo list : dto.getResult().getList()) {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append(list.getTime()).append(" ").append(list.getStatus()).append("\n");
                str.append((CharSequence)strBuilder);
                arrayList.add(strBuilder.toString());
            }
            return arrayList;
        }
        catch (Exception e) {
            arrayList.add(dto != null ? dto.getMsg() : null);
            return arrayList;
        }
    }

    public static ExpResultInfoVo getExpInfo(String orderNo, String type) {
        QueryHeard queryHeard = new QueryHeard(orderNo, type).invoke();
        String host = queryHeard.getHost();
        String path = queryHeard.getPath();
        Map<String, String> headers = queryHeard.getHeaders();
        Map<String, String> queries = queryHeard.getQueries();
        try {
            return QueryExpInfoUtils.getExpResultInfoDto(host, path, headers, queries);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String printExpInfoStr(ExpResultInfoVo dto) {
        if (null == dto) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (ExpResultInfoVo.ExpResultListVo.ExpResultListResultVo list : dto.getResult().getList()) {
            str.append(list.getTime()).append(" ").append(list.getStatus()).append("\n");
        }
        return str.toString();
    }

    public static ExpResultInfoVo getExpResultInfoDto(String host, String path, Map<String, String> headers, Map<String, String> queries) throws Exception {
        HttpResponse response = HttpUtils.doGet(host, path, headers, queries);
        String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
        return JsonUtils.toBean(result, ExpResultInfoVo.class);
    }

    public static class QueryHeard {
        private String orderNo;
        private String type;
        private String host;
        private String path;
        private String appCode;
        private Map<String, String> headers;
        private Map<String, String> queries;

        public QueryHeard(String orderNo, String type) {
            this.orderNo = orderNo;
            this.type = type;
        }

        public String getHost() {
            return this.host;
        }

        public String getPath() {
            return this.path;
        }

        public String getAppCode() {
            return this.appCode;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public Map<String, String> getQueries() {
            return this.queries;
        }

        public QueryHeard invoke() {
            this.host = "http://wuliu.market.alicloudapi.com";
            this.path = "/kdi";
            String appCode = this.appCode != null ? this.appCode : "9576f987c8d3458eaad2c5b645c19b95";
            this.headers = new HashMap<String, String>();
            this.headers.put("Authorization", "APPCODE " + appCode);
            this.queries = new HashMap<String, String>();
            this.queries.put("no", this.orderNo);
            if (StringUtils.isNotBlank((CharSequence)this.type)) {
                this.queries.put("type", this.type);
            }
            return this;
        }
    }
}

