/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import javax.imageio.ImageIO;

public class QRCodeUtils {
    private static final String CHARSET = "utf-8";
    private static final int QR_CODE_SIZE = 400;
    private static final int WIDTH = 80;
    private static final int HEIGHT = 80;

    public static BufferedImage createImageByUrl(String url, String logoUrl) throws Exception {
        return QRCodeUtils.createImage(QRCodeUtils.getQrCodeUrlContent(url), logoUrl);
    }

    public static BufferedImage createImage(String content) throws Exception {
        return QRCodeUtils.createImage(content, null);
    }

    public static BufferedImage createImage(String content, String logoUrl) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.Q);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        hints.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 400, 400, hints);
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
            }
        }
        if (logoUrl == null) {
            return image;
        }
        BufferedImage src = ImageIO.read(new URL(logoUrl));
        int width2 = ((Image)src).getWidth(null);
        int height2 = ((Image)src).getHeight(null);
        if (width2 > 80) {
            width2 = 80;
        }
        if (height2 > 80) {
            height2 = 80;
        }
        Image logoImg = src.getScaledInstance(width2, height2, 4);
        BufferedImage tag = new BufferedImage(width2, height2, 2);
        Graphics g = tag.getGraphics();
        g.drawImage(logoImg, 0, 0, null);
        g.dispose();
        Graphics2D graph = image.createGraphics();
        int x = (400 - width2) / 2;
        int y = (400 - height2) / 2;
        graph.drawImage(logoImg, x, y, width2, height2, Color.WHITE, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width2, width2, 5.0f, 5.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
        return image;
    }

    public static String getQrCodeUrlContent(String url) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(new URL(url).openStream());
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(bufferedImage);
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)binarizer);
        HashMap<DecodeHintType, String> decodeHints = new HashMap<DecodeHintType, String>();
        decodeHints.put(DecodeHintType.CHARACTER_SET, CHARSET);
        Result result = new MultiFormatReader().decode(bitmap, decodeHints);
        return result.getText();
    }

    public static void main(String[] args) throws Exception {
        String text = "https://www.baidu.com";
        String logoPath = "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2957705046,1654500225&fm=26&gp=0.jpg";
        String destPath = "E:\\demo\\";
        String fileName = destPath + UUID.randomUUID().toString().replace("-", "") + ".png";
        ImageIO.write((RenderedImage)QRCodeUtils.createImage(text, logoPath), "png", new File(fileName));
        System.out.println(fileName);
    }
}

