/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.security;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class AESUtils {
    private static final String ALGORITHM = "AES";
    private static final String ALGORITHM_MODE_PADDING = "AES/ECB/PKCS5Padding";

    public static String encryptData(String key, String encryptedData, String iv) throws Exception {
        return AESUtils.encode(encryptedData, key, iv.getBytes());
    }

    public static String decryptData(String key, String decryptedData, String iv) throws Exception {
        return AESUtils.decode(decryptedData, key, iv.getBytes());
    }

    public static String encode(String content, String secret) {
        return AESUtils.encode(content, secret, null);
    }

    public static String decode(String content, String secret) {
        return AESUtils.decode(content, secret, null);
    }

    public static String encode(String content, String secret, byte[] iv) {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(ALGORITHM);
            keygen.init(256, new SecureRandom(secret.getBytes(StandardCharsets.UTF_8)));
            SecretKey original_key = keygen.generateKey();
            byte[] raw = original_key.getEncoded();
            SecretKeySpec key = new SecretKeySpec(raw, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            if (iv != null && iv.length == 16) {
                cipher.init(1, (Key)key, new IvParameterSpec(iv));
            } else {
                cipher.init(1, key);
            }
            byte[] byte_encode = content.getBytes(StandardCharsets.UTF_8);
            byte[] byte_AES = cipher.doFinal(byte_encode);
            return new BASE64Encoder().encode(byte_AES);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decode(String content, String secret, byte[] iv) {
        try {
            KeyGenerator keygen = KeyGenerator.getInstance(ALGORITHM);
            keygen.init(256, new SecureRandom(secret.getBytes(StandardCharsets.UTF_8)));
            SecretKey original_key = keygen.generateKey();
            byte[] raw = original_key.getEncoded();
            SecretKeySpec key = new SecretKeySpec(raw, ALGORITHM);
            Security.addProvider((Provider)new BouncyCastleProvider());
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            if (iv != null && iv.length == 16) {
                cipher.init(2, (Key)key, new IvParameterSpec(iv));
            } else {
                cipher.init(2, key);
            }
            byte[] byte_content = new BASE64Decoder().decodeBuffer(content);
            byte[] byte_decode = cipher.doFinal(byte_content);
            return new String(byte_decode, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptDataPKCS5Padding(String content, String secret) throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance(ALGORITHM);
        keygen.init(256, new SecureRandom(secret.getBytes(StandardCharsets.UTF_8)));
        SecretKey original_key = keygen.generateKey();
        byte[] raw = original_key.getEncoded();
        SecretKeySpec key = new SecretKeySpec(raw, ALGORITHM);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(ALGORITHM_MODE_PADDING);
        cipher.init(1, key);
        byte[] byte_encode = content.getBytes(StandardCharsets.UTF_8);
        byte[] byte_AES = cipher.doFinal(byte_encode);
        return new BASE64Encoder().encode(byte_AES);
    }

    public static String decryptDatePKCS5Padding(String content, String secret) throws Exception {
        KeyGenerator keygen = KeyGenerator.getInstance(ALGORITHM);
        keygen.init(256, new SecureRandom(secret.getBytes(StandardCharsets.UTF_8)));
        SecretKey original_key = keygen.generateKey();
        byte[] raw = original_key.getEncoded();
        SecretKeySpec key = new SecretKeySpec(raw, ALGORITHM);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(ALGORITHM_MODE_PADDING);
        cipher.init(2, key);
        byte[] byte_content = new BASE64Decoder().decodeBuffer(content);
        byte[] byte_decode = cipher.doFinal(byte_content);
        return new String(byte_decode, StandardCharsets.UTF_8);
    }
}

