/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.data;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.unmz.java.util.data.ValidateLength;

public class DataLengthCheckHelper {
    public static void validateAttributeValueLength(Object obj) throws IllegalArgumentException {
        if (null != obj) {
            Class<?> cls = obj.getClass();
            Field[] fields = cls.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    Field field = fields[i];
                    Annotation[] annotations = field.getAnnotations();
                    ValidateLength dataLength = null;
                    for (Annotation annotation : annotations) {
                        if (!(annotation instanceof ValidateLength)) continue;
                        dataLength = (ValidateLength)annotation;
                    }
                    if (null == dataLength) continue;
                    field.setAccessible(true);
                    String name = field.getName();
                    Object value = field.get(obj);
                    if (value == null && !dataLength.nullable()) {
                        throw new IllegalArgumentException(name + " is null");
                    }
                    int length = dataLength.value();
                    int valueLength = 0;
                    if (value instanceof String) {
                        String data = (String)value;
                        valueLength = data.length();
                    }
                    if (valueLength <= length) continue;
                    throw new IllegalArgumentException(name + " length:" + valueLength + " too long");
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

