/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.date;

import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static final String DATE_FORMAT_DATE_ONLY = "yyyy-MM-dd";
    public static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DATETIME_14 = "yyyyMMddHHmmss";
    public static final String SHORT_DATE_FORMAT = "yyyyMMdd";
    public static final String HMS_FORMAT = "HH:mm:ss";

    public static LocalDateTime parseLocalDateTime(String str) throws ParseException {
        return LocalDateTime.parse(str, DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static LocalDate parseLocalDate(String str) throws ParseException {
        return LocalDate.parse(str, DateTimeFormatter.ofPattern(DATE_FORMAT_DATE_ONLY));
    }

    public static long nowTimeMillis() {
        return Clock.systemDefaultZone().millis();
    }

    public static long nowEpochSecond() {
        return Clock.systemDefaultZone().instant().getEpochSecond();
    }

    public static Instant nowTimestamp() {
        return Instant.now(Clock.systemDefaultZone());
    }

    public static String getCurrentDate() {
        return LocalDate.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATE_ONLY));
    }

    public static String getCurrentDateTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static String getCurrentDateTime(String format) {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern(format));
    }

    public static String getCurrentTime() {
        return LocalTime.now().format(DateTimeFormatter.ofPattern(HMS_FORMAT));
    }

    public static String formaterDate(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATE_ONLY));
    }

    public static String formaterDateToyyyyMMdd(LocalDate date) {
        return date.format(DateTimeFormatter.ofPattern(SHORT_DATE_FORMAT));
    }

    public static String formaterLocalDateTime(LocalDateTime dateTime) {
        return dateTime.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static String formaterLocalDateTime14(LocalDateTime dateTime) {
        return dateTime.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME_14));
    }

    public static String parseInstantToDataStr(Instant instant) throws ParseException {
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static String getTimeStampStr(LocalDateTime date) {
        return date.toInstant(ZoneOffset.UTC).toString();
    }

    public static LocalDateTime addSecond(LocalDateTime date, int second) {
        return date.plusSeconds(second);
    }

    public static LocalDateTime addMinute(LocalDateTime date, int minute) {
        return date.plusMinutes(minute);
    }

    public static LocalDateTime addHour(LocalDateTime date, int hour) {
        return date.plusHours(hour);
    }

    public static LocalDateTime addDay(LocalDateTime date, int day) {
        return date.plusDays(day);
    }

    public static LocalDateTime addMoth(LocalDateTime date, int month) {
        return date.plusMonths(month);
    }

    public static LocalDateTime addYear(LocalDateTime date, int year) {
        return date.plusYears(year);
    }

    public static String getDayStart(LocalDate date) {
        LocalDateTime localDateTime = LocalDateTime.of(date, LocalTime.of(0, 0, 0));
        return localDateTime.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static String getDayEnd(LocalDate date) {
        LocalDateTime localDateTime = LocalDateTime.of(date, LocalTime.of(23, 59, 59));
        return localDateTime.format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATETIME));
    }

    public static Instant parseDataStrToInstant(String dateStr) throws ParseException {
        return DateUtils.parseLocalDateTime(dateStr).toInstant(ZoneOffset.UTC);
    }

    public static long getYearsBetween(LocalDate t1, LocalDate t2) {
        return t1.until(t2, ChronoUnit.YEARS);
    }

    public static long getDaysBetween(LocalDate t1, LocalDate t2) {
        return t1.until(t2, ChronoUnit.DAYS);
    }

    public static long getMonthsBetween(LocalDate t1, LocalDate t2) {
        return t1.until(t2, ChronoUnit.MONTHS);
    }

    public static long getHoursBetween(LocalDateTime t1, LocalDateTime t2) {
        return t1.until(t2, ChronoUnit.HOURS);
    }

    public static long getSecondsBetween(LocalDateTime t1, LocalDateTime t2) {
        return t1.until(t2, ChronoUnit.SECONDS);
    }

    public static long getMinutesBetween(LocalDateTime t1, LocalDateTime t2) {
        return t1.until(t2, ChronoUnit.MINUTES);
    }

    public static DayOfWeek getWeek() {
        return LocalDate.now().getDayOfWeek();
    }

    public static boolean isBetween(LocalDateTime date, LocalDateTime start, LocalDateTime end) {
        if (date == null || start == null || end == null) {
            throw new IllegalArgumentException("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return date.isAfter(start) && date.isBefore(end);
    }

    public static LocalDate getWeekStart(LocalDate date) {
        return date.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
    }

    public static LocalDate getWeekEnd(LocalDate date) {
        return date.with(TemporalAdjusters.previousOrSame(DayOfWeek.SUNDAY));
    }

    public static LocalDate getMonthEnd(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate getMonthStart(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getYearStart(LocalDate date) {
        return date.with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDate getYearEnd(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfYear());
    }

    public static LocalDate getSeasonStart(LocalDate date) {
        return DateUtils.getSeasonDate(date)[0];
    }

    public static LocalDate getSeasonEnd(LocalDate date) {
        return DateUtils.getSeasonDate(date)[2].with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate[] getSeasonDate(LocalDate date) {
        LocalDate[] season = new LocalDate[3];
        int nSeason = DateUtils.getSeason(date);
        int year = date.getYear();
        if (nSeason == 1) {
            season[0] = LocalDate.of(year, Month.JANUARY, 1);
            season[1] = LocalDate.of(year, Month.FEBRUARY, 1);
            season[2] = LocalDate.of(year, Month.MARCH, 1);
        } else if (nSeason == 2) {
            season[0] = LocalDate.of(year, Month.APRIL, 1);
            season[1] = LocalDate.of(year, Month.MAY, 1);
            season[2] = LocalDate.of(year, Month.JUNE, 1);
        } else if (nSeason == 3) {
            season[0] = LocalDate.of(year, Month.JULY, 1);
            season[1] = LocalDate.of(year, Month.AUGUST, 1);
            season[2] = LocalDate.of(year, Month.SEPTEMBER, 1);
        } else if (nSeason == 4) {
            season[0] = LocalDate.of(year, Month.OCTOBER, 1);
            season[1] = LocalDate.of(year, Month.NOVEMBER, 1);
            season[2] = LocalDate.of(year, Month.DECEMBER, 1);
        }
        return season;
    }

    public static int getSeason(LocalDate date) {
        int season = 0;
        Month month = date.getMonth();
        switch (month) {
            case JANUARY: 
            case FEBRUARY: 
            case MARCH: {
                season = 1;
                break;
            }
            case APRIL: 
            case MAY: 
            case JUNE: {
                season = 2;
                break;
            }
            case JULY: 
            case AUGUST: 
            case SEPTEMBER: {
                season = 3;
                break;
            }
            case OCTOBER: 
            case NOVEMBER: 
            case DECEMBER: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static String subDays(int days) {
        return LocalDate.now().minusDays(days).format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATE_ONLY));
    }

    public static boolean isOverIntervalLimit(LocalDate startDate, LocalDate endDate, int interval) {
        return DateUtils.getDaysBetween(startDate, endDate) >= (long)interval;
    }

    public static String getYesterday() {
        return DateUtils.getYesterday(LocalDate.now());
    }

    public static String getYesterday(LocalDate date) {
        return date.minusDays(1L).format(DateTimeFormatter.ofPattern(DATE_FORMAT_DATE_ONLY));
    }

    public static LocalDate getPreviousMonthFirstDay() {
        return LocalDate.now().minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDate getPreviousMonthLastDay() {
        return LocalDate.now().minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static Date getTimesmorning() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static LocalDateTime getAWeekFromNow() {
        LocalDateTime date = LocalDateTime.now();
        return date.plusWeeks(-1L);
    }

    public static LocalDateTime getAMonthFromNow() {
        LocalDateTime date = LocalDateTime.now();
        return date.plusMonths(-1L);
    }

    public static LocalDateTime getThreeMonthFromNow() {
        LocalDateTime date = LocalDateTime.now();
        return date.plusMonths(-1L);
    }

    public static LocalDateTime getAYearFromNow() {
        LocalDateTime date = LocalDateTime.now();
        return date.plusYears(-1L);
    }

    public String toString() {
        return super.toString();
    }

    public static String timestampToDateStr(String timestamp) throws ParseException {
        Long timestampL = Long.parseLong(timestamp);
        return DateUtils.parseInstantToDataStr(new Date(timestampL).toInstant());
    }

    public static String getDate(Timestamp startTime, Timestamp endTime) {
        LocalDateTime start = startTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime end = endTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        long min = DateUtils.getMinutesBetween(start, end);
        String remainDays = "";
        long day = min / 60L / 24L;
        long hour = min / 60L - day * 24L;
        long minutes = min - hour * 60L - day * 24L * 60L;
        if (day > 0L) {
            remainDays = remainDays + day + "\u5929";
        }
        if (hour > 0L || hour == 0L && minutes > 0L) {
            remainDays = remainDays + hour + "\u5c0f\u65f6";
        }
        if (minutes > 0L) {
            remainDays = remainDays + minutes + "\u5c0f\u65f6";
        }
        return remainDays;
    }
}

