/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.map;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MapUtils {
    public static Map<String, String> objectToMap(Object obj) throws Exception {
        if (null != obj) {
            PropertyDescriptor[] propertyDescriptors;
            HashMap<String, String> map = new HashMap<String, String>();
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.compareToIgnoreCase("class") == 0) continue;
                Method getter = property.getReadMethod();
                String value = getter != null ? getter.invoke(obj, new Object[0]).toString() : null;
                map.put(key, value);
            }
            return map;
        }
        return null;
    }

    public static Object mapToObject(Map map, Class<?> beanClass) throws Exception {
        PropertyDescriptor[] propertyDescriptors;
        if (null != map) {
            return null;
        }
        Object obj = beanClass.newInstance();
        BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
        for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            Method setter = property.getWriteMethod();
            if (setter == null) continue;
            setter.invoke(obj, map.get(property.getName()));
        }
        return obj;
    }
}

