/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.xml;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;

public class JaxbUtils {
    private JAXBContext jaxbContext;

    public JaxbUtils(Class<?> ... types) {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])types);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml(Object root, String encoding) {
        try {
            StringWriter writer = new StringWriter();
            this.createMarshaller(encoding).marshal(root, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public String toXml(Collection root, String rootName, String encoding) {
        try {
            CollectionWrapper wrapper = new CollectionWrapper();
            wrapper.collection = root;
            JAXBElement wrapperElement = new JAXBElement(new QName(rootName), CollectionWrapper.class, (Object)wrapper);
            StringWriter writer = new StringWriter();
            this.createMarshaller(encoding).marshal((Object)wrapperElement, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromXml(String xml) {
        try {
            StringReader reader = new StringReader(xml);
            return (T)this.createUnmarshaller().unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T fromXml(String xml, boolean caseSensitive) {
        try {
            String fromXml = xml;
            if (!caseSensitive) {
                fromXml = xml.toLowerCase();
            }
            StringReader reader = new StringReader(fromXml);
            return (T)this.createUnmarshaller().unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Marshaller createMarshaller(String encoding) {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            if (StringUtils.isNotBlank((CharSequence)encoding)) {
                marshaller.setProperty("jaxb.encoding", (Object)encoding);
            }
            return marshaller;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Unmarshaller createUnmarshaller() {
        try {
            return this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CollectionWrapper {
        @XmlAnyElement
        protected Collection collection;
    }
}

