/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.maven.plugins;

import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheResolver;
import java.io.File;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepositoryManager;

public class RepositoryCacheResolver
implements CacheResolver {
    private static final String GROUP_ID = "com.github.eirslett";
    private final RepositorySystemSession repositorySystemSession;

    public RepositoryCacheResolver(RepositorySystemSession repositorySystemSession) {
        this.repositorySystemSession = repositorySystemSession;
    }

    public File resolve(CacheDescriptor cacheDescriptor) {
        LocalRepositoryManager manager = this.repositorySystemSession.getLocalRepositoryManager();
        File localArtifact = new File(manager.getRepository().getBasedir(), manager.getPathForLocalArtifact((Artifact)this.createArtifact(cacheDescriptor)));
        return localArtifact;
    }

    private DefaultArtifact createArtifact(CacheDescriptor cacheDescriptor) {
        String version = cacheDescriptor.getVersion().replaceAll("^v", "");
        DefaultArtifact artifact = cacheDescriptor.getClassifier() == null ? new DefaultArtifact(GROUP_ID, cacheDescriptor.getName(), cacheDescriptor.getExtension(), version) : new DefaultArtifact(GROUP_ID, cacheDescriptor.getName(), cacheDescriptor.getClassifier(), cacheDescriptor.getExtension(), version);
        return artifact;
    }
}

