/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ElmExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallNodeExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.Platform;
import java.io.File;

final class InstallElmExecutorConfig
implements ElmExecutorConfig {
    private static final String ELM_WINDOWS = "/node/elm".concat("/elm.exe").replaceAll("/", "\\\\");
    private static final String ELM_DEFAULT = "/node/elm/elm";
    private File nodePath;
    private final InstallConfig installConfig;

    public InstallElmExecutorConfig(InstallConfig installConfig) {
        this.installConfig = installConfig;
        this.nodePath = new InstallNodeExecutorConfig(installConfig).getNodePath();
    }

    @Override
    public File getNodePath() {
        return this.nodePath;
    }

    @Override
    public File getElmPath() {
        String elmExecutable = this.getPlatform().isWindows() ? ELM_WINDOWS : ELM_DEFAULT;
        return new File(this.installConfig.getInstallDirectory() + elmExecutable);
    }

    @Override
    public File getWorkingDirectory() {
        return this.installConfig.getWorkingDirectory();
    }

    @Override
    public Platform getPlatform() {
        return this.installConfig.getPlatform();
    }
}

