/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.listener;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import net.ttddyy.dsproxy.listener.QueryCountStrategy;

public class SingleQueryCountHolder
implements QueryCountStrategy {
    private ConcurrentMap<String, QueryCount> queryCountMap = new ConcurrentHashMap<String, QueryCount>();
    private boolean populateQueryCountHolder = true;

    @Override
    public QueryCount getOrCreateQueryCount(String dataSourceName) {
        QueryCount queryCount = (QueryCount)this.queryCountMap.get(dataSourceName);
        if (queryCount == null) {
            this.queryCountMap.putIfAbsent(dataSourceName, new QueryCount());
            queryCount = (QueryCount)this.queryCountMap.get(dataSourceName);
        }
        if (this.populateQueryCountHolder) {
            QueryCountHolder.put(dataSourceName, queryCount);
        }
        return queryCount;
    }

    public ConcurrentMap<String, QueryCount> getQueryCountMap() {
        return this.queryCountMap;
    }

    public void setQueryCountMap(ConcurrentMap<String, QueryCount> queryCountMap) {
        this.queryCountMap = queryCountMap;
    }

    public boolean isPopulateQueryCountHolder() {
        return this.populateQueryCountHolder;
    }

    public void setPopulateQueryCountHolder(boolean populateQueryCountHolder) {
        this.populateQueryCountHolder = populateQueryCountHolder;
    }

    public void clear() {
        this.queryCountMap.clear();
    }
}

