/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.proxy;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.ttddyy.dsproxy.ConnectionIdManager;

public class GlobalConnectionIdManager
implements ConnectionIdManager {
    private static AtomicLong ID_COUNTER = new AtomicLong(0L);
    private Set<String> openIds = Collections.synchronizedSet(new HashSet());

    public static void resetId() {
        ID_COUNTER.set(0L);
    }

    @Override
    public String getId(Connection connection) {
        String id = String.valueOf(ID_COUNTER.incrementAndGet());
        this.openIds.add(id);
        return id;
    }

    @Override
    public void addClosedId(String closedId) {
        this.openIds.remove(closedId);
    }

    @Override
    public Set<String> getOpenConnectionIds() {
        return Collections.unmodifiableSet(this.openIds);
    }
}

