/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.swagger.internal;

import io.swagger.models.Info;
import io.swagger.models.Model;
import io.swagger.models.Path;
import io.swagger.models.Swagger;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.util.Json;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.ws.rs.core.UriInfo;
import net.trajano.ms.swagger.internal.ClonableSwagger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class SwaggerCollator {
    private static final Logger LOG = LoggerFactory.getLogger(SwaggerCollator.class);
    @Autowired
    private ConfigurableEnvironment env;
    private final Map<String, ClonableSwagger> swaggerMap = new ConcurrentHashMap();
    private final Map<String, Integer> swaggerPaths = new HashMap();

    public Set<String> getPaths() {
        return this.swaggerPaths.keySet();
    }

    public ClonableSwagger getSwagger(String basePath, UriInfo uriInfo) {
        ClonableSwagger swagger = (ClonableSwagger)this.swaggerMap.get(basePath);
        if (swagger == null) {
            int i = (Integer)this.swaggerPaths.get(basePath);
            swagger = new ClonableSwagger();
            String title = this.env.getProperty(String.format("swagger[%d].info.title", i));
            String version = this.env.getProperty(String.format("swagger[%d].info.version", i));
            swagger.setBasePath('/' + basePath);
            Info info = new Info();
            info.setTitle(title);
            info.setVersion(version);
            swagger.setInfo(info);
            TreeMap pathsMap = new TreeMap();
            TreeMap definitionsMap = new TreeMap();
            TreeMap securityDefinitionsMap = new TreeMap();
            this.processUris(pathsMap, definitionsMap, securityDefinitionsMap, i);
            swagger.setPaths(pathsMap);
            swagger.setDefinitions(definitionsMap);
            swagger.setSecurityDefinitions(securityDefinitionsMap);
            this.swaggerMap.putIfAbsent(basePath, swagger);
        }
        return swagger.withUriInfo(uriInfo);
    }

    @PostConstruct
    public void init() {
        int i = 0;
        while (this.env.containsProperty(String.format("swagger[%d].path", i))) {
            String basePath = this.env.getProperty(String.format("swagger[%d].path", i));
            if (!basePath.startsWith("/")) {
                throw new IllegalArgumentException("Paths must begin with /");
            }
            this.swaggerPaths.put(basePath.substring(1), i);
            ++i;
        }
    }

    public boolean isPathExists(String basePath) {
        return this.swaggerPaths.containsKey(basePath);
    }

    private void processPaths(Map<String, Path> swagger, Map<String, Model> definitionsMap, Map<String, SecuritySchemeDefinition> securityDefinitionsMap, Swagger remoteSwagger, int i, int j) {
        int k = 0;
        while (this.env.containsProperty(String.format("swagger[%d].uris[%d].paths[%d].from", i, j, k)) || this.env.containsProperty(String.format("swagger[%d].uris[%d].paths[%d]", i, j, k))) {
            if (this.env.containsProperty(String.format("swagger[%d].uris[%d].paths[%d].from", i, j, k))) {
                String from = this.env.getRequiredProperty(String.format("swagger[%d].uris[%d].paths[%d].from", i, j, k));
                String to = this.env.getRequiredProperty(String.format("swagger[%d].uris[%d].paths[%d].to", i, j, k));
                LOG.debug("getting path={} from paths={} and transform to={}", new Object[]{from, remoteSwagger.getPaths().keySet(), to});
                Optional.ofNullable(remoteSwagger.getPaths()).ifPresent(t -> remoteSwagger.getPaths().keySet().parallelStream().filter(s -> s.startsWith(from)).forEach(p -> swagger.put(to + p.substring(from.length()), remoteSwagger.getPath(p))));
                this.updateDefinitions(definitionsMap, securityDefinitionsMap, remoteSwagger);
            } else {
                String path = this.env.getRequiredProperty(String.format("swagger[%d].uris[%d].paths[%d]", i, j, k));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getting path={} from paths={}", (Object)path, remoteSwagger.getPaths().keySet());
                }
                if (remoteSwagger.getPaths() != null) {
                    remoteSwagger.getPaths().keySet().parallelStream().filter(s -> s.startsWith(path)).forEach(p -> swagger.put((String)p, remoteSwagger.getPath(p)));
                }
                this.updateDefinitions(definitionsMap, securityDefinitionsMap, remoteSwagger);
            }
            ++k;
        }
    }

    private void processUris(Map<String, Path> swagger, Map<String, Model> definitionsMap, Map<String, SecuritySchemeDefinition> securityDefinitionsMap, int i) {
        int j = 0;
        while (this.env.containsProperty(String.format("swagger[%d].uris[%d].swagger", i, j))) {
            try {
                URL swaggerUrl = (URL)this.env.getProperty(String.format("swagger[%d].uris[%d].swagger", i, j), URL.class);
                Swagger remoteSwagger = (Swagger)Json.mapper().readerFor(Swagger.class).readValue(swaggerUrl.openConnection().getInputStream());
                this.processPaths(swagger, definitionsMap, securityDefinitionsMap, remoteSwagger, i, j);
                ++j;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void updateDefinitions(Map<String, Model> currentDefinitionsMap, Map<String, SecuritySchemeDefinition> currentSecurityDefinitionsMap, Swagger swagger) {
        Optional.ofNullable(swagger.getDefinitions()).ifPresent(t -> t.entrySet().parallelStream().forEach(e -> {
            Model cfr_ignored_0 = (Model)currentDefinitionsMap.put((String)e.getKey(), (Model)e.getValue());
        }));
        Optional.ofNullable(swagger.getSecurityDefinitions()).ifPresent(t -> t.entrySet().parallelStream().forEach(e -> {
            SecuritySchemeDefinition cfr_ignored_0 = (SecuritySchemeDefinition)currentSecurityDefinitionsMap.put((String)e.getKey(), (SecuritySchemeDefinition)e.getValue());
        }));
    }
}

