/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.repository;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import net.time4j.PlainDate;
import net.time4j.base.GregorianDate;
import net.time4j.scale.LeapSecondProvider;
import net.time4j.tz.ExtZoneProvider;
import net.time4j.tz.NameStyle;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZoneProvider;
import net.time4j.tz.spi.ZoneNameProviderSPI;

public class TimezoneRepositoryProviderSPI
implements ExtZoneProvider,
LeapSecondProvider {
    private static final Set<String> JDK_NAME_REFS;
    private static final ExtZoneProvider NAME_PROVIDER;
    private final String version;
    private final String location;
    private final Map<String, byte[]> data;
    private final Map<String, String> aliases;
    private final PlainDate expires;
    private final Map<GregorianDate, Integer> leapsecs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TimezoneRepositoryProviderSPI() {
        URL url = null;
        InputStream is = null;
        DataInputStream dis = null;
        String tmpVersion = "";
        String tmpLocation = "";
        PlainDate tmpExpires = (PlainDate)PlainDate.axis().getMinimum();
        HashMap<String, byte[]> tmpData = new HashMap<String, byte[]>();
        HashMap<String, String> tmpAliases = new HashMap<String, String>();
        boolean noLeaps = System.getProperty("net.time4j.scale.leapseconds.path") != null;
        this.leapsecs = noLeaps ? Collections.emptyMap() : new LinkedHashMap<GregorianDate, Integer>(50);
        String repositoryPath = System.getProperty("net.time4j.tz.repository.path");
        String repositoryVersion = System.getProperty("net.time4j.tz.repository.version");
        String file = repositoryVersion == null ? "tzdata.repository" : "tzdata" + repositoryVersion + ".repository";
        try {
            if (repositoryPath != null) {
                File path = new File(repositoryPath, file);
                if (path.isAbsolute()) {
                    if (!path.exists()) throw new FileNotFoundException("Path to tz-repository not found: " + path);
                    url = path.toURI().toURL();
                } else {
                    String internalResource = path.toString();
                    url = TimezoneRepositoryProviderSPI.classLoader().getResource(internalResource);
                }
            } else {
                String internalResource = "tzrepo/" + file;
                url = TimezoneRepositoryProviderSPI.classLoader().getResource(internalResource);
            }
            if (url != null) {
                is = url.openStream();
                dis = new DataInputStream(is);
                tmpLocation = url.toString();
                TimezoneRepositoryProviderSPI.checkMagicLabel(dis, tmpLocation);
                String v = dis.readUTF();
                int sizeOfZones = dis.readInt();
                ArrayList<String> zones = new ArrayList<String>();
                for (int i = 0; i < sizeOfZones; ++i) {
                    byte[] dataBuf;
                    int dataRead;
                    String zoneID = dis.readUTF();
                    int dataLen = dis.readInt();
                    if (dataLen > (dataRead = dis.read(dataBuf = new byte[dataLen], 0, dataLen))) {
                        byte[] tmpBuf = new byte[dataRead];
                        System.arraycopy(dataBuf, 0, tmpBuf, 0, dataRead);
                        dataBuf = tmpBuf;
                    }
                    zones.add(zoneID);
                    tmpData.put(zoneID, dataBuf);
                }
                int sizeOfLinks = dis.readShort();
                for (int i = 0; i < sizeOfLinks; ++i) {
                    String alias = dis.readUTF();
                    String id = (String)zones.get(dis.readShort());
                    tmpAliases.put(alias, id);
                }
                if (!noLeaps) {
                    int sizeOfLeaps = dis.readShort();
                    for (int i = 0; i < sizeOfLeaps; ++i) {
                        short year = dis.readShort();
                        byte month = dis.readByte();
                        byte dom = dis.readByte();
                        byte shift = dis.readByte();
                        this.leapsecs.put((GregorianDate)PlainDate.of((int)year, (int)month, (int)dom), Integer.valueOf(shift));
                    }
                    short year = dis.readShort();
                    byte month = dis.readByte();
                    byte dom = dis.readByte();
                    tmpExpires = PlainDate.of((int)year, (int)month, (int)dom);
                }
                tmpVersion = v;
            }
        }
        catch (IOException ioe) {
            System.out.println("Note: TZ-repository not available. => " + ioe.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.version = tmpVersion;
        this.location = tmpLocation;
        this.data = Collections.unmodifiableMap(tmpData);
        this.aliases = Collections.unmodifiableMap(tmpAliases);
        this.expires = tmpExpires;
    }

    public Set<String> getAvailableIDs() {
        return this.data.keySet();
    }

    public Set<String> getPreferredIDs(Locale locale, boolean smart) {
        return NAME_PROVIDER.getPreferredIDs(locale, smart);
    }

    public String getDisplayName(String tzid, NameStyle style, Locale locale) {
        if (JDK_NAME_REFS.contains(tzid)) {
            Timezone tz = Timezone.of((String)("java.util.TimeZone~" + tzid));
            return tz.getDisplayName(style, locale);
        }
        return tzid;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public TransitionHistory load(String zoneID) {
        try {
            byte[] bytes = this.data.get(zoneID);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return (TransitionHistory)ois.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getFallback() {
        return "";
    }

    public String getName() {
        return "TZDB";
    }

    public String getLocation() {
        return this.location;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<GregorianDate, Integer> getLeapSecondTable() {
        return Collections.unmodifiableMap(this.leapsecs);
    }

    public boolean supportsNegativeLS() {
        return !this.leapsecs.isEmpty();
    }

    public PlainDate getDateOfEvent(int year, int month, int dayOfMonth) {
        return PlainDate.of((int)year, (int)month, (int)dayOfMonth);
    }

    public PlainDate getDateOfExpiration() {
        return this.expires;
    }

    public String toString() {
        return "TZ-REPOSITORY(" + this.version + ")";
    }

    private static void checkMagicLabel(DataInputStream dis, String location) throws IOException {
        byte b1 = dis.readByte();
        byte b2 = dis.readByte();
        byte b3 = dis.readByte();
        byte b4 = dis.readByte();
        byte b5 = dis.readByte();
        byte b6 = dis.readByte();
        if (b1 != 116 || b2 != 122 || b3 != 114 || b4 != 101 || b5 != 112 || b6 != 111) {
            throw new IOException("Invalid tz-repository: " + location);
        }
    }

    private static ClassLoader classLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ZoneProvider.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    static {
        HashSet<String> jdkNameRefs = new HashSet<String>();
        for (String key : TimeZone.getAvailableIDs()) {
            jdkNameRefs.add(key);
        }
        JDK_NAME_REFS = Collections.unmodifiableSet(jdkNameRefs);
        NAME_PROVIDER = new ZoneNameProviderSPI();
    }
}

