/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Comparator;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.PlainTime;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockIntervalFactory;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.SPX;

public final class ClockInterval
extends IsoInterval<PlainTime, ClockInterval>
implements Serializable {
    private static final long serialVersionUID = -6020908050362634577L;
    private static final Comparator<ChronoInterval<PlainTime>> COMPARATOR = new IntervalComparator<PlainTime>(false, (TimeLine<PlainTime>)PlainTime.axis());

    ClockInterval(Boundary<PlainTime> boundary, Boundary<PlainTime> boundary2) {
        super(boundary, boundary2);
        if (boundary.isInfinite() || boundary2.isInfinite()) {
            throw new IllegalArgumentException("Clock (time) intervals must be finite.");
        }
    }

    public static Comparator<ChronoInterval<PlainTime>> comparator() {
        return COMPARATOR;
    }

    public static ClockInterval between(PlainTime plainTime, PlainTime plainTime2) {
        return new ClockInterval(Boundary.of(IntervalEdge.CLOSED, plainTime), Boundary.of(IntervalEdge.OPEN, plainTime2));
    }

    public static ClockInterval since(PlainTime plainTime) {
        return ClockInterval.between(plainTime, PlainTime.midnightAtEndOfDay());
    }

    public static ClockInterval until(PlainTime plainTime) {
        return ClockInterval.between(PlainTime.midnightAtStartOfDay(), plainTime);
    }

    public Duration<ClockUnit> getDuration() {
        PlainTime plainTime = (PlainTime)this.getTemporalOfClosedStart();
        PlainTime plainTime2 = (PlainTime)this.getEnd().getTemporal();
        if (this.getEnd().isClosed()) {
            if (plainTime2.getHour() == 24) {
                if (plainTime.equals((Object)PlainTime.midnightAtStartOfDay())) {
                    return Duration.of((long)24L, (IsoUnit)ClockUnit.HOURS).plus(1L, (IsoUnit)ClockUnit.NANOS);
                }
                plainTime = (PlainTime)plainTime.minus(1L, (Object)ClockUnit.NANOS);
            } else {
                plainTime2 = (PlainTime)plainTime2.plus(1L, (Object)ClockUnit.NANOS);
            }
        }
        return (Duration)Duration.inClockUnits().between((TimePoint)plainTime, (TimePoint)plainTime2);
    }

    public ClockInterval move(long l, ClockUnit clockUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), (Temporal)((PlainTime)this.getStart().getTemporal()).plus(l, (Object)clockUnit));
        Boundary<Object> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), (Temporal)((PlainTime)this.getEnd().getTemporal()).plus(l, (Object)clockUnit));
        return new ClockInterval((Boundary<PlainTime>)boundary, (Boundary<PlainTime>)boundary2);
    }

    public static ClockInterval parse(String string, ChronoParser<PlainTime> chronoParser) throws ParseException {
        return ClockInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static ClockInterval parse(String string, ChronoParser<PlainTime> chronoParser, String string2) throws ParseException {
        ParseLog parseLog = new ParseLog();
        ClockInterval clockInterval = IntervalParser.parseCustom(string, ClockIntervalFactory.INSTANCE, chronoParser, string2, parseLog);
        if (parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (clockInterval == null) {
            throw new ParseException("Parsing of interval failed: " + string, parseLog.getPosition());
        }
        return clockInterval;
    }

    public static ClockInterval parse(CharSequence charSequence, ChronoParser<PlainTime> chronoParser, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (ClockInterval)IntervalParser.of(ClockIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static ClockInterval parse(CharSequence charSequence, ChronoParser<PlainTime> chronoParser, char c, ChronoParser<PlainTime> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (ClockInterval)IntervalParser.of(ClockIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c, null).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static ClockInterval parseISO(String string) throws ParseException {
        ChronoFormatter chronoFormatter = Iso8601Format.BASIC_WALL_TIME;
        ParseLog parseLog = new ParseLog();
        if (string.length() > 3 && string.charAt(2) == ':') {
            chronoFormatter = Iso8601Format.EXTENDED_WALL_TIME;
        } else if (string.charAt(0) == 'P' || string.charAt(0) == '-') {
            int n = string.indexOf(47);
            if (string.length() > n + 4 && string.charAt(n + 3) == ':') {
                chronoFormatter = Iso8601Format.EXTENDED_WALL_TIME;
            }
        }
        ClockInterval clockInterval = (ClockInterval)IntervalParser.of(ClockIntervalFactory.INSTANCE, chronoFormatter, chronoFormatter, BracketPolicy.SHOW_NEVER, '/', null).parse(string, parseLog, IsoInterval.extractDefaultAttributes(chronoFormatter));
        if (clockInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        return clockInterval;
    }

    @Override
    TimeLine<PlainTime> getTimeLine() {
        return PlainTime.axis();
    }

    @Override
    IntervalFactory<PlainTime, ClockInterval> getFactory() {
        return ClockIntervalFactory.INSTANCE;
    }

    @Override
    ClockInterval getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this, 33);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

