/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalTime;
import java.util.Comparator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.PlainTime;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockIntervalFactory;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.SPX;

public final class ClockInterval
extends IsoInterval<PlainTime, ClockInterval>
implements Serializable {
    private static final long serialVersionUID = -6020908050362634577L;
    private static final Comparator<ChronoInterval<PlainTime>> COMPARATOR = new IntervalComparator<PlainTime>(false, (TimeLine<PlainTime>)PlainTime.axis());

    ClockInterval(Boundary<PlainTime> boundary, Boundary<PlainTime> boundary2) {
        super(boundary, boundary2);
        if (boundary.isInfinite() || boundary2.isInfinite()) {
            throw new IllegalArgumentException("Clock (time) intervals must be finite.");
        }
    }

    public static Comparator<ChronoInterval<PlainTime>> comparator() {
        return COMPARATOR;
    }

    public static ClockInterval between(PlainTime plainTime, PlainTime plainTime2) {
        return new ClockInterval(Boundary.of(IntervalEdge.CLOSED, plainTime), Boundary.of(IntervalEdge.OPEN, plainTime2));
    }

    public static ClockInterval between(LocalTime localTime, LocalTime localTime2) {
        return ClockInterval.between(PlainTime.from((LocalTime)localTime), PlainTime.from((LocalTime)localTime2));
    }

    public static ClockInterval since(PlainTime plainTime) {
        return ClockInterval.between(plainTime, PlainTime.midnightAtEndOfDay());
    }

    public static ClockInterval since(LocalTime localTime) {
        return ClockInterval.since(PlainTime.from((LocalTime)localTime));
    }

    public static ClockInterval until(PlainTime plainTime) {
        return ClockInterval.between(PlainTime.midnightAtStartOfDay(), plainTime);
    }

    public static ClockInterval until(LocalTime localTime) {
        return ClockInterval.until(PlainTime.from((LocalTime)localTime));
    }

    public static ClockInterval from(ChronoInterval<PlainTime> chronoInterval) {
        if (chronoInterval instanceof ClockInterval) {
            return (ClockInterval)ClockInterval.class.cast(chronoInterval);
        }
        return new ClockInterval(chronoInterval.getStart(), chronoInterval.getEnd());
    }

    public PlainTime getStartAsClockTime() {
        return (PlainTime)this.getStart().getTemporal();
    }

    public LocalTime getStartAsLocalTime() {
        return this.getStartAsClockTime().toTemporalAccessor();
    }

    public PlainTime getEndAsClockTime() {
        return (PlainTime)this.getEnd().getTemporal();
    }

    public LocalTime getEndAsLocalTime() {
        return this.getEndAsClockTime().toTemporalAccessor();
    }

    public Duration<ClockUnit> getDuration() {
        PlainTime plainTime = (PlainTime)this.getTemporalOfClosedStart();
        PlainTime plainTime2 = (PlainTime)this.getEnd().getTemporal();
        if (this.getEnd().isClosed()) {
            if (plainTime2.getHour() == 24) {
                if (plainTime.equals((Object)PlainTime.midnightAtStartOfDay())) {
                    return Duration.of((long)24L, (IsoUnit)ClockUnit.HOURS).plus(1L, (IsoUnit)ClockUnit.NANOS);
                }
                plainTime = plainTime.minus(1L, ClockUnit.NANOS);
            } else {
                plainTime2 = plainTime2.plus(1L, ClockUnit.NANOS);
            }
        }
        return (Duration)Duration.inClockUnits().between((TimePoint)plainTime, (TimePoint)plainTime2);
    }

    public ClockInterval move(long l, ClockUnit clockUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((PlainTime)this.getStart().getTemporal()).plus(l, clockUnit));
        Boundary<PlainTime> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((PlainTime)this.getEnd().getTemporal()).plus(l, clockUnit));
        return new ClockInterval((Boundary<PlainTime>)boundary, boundary2);
    }

    public Stream<PlainTime> stream(Duration<ClockUnit> duration) {
        ClockInterval clockInterval = (ClockInterval)this.toCanonical();
        return ClockInterval.stream(duration, clockInterval.getStartAsClockTime(), clockInterval.getEndAsClockTime());
    }

    public static Stream<PlainTime> stream(Duration<ClockUnit> duration, PlainTime plainTime, PlainTime plainTime2) {
        int n2;
        if (!duration.isPositive()) {
            throw new IllegalArgumentException("Duration must be positive: " + duration);
        }
        int n3 = plainTime.compareTo(plainTime2);
        if (n3 > 0) {
            throw new IllegalArgumentException("Start after end: " + plainTime + "/" + plainTime2);
        }
        if (n3 == 0) {
            return Stream.empty();
        }
        double d = 0.0;
        for (TimeSpan.Item item : duration.getTotalLength()) {
            d += ((ClockUnit)item.getUnit()).getLength() * (double)item.getAmount();
        }
        double d2 = d < 1.0 ? (double)ClockUnit.NANOS.between((TimePoint)plainTime, (TimePoint)plainTime2) / (d * 1.0E9) : (double)ClockUnit.SECONDS.between((TimePoint)plainTime, (TimePoint)plainTime2) / d;
        if (Double.compare(d2, 2.147483647E9) >= 0) {
            throw new ArithmeticException();
        }
        boolean bl = false;
        for (n2 = (int)Math.floor(d2); n2 > 0 && !((PlainTime)plainTime.plus((TimeSpan)duration.multipliedBy(n2))).isBefore(plainTime2); --n2) {
            bl = true;
        }
        int n4 = n2 + 1;
        if (!bl) {
            do {
                n4 = Math.addExact(n2, 1);
            } while (((PlainTime)plainTime.plus((TimeSpan)duration.multipliedBy(++n2))).isBefore(plainTime2));
        }
        if (n4 == 1) {
            return Stream.of(plainTime);
        }
        return IntStream.range(0, n4).mapToObj(n -> (PlainTime)plainTime.plus((TimeSpan)duration.multipliedBy(n)));
    }

    public String formatBasicISO(IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ClockInterval clockInterval = (ClockInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder();
        ChronoPrinter chronoPrinter = Iso8601Format.ofBasicTime((IsoDecimalStyle)isoDecimalStyle, (ClockUnit)clockUnit);
        chronoPrinter.print((Object)clockInterval.getStartAsClockTime(), stringBuilder);
        stringBuilder.append('/');
        chronoPrinter.print((Object)clockInterval.getEndAsClockTime(), stringBuilder);
        return stringBuilder.toString();
    }

    public String formatExtendedISO(IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ClockInterval clockInterval = (ClockInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder();
        ChronoPrinter chronoPrinter = Iso8601Format.ofExtendedTime((IsoDecimalStyle)isoDecimalStyle, (ClockUnit)clockUnit);
        chronoPrinter.print((Object)clockInterval.getStartAsClockTime(), stringBuilder);
        stringBuilder.append('/');
        chronoPrinter.print((Object)clockInterval.getEndAsClockTime(), stringBuilder);
        return stringBuilder.toString();
    }

    public static ClockInterval parse(String string, ChronoParser<PlainTime> chronoParser) throws ParseException {
        return ClockInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static ClockInterval parse(String string, ChronoParser<PlainTime> chronoParser, String string2) throws ParseException {
        return IntervalParser.parsePattern(string, ClockIntervalFactory.INSTANCE, chronoParser, string2);
    }

    public static ClockInterval parse(CharSequence charSequence, ChronoParser<PlainTime> chronoParser, BracketPolicy bracketPolicy) throws ParseException {
        ParseLog parseLog = new ParseLog();
        ClockInterval clockInterval = (ClockInterval)IntervalParser.of(ClockIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, chronoParser.getAttributes());
        if (clockInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < charSequence.length() && !((Boolean)chronoParser.getAttributes().get(Attributes.TRAILING_CHARACTERS, (Object)Boolean.FALSE)).booleanValue()) {
            throw new ParseException("Trailing characters found: " + charSequence, parseLog.getPosition());
        }
        return clockInterval;
    }

    @Deprecated
    public static ClockInterval parse(CharSequence charSequence, ChronoParser<PlainTime> chronoParser, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (ClockInterval)IntervalParser.of(ClockIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, chronoParser.getAttributes());
    }

    public static ClockInterval parse(CharSequence charSequence, ChronoParser<PlainTime> chronoParser, char c, ChronoParser<PlainTime> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (ClockInterval)IntervalParser.of(ClockIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c).parse(charSequence, parseLog, chronoParser.getAttributes());
    }

    public static ClockInterval parseISO(String string) throws ParseException {
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        ChronoFormatter chronoFormatter = string.indexOf(58) == -1 ? Iso8601Format.BASIC_WALL_TIME : Iso8601Format.EXTENDED_WALL_TIME;
        ParseLog parseLog = new ParseLog();
        ClockInterval clockInterval = (ClockInterval)new IntervalParser<PlainTime, ClockInterval>(ClockIntervalFactory.INSTANCE, (ChronoParser<PlainTime>)chronoFormatter, (ChronoParser<PlainTime>)chronoFormatter, BracketPolicy.SHOW_NEVER, Character.valueOf('/')).parse(string, parseLog, chronoFormatter.getAttributes());
        if (clockInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < string.length()) {
            throw new ParseException("Trailing characters found: " + string, parseLog.getPosition());
        }
        return clockInterval;
    }

    @Override
    IntervalFactory<PlainTime, ClockInterval> getFactory() {
        return ClockIntervalFactory.INSTANCE;
    }

    @Override
    ClockInterval getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this, 33);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

