/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import net.time4j.CalendarUnit;
import net.time4j.IsoDateUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.BasicUnit;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.UnitRule;
import net.time4j.range.HolidayModel;

class BusinessDayUnit
extends BasicUnit
implements IsoDateUnit {
    private final UnitRule<PlainDate> dateRule;

    BusinessDayUnit(final HolidayModel holidayModel) {
        this.dateRule = new UnitRule<PlainDate>(){

            public PlainDate addTo(PlainDate plainDate, long l) {
                PlainDate plainDate2;
                block3: {
                    block2: {
                        plainDate2 = plainDate;
                        if (l <= 0L) break block2;
                        int n = 0;
                        while ((long)n < l) {
                            plainDate2 = (PlainDate)plainDate2.with(holidayModel.nextBusinessDay());
                            ++n;
                        }
                        break block3;
                    }
                    if (l >= 0L) break block3;
                    int n = 0;
                    while ((long)n > l) {
                        plainDate2 = (PlainDate)plainDate2.with(holidayModel.previousBusinessDay());
                        --n;
                    }
                }
                return plainDate2;
            }

            public long between(PlainDate plainDate, PlainDate plainDate2) {
                if (plainDate.isSimultaneous((CalendarDate)plainDate2)) {
                    return 0L;
                }
                long l = 0L;
                boolean bl = plainDate.isAfter((CalendarDate)plainDate2);
                if (bl) {
                    do {
                        if (holidayModel.test(plainDate2 = plainDate2.plus(1L, CalendarUnit.DAYS))) continue;
                        ++l;
                    } while (plainDate2.isBefore((CalendarDate)plainDate));
                } else {
                    do {
                        if (holidayModel.test(plainDate = plainDate.plus(1L, CalendarUnit.DAYS))) continue;
                        ++l;
                    } while (plainDate.isBefore((CalendarDate)plainDate2));
                }
                return bl ? -l : l;
            }
        };
    }

    public char getSymbol() {
        return '\u0000';
    }

    public double getLength() {
        return 86400.0;
    }

    public <T extends ChronoEntity<T>> UnitRule<T> derive(Chronology<T> chronology) {
        if (PlainDate.class.isAssignableFrom(chronology.getChronoType())) {
            UnitRule<PlainDate> unitRule = this.dateRule;
            return unitRule;
        }
        if (PlainTimestamp.class.isAssignableFrom(chronology.getChronoType())) {
            UnitRule<PlainTimestamp> unitRule = new UnitRule<PlainTimestamp>(){

                public PlainTimestamp addTo(PlainTimestamp plainTimestamp, long l) {
                    PlainDate plainDate = (PlainDate)BusinessDayUnit.this.dateRule.addTo((Object)plainTimestamp.toDate(), l);
                    return PlainTimestamp.of((PlainDate)plainDate, (PlainTime)plainTimestamp.toTime());
                }

                public long between(PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
                    long l = BusinessDayUnit.this.dateRule.between((Object)plainTimestamp.toDate(), (Object)plainTimestamp2.toDate());
                    if (l > 0L && plainTimestamp.toTime().isAfter(plainTimestamp2.toTime())) {
                        --l;
                    } else if (l < 0L && plainTimestamp.toTime().isBefore(plainTimestamp2.toTime())) {
                        ++l;
                    }
                    return l;
                }
            };
            return (UnitRule)unitRule;
        }
        throw new UnsupportedOperationException(chronology.getChronoType().getName());
    }
}

