/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import net.time4j.PlainDate;
import net.time4j.Weekday;
import net.time4j.base.TimeSource;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.OutputContext;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.PatternType;

@CalendarType(value="iso8601")
public final class SpanOfWeekdays
extends ChronoEntity<SpanOfWeekdays>
implements Iterable<Weekday>,
Serializable {
    @FormattableElement(format="S")
    public static final ChronoElement<Weekday> START;
    @FormattableElement(format="E")
    public static final ChronoElement<Weekday> END;
    private static final Chronology<SpanOfWeekdays> ENGINE;
    private static final SpanOfWeekdays MONDAY_TO_FRIDAY;
    private static final long serialVersionUID = 3484703887286756207L;
    private final Weekday start;
    private final Weekday end;

    private SpanOfWeekdays(Weekday weekday, Weekday weekday2) {
        this.start = weekday;
        this.end = weekday2;
    }

    public static SpanOfWeekdays on(Weekday weekday) {
        return SpanOfWeekdays.between(weekday, weekday);
    }

    public static SpanOfWeekdays betweenMondayAndFriday() {
        return MONDAY_TO_FRIDAY;
    }

    public static SpanOfWeekdays between(Weekday weekday, Weekday weekday2) {
        if (weekday == null || weekday2 == null) {
            throw new NullPointerException("Missing day of week.");
        }
        return new SpanOfWeekdays(weekday, weekday2);
    }

    public Weekday getStart() {
        return this.start;
    }

    public Weekday getEnd() {
        return this.end;
    }

    public int length() {
        int n = 1;
        for (Weekday weekday = this.start; weekday != this.end; weekday = weekday.next()) {
            ++n;
        }
        return n;
    }

    @Override
    public Iterator<Weekday> iterator() {
        ArrayList<Weekday> arrayList = new ArrayList<Weekday>(7);
        arrayList.add(this.start);
        for (Weekday weekday = this.start; weekday != this.end; weekday = weekday.next()) {
            arrayList.add(weekday);
        }
        return arrayList.iterator();
    }

    public static ChronoFormatter<SpanOfWeekdays> formatter(String string, Locale locale) {
        return ChronoFormatter.ofPattern((String)string, (PatternType)PatternType.DYNAMIC, (Locale)locale, ENGINE).withDefaultSource(END, START);
    }

    public boolean equals(Object object) {
        if (object instanceof SpanOfWeekdays) {
            SpanOfWeekdays spanOfWeekdays = (SpanOfWeekdays)object;
            return this.start == spanOfWeekdays.start && this.end == spanOfWeekdays.end;
        }
        return false;
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        return this.start + "-" + this.end;
    }

    public static Chronology<SpanOfWeekdays> chronology() {
        return ENGINE;
    }

    protected Chronology<SpanOfWeekdays> getChronology() {
        return ENGINE;
    }

    protected SpanOfWeekdays getContext() {
        return this;
    }

    static {
        Element element = new Element("START", 'S');
        Element element2 = new Element("END", 'E');
        START = element;
        END = element2;
        ENGINE = Chronology.Builder.setUp(SpanOfWeekdays.class, (ChronoMerger)new Merger()).appendElement(START, (ElementRule)element).appendElement(END, (ElementRule)element2).build();
        MONDAY_TO_FRIDAY = new SpanOfWeekdays(Weekday.MONDAY, Weekday.FRIDAY);
    }

    private static class Merger
    implements ChronoMerger<SpanOfWeekdays> {
        private Merger() {
        }

        public SpanOfWeekdays createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            PlainDate plainDate = (PlainDate)PlainDate.axis().createFrom(timeSource, attributeQuery);
            if (plainDate == null) {
                return null;
            }
            Weekday weekday = plainDate.getDayOfWeek();
            return SpanOfWeekdays.between(weekday, weekday);
        }

        public SpanOfWeekdays createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            if (chronoEntity.contains(START) && chronoEntity.contains(END)) {
                return SpanOfWeekdays.between((Weekday)chronoEntity.get(START), (Weekday)chronoEntity.get(END));
            }
            return null;
        }
    }

    private static class Element
    extends BasicElement<Weekday>
    implements TextElement<Weekday>,
    ElementRule<SpanOfWeekdays, Weekday> {
        private static final long serialVersionUID = 8221317125139231996L;
        private final transient char symbol;

        Element(String string, char c) {
            super(string);
            this.symbol = c;
        }

        public char getSymbol() {
            return this.symbol;
        }

        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Locale locale = (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
            TextWidth textWidth = (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE);
            OutputContext outputContext = (OutputContext)attributeQuery.get(Attributes.OUTPUT_CONTEXT, (Object)OutputContext.FORMAT);
            appendable.append(((Weekday)chronoDisplay.get((ChronoElement)this)).getDisplayName(locale, textWidth, outputContext));
        }

        public Weekday parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            TextElement textElement = (TextElement)TextElement.class.cast(PlainDate.DAY_OF_WEEK);
            return (Weekday)Weekday.class.cast(textElement.parse(charSequence, parsePosition, attributeQuery));
        }

        public Class<Weekday> getType() {
            return Weekday.class;
        }

        public Weekday getDefaultMinimum() {
            return Weekday.MONDAY;
        }

        public Weekday getDefaultMaximum() {
            return Weekday.SUNDAY;
        }

        public boolean isDateElement() {
            return false;
        }

        public boolean isTimeElement() {
            return false;
        }

        protected boolean isSingleton() {
            return true;
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.name()) {
                case "START": {
                    return START;
                }
                case "END": {
                    return END;
                }
            }
            throw new StreamCorruptedException();
        }

        public Weekday getValue(SpanOfWeekdays spanOfWeekdays) {
            return this.symbol == 'S' ? spanOfWeekdays.start : spanOfWeekdays.end;
        }

        public Weekday getMinimum(SpanOfWeekdays spanOfWeekdays) {
            if (this.symbol == 'S') {
                return spanOfWeekdays.end.next();
            }
            return spanOfWeekdays.start;
        }

        public Weekday getMaximum(SpanOfWeekdays spanOfWeekdays) {
            if (this.symbol == 'S') {
                return spanOfWeekdays.end;
            }
            return spanOfWeekdays.start.previous();
        }

        public boolean isValid(SpanOfWeekdays spanOfWeekdays, Weekday weekday) {
            return weekday != null;
        }

        public SpanOfWeekdays withValue(SpanOfWeekdays spanOfWeekdays, Weekday weekday, boolean bl) {
            if (this.symbol == 'S') {
                return SpanOfWeekdays.between(weekday, spanOfWeekdays.end);
            }
            return SpanOfWeekdays.between(spanOfWeekdays.start, weekday);
        }

        public ChronoElement<?> getChildAtFloor(SpanOfWeekdays spanOfWeekdays) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(SpanOfWeekdays spanOfWeekdays) {
            return null;
        }
    }
}

