/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Temporal;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IsoInterval;
import net.time4j.tz.TZID;

final class IntervalParser<T extends Temporal<? super T>, I extends IsoInterval<T, I>>
implements ChronoParser<I> {
    private final IntervalFactory<T, I> factory;
    private final ChronoParser<T> startFormat;
    private final ChronoParser<T> endFormat;
    private final BracketPolicy policy;
    private final ChronoMerger<T> merger;

    private IntervalParser(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, ChronoParser<T> chronoParser2, BracketPolicy bracketPolicy, ChronoMerger<T> chronoMerger) {
        if (bracketPolicy == null) {
            throw new NullPointerException("Missing bracket policy.");
        }
        this.factory = intervalFactory;
        this.startFormat = chronoParser;
        this.endFormat = chronoParser2;
        this.policy = bracketPolicy;
        this.merger = chronoMerger;
    }

    static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> IntervalParser<T, I> of(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, BracketPolicy bracketPolicy) {
        if (chronoParser == null) {
            throw new NullPointerException("Missing boundary parser.");
        }
        return new IntervalParser<T, I>(intervalFactory, chronoParser, chronoParser, bracketPolicy, null);
    }

    static <T extends Temporal<? super T>, I extends IsoInterval<T, I>> IntervalParser<T, I> of(IntervalFactory<T, I> intervalFactory, ChronoParser<T> chronoParser, ChronoParser<T> chronoParser2, BracketPolicy bracketPolicy, ChronoMerger<T> chronoMerger) {
        return new IntervalParser<T, I>(intervalFactory, chronoParser, chronoParser2, bracketPolicy, chronoMerger);
    }

    I parse(String string) throws ParseException {
        ParseLog parseLog = new ParseLog();
        Object object = this.parse(string, parseLog, IsoInterval.extractDefaultAttributes(this.startFormat));
        if (object == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        return (I)object;
    }

    public I parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        int n;
        int n2;
        int n3;
        int n4 = parseLog.getPosition();
        int n5 = n4;
        if (n5 >= (n3 = charSequence.length())) {
            throw new IndexOutOfBoundsException("[" + n5 + "]: " + charSequence.toString());
        }
        AttributeQuery attributeQuery2 = attributeQuery;
        boolean bl = (Boolean)attributeQuery.get(Attributes.TRAILING_CHARACTERS, (Object)Boolean.FALSE);
        if (!bl) {
            attributeQuery2 = new Wrapper(attributeQuery);
        }
        IntervalEdge intervalEdge = IntervalEdge.CLOSED;
        IntervalEdge intervalEdge2 = this.factory.isCalendrical() ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
        Temporal temporal = null;
        Temporal temporal2 = null;
        Boundary<Object> boundary = null;
        Boundary<Object> boundary2 = null;
        int n6 = -1;
        int n7 = -1;
        ParseLog parseLog2 = null;
        ParseLog parseLog3 = null;
        String string = null;
        char c = charSequence.charAt(n5);
        boolean bl2 = c == '[' || c == '(';
        boolean bl3 = false;
        if (bl2) {
            if (this.policy == BracketPolicy.SHOW_NEVER) {
                parseLog.setError(n5, "Illegal start boundary due to bracket policy: " + c);
            } else if (c == '(') {
                intervalEdge = IntervalEdge.OPEN;
            }
            ++n5;
        } else if (this.policy == BracketPolicy.SHOW_ALWAYS) {
            parseLog.setError(n5, "Missing start boundary bracket.");
        }
        if (parseLog.isError()) {
            return null;
        }
        if (n5 >= n3) {
            parseLog.setError(n5, "Missing interval start component, end of text reached.");
            return null;
        }
        c = charSequence.charAt(n5);
        if (c == 'P') {
            n6 = n5;
            n2 = n5;
            n = -1;
            while (++n2 < n3) {
                if (charSequence.charAt(n2) != '/') continue;
                n = n2;
                break;
            }
            if (n == -1) {
                return (I)((IsoInterval)IntervalParser.solidusError(parseLog, n5));
            }
            string = charSequence.subSequence(n5, n).toString();
            n5 = n + 1;
        } else if (c == '-' && n5 + 1 < n3 && charSequence.charAt(n5 + 1) == '\u221e') {
            if (intervalEdge == IntervalEdge.CLOSED && bl2) {
                parseLog.setError(n5 - 1, "Open boundary expected.");
                return null;
            }
            intervalEdge = IntervalEdge.OPEN;
            boundary = Boundary.infinitePast();
            if ((n5 += 2) >= n3 || charSequence.charAt(n5) != '/') {
                return (I)((IsoInterval)IntervalParser.solidusError(parseLog, n5));
            }
            ++n5;
        } else {
            parseLog2 = new ParseLog(n5);
            temporal = (Temporal)this.startFormat.parse(charSequence, parseLog2, attributeQuery2);
            if (temporal == null || parseLog2.isError()) {
                parseLog.setError(n5, parseLog2.getErrorMessage());
                return null;
            }
            boundary = Boundary.of(intervalEdge, temporal);
            n5 = parseLog2.getPosition();
            if (n5 >= n3 || charSequence.charAt(n5) != '/') {
                return (I)((IsoInterval)IntervalParser.solidusError(parseLog, n5));
            }
            ++n5;
        }
        if (n5 >= n3) {
            parseLog.setError(n5, "Missing interval end component, end of text reached.");
            return null;
        }
        c = charSequence.charAt(n5);
        if (c == 'P') {
            if (temporal == null) {
                parseLog.setError(n5, "Cannot process end period without start time.");
                return null;
            }
            n7 = n5;
            n2 = n3;
            n = charSequence.charAt(n2 - 1);
            if (n == 93 || n == 41) {
                --n2;
            }
            string = charSequence.subSequence(n5, n2).toString();
            n5 = n2;
        } else if (c == '+' && n5 + 1 < n3 && charSequence.charAt(n5 + 1) == '\u221e') {
            if (n5 + 2 < n3 && charSequence.charAt(n5 + 2) == ']' && this.policy != BracketPolicy.SHOW_NEVER) {
                parseLog.setError(n5 + 2, "Open boundary expected.");
                return null;
            }
            intervalEdge2 = IntervalEdge.OPEN;
            boundary2 = Boundary.infiniteFuture();
            n5 += 2;
        } else {
            parseLog3 = new ParseLog(n5);
            temporal2 = (Temporal)this.endFormat.parse(charSequence, parseLog3, attributeQuery2);
            if ((temporal2 == null || parseLog3.isError()) && temporal != null && this.merger != null) {
                IntervalFactory<T, I> intervalFactory = this.factory;
                ChronoParser<T> chronoParser = this.endFormat;
                ChronoEntity chronoEntity = parseLog2.getRawValues();
                if (chronoEntity.hasTimezone()) {
                    attributeQuery2 = new Wrapper(attributeQuery2, chronoEntity.getTimezone());
                }
                ChronoDisplay chronoDisplay = this.merger.preformat((Object)temporal, attributeQuery2);
                for (ChronoElement<?> chronoElement : intervalFactory.stdElements(chronoEntity)) {
                    chronoParser = IntervalParser.setDefault(chronoParser, chronoDisplay, chronoElement);
                }
                parseLog3.reset();
                parseLog3.setPosition(n5);
                temporal2 = (Temporal)chronoParser.parse(charSequence, parseLog3, attributeQuery2);
            }
            if (temporal2 == null || parseLog3.isError()) {
                parseLog.setError(n5, parseLog3.getErrorMessage());
                return null;
            }
            boundary2 = Boundary.of(intervalEdge2, temporal2);
            n5 = parseLog3.getPosition();
        }
        if (n5 >= n3) {
            if (this.policy == BracketPolicy.SHOW_ALWAYS) {
                parseLog.setError(n5, "Missing end boundary bracket.");
            }
        } else {
            c = charSequence.charAt(n5);
            if (c == ']' || c == ')') {
                if (this.policy == BracketPolicy.SHOW_NEVER) {
                    parseLog.setError(n5, "Illegal end boundary due to bracket policy: " + c);
                } else {
                    bl3 = true;
                    IntervalEdge intervalEdge3 = intervalEdge2 = c == ']' ? IntervalEdge.CLOSED : IntervalEdge.OPEN;
                    if (temporal2 != null) {
                        boundary2 = Boundary.of(intervalEdge2, temporal2);
                    }
                    ++n5;
                }
            } else if (this.policy == BracketPolicy.SHOW_ALWAYS) {
                parseLog.setError(n5, "Missing end boundary bracket.");
            }
        }
        if (parseLog.isError()) {
            return null;
        }
        if (n5 < n3 && !bl) {
            String string2 = n3 - n5 <= 10 ? charSequence.subSequence(n5, n3).toString() : charSequence.subSequence(n5, n5 + 10).toString() + "...";
            parseLog.setError(n5, "Unparsed trailing characters: " + string2);
            return null;
        }
        if (string != null) {
            IntervalFactory<Temporal, I> intervalFactory = this.factory;
            if (boundary == null) {
                if (temporal2 == null) {
                    parseLog.setError(n6, "Cannot process start period without end time.");
                    return null;
                }
                temporal = intervalFactory.minusPeriod(temporal2, string, parseLog3, attributeQuery);
                if (temporal == null) {
                    parseLog.setError(n6, "Wrong period: " + string);
                    return null;
                }
                boundary = Boundary.of(intervalEdge, temporal);
            }
            if (boundary2 == null) {
                temporal2 = intervalFactory.plusPeriod(temporal, string, parseLog2, attributeQuery);
                if (temporal2 == null) {
                    parseLog.setError(n7, "Wrong period: " + string);
                    return null;
                }
                boundary2 = Boundary.of(intervalEdge2, temporal2);
            }
        }
        I i = this.factory.between(boundary, boundary2);
        if (this.policy == BracketPolicy.SHOW_WHEN_NON_STANDARD) {
            boolean bl4 = this.policy.display((ChronoInterval<?>)i);
            if (!(!bl4 || bl2 && bl3)) {
                int n8 = !bl3 ? n5 : n4;
                parseLog.setError(n8, "Missing boundary.");
                return null;
            }
            if (!bl4 && (bl2 || bl3)) {
                int n9 = bl3 ? n5 : n4;
                parseLog.setError(n9, "Standard boundary not allowed due to sign policy.");
                return null;
            }
        }
        parseLog.setPosition(n5);
        return i;
    }

    private static <R> R solidusError(ParseLog parseLog, int n) {
        parseLog.setError(n, "Solidus char separating start and end boundaries expected.");
        return null;
    }

    private static <T, V> ChronoParser<T> setDefault(ChronoParser<T> chronoParser, ChronoDisplay chronoDisplay, ChronoElement<V> chronoElement) {
        ChronoFormatter chronoFormatter = (ChronoFormatter)ChronoFormatter.class.cast(chronoParser);
        chronoFormatter = chronoFormatter.withDefault(chronoElement, chronoDisplay.get(chronoElement));
        return chronoFormatter;
    }

    private static class Wrapper
    implements AttributeQuery {
        private final AttributeQuery attributes;
        private final AttributeKey<Boolean> specialKey;
        private final TZID tzid;

        Wrapper(AttributeQuery attributeQuery) {
            this(attributeQuery, null);
        }

        Wrapper(AttributeQuery attributeQuery, TZID tZID) {
            this.attributes = attributeQuery;
            this.specialKey = Attributes.TRAILING_CHARACTERS;
            this.tzid = tZID;
        }

        public boolean contains(AttributeKey<?> attributeKey) {
            if (attributeKey.equals(this.specialKey)) {
                return true;
            }
            if (this.tzid != null && attributeKey.equals((Object)Attributes.TIMEZONE_ID)) {
                return true;
            }
            return this.attributes.contains(attributeKey);
        }

        public <A> A get(AttributeKey<A> attributeKey) {
            if (attributeKey.equals(this.specialKey)) {
                return (A)attributeKey.type().cast(Boolean.TRUE);
            }
            if (this.tzid != null && attributeKey.equals((Object)Attributes.TIMEZONE_ID)) {
                return (A)attributeKey.type().cast(this.tzid);
            }
            return (A)this.attributes.get(attributeKey);
        }

        public <A> A get(AttributeKey<A> attributeKey, A a) {
            if (attributeKey.equals(this.specialKey)) {
                return (A)attributeKey.type().cast(Boolean.TRUE);
            }
            if (this.tzid != null && attributeKey.equals((Object)Attributes.TIMEZONE_ID)) {
                return (A)attributeKey.type().cast(this.tzid);
            }
            return (A)this.attributes.get(attributeKey, a);
        }
    }
}

