/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Locale;
import net.time4j.AdjustableElement;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.FixedNumParser;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.MomentInterval;
import net.time4j.range.NoopPrinter;
import net.time4j.range.SPX;
import net.time4j.range.TimestampIntervalFactory;
import net.time4j.range.YearParser;
import net.time4j.tz.GapResolver;
import net.time4j.tz.OverlapResolver;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class TimestampInterval
extends IsoInterval<PlainTimestamp, TimestampInterval>
implements Serializable {
    public static final TimestampInterval ALWAYS = TimestampIntervalFactory.INSTANCE.between(Boundary.infinitePast(), Boundary.infiniteFuture());
    private static final long serialVersionUID = -3965530927182499606L;
    private static final Comparator<ChronoInterval<PlainTimestamp>> COMPARATOR = new IntervalComparator<PlainTimestamp>((TimeLine<PlainTimestamp>)PlainTimestamp.axis());

    TimestampInterval(Boundary<PlainTimestamp> boundary, Boundary<PlainTimestamp> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<PlainTimestamp>> comparator() {
        return COMPARATOR;
    }

    public static TimestampInterval between(PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
        return new TimestampInterval(Boundary.of(IntervalEdge.CLOSED, plainTimestamp), Boundary.of(IntervalEdge.OPEN, plainTimestamp2));
    }

    public static TimestampInterval since(PlainTimestamp plainTimestamp) {
        Boundary<PlainTimestamp> boundary = Boundary.infiniteFuture();
        return new TimestampInterval(Boundary.of(IntervalEdge.CLOSED, plainTimestamp), boundary);
    }

    public static TimestampInterval until(PlainTimestamp plainTimestamp) {
        Boundary<PlainTimestamp> boundary = Boundary.infinitePast();
        return new TimestampInterval(boundary, Boundary.of(IntervalEdge.OPEN, plainTimestamp));
    }

    public static TimestampInterval from(ChronoInterval<PlainTimestamp> chronoInterval) {
        if (chronoInterval instanceof TimestampInterval) {
            return (TimestampInterval)TimestampInterval.class.cast(chronoInterval);
        }
        return new TimestampInterval(chronoInterval.getStart(), chronoInterval.getEnd());
    }

    public MomentInterval atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    public MomentInterval at(ZonalOffset zonalOffset) {
        Boundary<Moment> boundary;
        Moment moment;
        Boundary<Moment> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            moment = ((PlainTimestamp)this.getStart().getTemporal()).at(zonalOffset);
            boundary2 = Boundary.of(this.getStart().getEdge(), moment);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            moment = ((PlainTimestamp)this.getEnd().getTemporal()).at(zonalOffset);
            boundary = Boundary.of(this.getEnd().getEdge(), moment);
        }
        return new MomentInterval(boundary2, boundary);
    }

    public MomentInterval inStdTimezone() {
        return this.in(SystemTimezoneHolder.get());
    }

    public MomentInterval inTimezone(TZID tZID) {
        return this.in(Timezone.of((TZID)tZID).with(GapResolver.NEXT_VALID_TIME.and(OverlapResolver.EARLIER_OFFSET)));
    }

    MomentInterval in(Timezone timezone) {
        Boundary<Moment> boundary;
        Moment moment;
        Boundary<Moment> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            moment = ((PlainTimestamp)this.getStart().getTemporal()).in(timezone);
            boundary2 = Boundary.of(this.getStart().getEdge(), moment);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            moment = ((PlainTimestamp)this.getEnd().getTemporal()).in(timezone);
            boundary = Boundary.of(this.getEnd().getEdge(), moment);
        }
        return new MomentInterval(boundary2, boundary);
    }

    public <U extends IsoUnit> Duration<U> getDuration(U ... UArray) {
        boolean bl;
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = plainTimestamp == null;
        if (bl) {
            plainTimestamp = (PlainTimestamp)this.getEnd().getTemporal();
        }
        Duration duration = (Duration)Duration.in(UArray).between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)plainTimestamp);
        if (bl) {
            for (U u : UArray) {
                if (!u.equals(ClockUnit.NANOS)) continue;
                return duration.plus(1L, u);
            }
        }
        return duration;
    }

    public Duration<IsoUnit> getDuration(Timezone timezone, IsoUnit ... isoUnitArray) {
        boolean bl;
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = plainTimestamp == null;
        if (bl) {
            plainTimestamp = (PlainTimestamp)this.getEnd().getTemporal();
        }
        Duration duration = (Duration)Duration.in((Timezone)timezone, (IsoUnit[])isoUnitArray).between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)plainTimestamp);
        if (bl) {
            for (IsoUnit isoUnit : isoUnitArray) {
                if (!isoUnit.equals(ClockUnit.NANOS)) continue;
                return duration.plus(1L, isoUnit);
            }
        }
        return duration;
    }

    public TimestampInterval move(long l, IsoUnit isoUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((PlainTimestamp)this.getStart().getTemporal()).plus(l, (Object)isoUnit));
        Boundary<Object> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((PlainTimestamp)this.getEnd().getTemporal()).plus(l, (Object)isoUnit));
        return new TimestampInterval((Boundary<PlainTimestamp>)boundary, (Boundary<PlainTimestamp>)boundary2);
    }

    public static TimestampInterval parse(String string, ChronoParser<PlainTimestamp> chronoParser) throws ParseException {
        return TimestampInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static TimestampInterval parse(String string, ChronoParser<PlainTimestamp> chronoParser, String string2) throws ParseException {
        ParseLog parseLog = new ParseLog();
        TimestampInterval timestampInterval = IntervalParser.parseCustom(string, TimestampIntervalFactory.INSTANCE, chronoParser, string2, parseLog);
        if (parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (timestampInterval == null) {
            throw new ParseException("Parsing of interval failed: " + string, parseLog.getPosition());
        }
        return timestampInterval;
    }

    public static TimestampInterval parse(CharSequence charSequence, ChronoParser<PlainTimestamp> chronoParser, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (TimestampInterval)IntervalParser.of(TimestampIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static TimestampInterval parse(CharSequence charSequence, ChronoParser<PlainTimestamp> chronoParser, char c, ChronoParser<PlainTimestamp> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (TimestampInterval)IntervalParser.of(TimestampIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static TimestampInterval parseISO(String string) throws ParseException {
        int n;
        int n2;
        int n3;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        int n4 = 0;
        int n5 = Math.min(string.length(), 107);
        boolean bl = true;
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        if (string.charAt(0) == 'P') {
            for (n3 = 1; n3 < n5; ++n3) {
                if (string.charAt(n3) != '/') continue;
                if (n3 + 1 == n5) {
                    throw new ParseException("Missing end component.", n5);
                }
                n4 = n3 + 1;
                break;
            }
        }
        n3 = 0;
        int n9 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n10 = -1;
        for (n2 = n4 + 1; n2 < n5; ++n2) {
            n = string.charAt(n2);
            if (bl5) {
                if (n == 80) {
                    bl5 = false;
                    break;
                }
                if (n == 84 || n8 > 0) {
                    ++n8;
                    continue;
                }
                if (n == 87) {
                    bl4 = true;
                } else if (n == 45 && n2 > n10 + 1) {
                    ++n9;
                }
                ++n7;
                continue;
            }
            if (n == 47) {
                if (n10 == -1) {
                    n10 = n2;
                    bl5 = true;
                    n8 = 0;
                    continue;
                }
                throw new ParseException("Interval with two slashes found: " + string, n2);
            }
            if (n == 84 || n8 > 0) {
                ++n8;
                continue;
            }
            if (n == 45) {
                ++n6;
                ++n3;
                continue;
            }
            if (n == 87) {
                ++n6;
                bl3 = true;
                continue;
            }
            ++n6;
        }
        if (bl5 && bl3 != bl4) {
            throw new ParseException("Mixed date styles not allowed.", n5);
        }
        n2 = string.charAt(n4);
        n = n6 - 4;
        if (n2 == 43 || n2 == 45) {
            n -= 2;
        }
        if (!bl3) {
            bl2 = n3 == 1 || n3 == 0 && n == 3;
        }
        boolean bl6 = n3 > 0;
        boolean bl7 = true;
        if (bl5) {
            if (n8 == 0) {
                bl7 = false;
                n8 = n7;
                n7 = 0;
            }
            bl = n6 == n7 && n3 == n9;
        }
        ChronoFormatter chronoFormatter = bl6 ? Iso8601Format.EXTENDED_DATE_TIME : Iso8601Format.BASIC_DATE_TIME;
        ChronoFormatter chronoFormatter2 = bl ? chronoFormatter : null;
        Parser parser = new Parser((ChronoParser<PlainTimestamp>)chronoFormatter, (ChronoParser<PlainTimestamp>)chronoFormatter2, bl6, bl3, bl2, n8, bl7);
        return (TimestampInterval)parser.parse(string);
    }

    @Override
    IntervalFactory<PlainTimestamp, TimestampInterval> getFactory() {
        return TimestampIntervalFactory.INSTANCE;
    }

    @Override
    TimestampInterval getContext() {
        return this;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SPX(this, 34);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class SystemTimezoneHolder {
        private static final Timezone SYS_TZ = Boolean.getBoolean("net.time4j.allow.system.tz.override") ? null : SystemTimezoneHolder.create();

        private SystemTimezoneHolder() {
        }

        static Timezone get() {
            return SYS_TZ == null ? SystemTimezoneHolder.create() : SYS_TZ;
        }

        private static Timezone create() {
            return Timezone.ofSystem().with(GapResolver.NEXT_VALID_TIME.and(OverlapResolver.EARLIER_OFFSET));
        }
    }

    private static class Parser
    extends IntervalParser<PlainTimestamp, TimestampInterval> {
        private final boolean extended;
        private final boolean weekStyle;
        private final boolean ordinalStyle;
        private final int protectedArea;
        private final boolean hasT;

        Parser(ChronoParser<PlainTimestamp> chronoParser, ChronoParser<PlainTimestamp> chronoParser2, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super(TimestampIntervalFactory.INSTANCE, chronoParser, chronoParser2, BracketPolicy.SHOW_NEVER, Character.valueOf('/'));
            this.extended = bl;
            this.weekStyle = bl2;
            this.ordinalStyle = bl3;
            this.protectedArea = n;
            this.hasT = bl4;
        }

        @Override
        protected PlainTimestamp parseReducedEnd(CharSequence charSequence, PlainTimestamp plainTimestamp, ParseLog parseLog, ParseLog parseLog2, AttributeQuery attributeQuery) {
            ChronoFormatter<PlainTimestamp> chronoFormatter = this.createEndFormat(PlainTimestamp.axis().preformat((Object)plainTimestamp, attributeQuery), parseLog.getRawValues());
            return (PlainTimestamp)chronoFormatter.parse(charSequence, parseLog2);
        }

        private ChronoFormatter<PlainTimestamp> createEndFormat(ChronoDisplay chronoDisplay, ChronoEntity<?> chronoEntity) {
            int n;
            AdjustableElement adjustableElement;
            ChronoFormatter.Builder builder = ChronoFormatter.setUp(PlainTimestamp.class, (Locale)Locale.ROOT);
            AdjustableElement adjustableElement2 = adjustableElement = this.weekStyle ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
            if (this.extended) {
                n = (this.ordinalStyle ? 3 : 5) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
                builder.addCustomized((ChronoElement)adjustableElement, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(this.weekStyle ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR));
            } else {
                n = (this.ordinalStyle ? 3 : 4) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
                builder.addInteger((ChronoElement)adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
            }
            builder.endSection();
            if (this.weekStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 1 + this.protectedArea);
                builder.addCustomized((ChronoElement)Weekmodel.ISO.weekOfYear(), (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(this.extended ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR));
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedNumerical((ChronoElement)PlainDate.DAY_OF_WEEK, 1);
                builder.endSection();
            } else if (this.ordinalStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_YEAR, 3);
                builder.endSection();
            } else {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 2 + this.protectedArea);
                if (this.extended) {
                    builder.addCustomized((ChronoElement)PlainDate.MONTH_AS_NUMBER, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)FixedNumParser.CALENDAR_MONTH);
                } else {
                    builder.addFixedInteger((ChronoElement)PlainDate.MONTH_AS_NUMBER, 2);
                }
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_MONTH, 2);
                builder.endSection();
            }
            if (this.hasT) {
                builder.addLiteral('T');
            }
            builder.addCustomized((ChronoElement)PlainTime.COMPONENT, this.extended ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
            for (ChronoElement<?> chronoElement : TimestampIntervalFactory.INSTANCE.stdElements(chronoEntity)) {
                Parser.setDefault((ChronoFormatter.Builder<PlainTimestamp>)builder, chronoElement, chronoDisplay);
            }
            return builder.build();
        }

        private static <V> void setDefault(ChronoFormatter.Builder<PlainTimestamp> builder, ChronoElement<V> chronoElement, ChronoDisplay chronoDisplay) {
            builder.setDefault(chronoElement, chronoDisplay.get(chronoElement));
        }
    }
}

