/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.time4j.AdjustableElement;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.MachineTime;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.format.Attributes;
import net.time4j.format.DisplayMode;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.FixedNumParser;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.MomentIntervalFactory;
import net.time4j.range.NoopPrinter;
import net.time4j.range.SPX;
import net.time4j.range.TimestampInterval;
import net.time4j.range.YearParser;
import net.time4j.scale.TimeScale;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class MomentInterval
extends IsoInterval<Moment, MomentInterval>
implements Serializable {
    public static final MomentInterval ALWAYS = MomentIntervalFactory.INSTANCE.between(Boundary.infinitePast(), Boundary.infiniteFuture());
    public static double LEFT_ALIGNED = 1.0;
    public static double CENTERED = 0.5;
    public static double RIGHT_ALIGNED = 0.0;
    private static final long serialVersionUID = -5403584519478162113L;
    private static final Comparator<ChronoInterval<Moment>> COMPARATOR = new IntervalComparator<Moment>((TimeLine<Moment>)Moment.axis());

    MomentInterval(Boundary<Moment> boundary, Boundary<Moment> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<Moment>> comparator() {
        return COMPARATOR;
    }

    public static MomentInterval between(Moment moment, Moment moment2) {
        return new MomentInterval(Boundary.of(IntervalEdge.CLOSED, moment), Boundary.of(IntervalEdge.OPEN, moment2));
    }

    public static MomentInterval since(Moment moment) {
        Boundary<Moment> boundary = Boundary.infiniteFuture();
        return new MomentInterval(Boundary.of(IntervalEdge.CLOSED, moment), boundary);
    }

    public static MomentInterval until(Moment moment) {
        Boundary<Moment> boundary = Boundary.infinitePast();
        return new MomentInterval(boundary, Boundary.of(IntervalEdge.OPEN, moment));
    }

    public static MomentInterval surrounding(Moment moment, MachineTime<?> machineTime, double d) {
        if (Double.compare(d, 0.0) < 0 || Double.compare(d, 1.0) > 0) {
            throw new IllegalArgumentException("Out of range: " + d);
        }
        Moment moment2 = MomentInterval.subtract(moment, machineTime.multipliedBy(d));
        return MomentInterval.between(moment2, d == 1.0 ? moment : MomentInterval.add(moment2, machineTime));
    }

    public static MomentInterval from(ChronoInterval<Moment> chronoInterval) {
        if (chronoInterval instanceof MomentInterval) {
            return (MomentInterval)MomentInterval.class.cast(chronoInterval);
        }
        return new MomentInterval(chronoInterval.getStart(), chronoInterval.getEnd());
    }

    public TimestampInterval toLocalInterval() {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toLocalTimestamp();
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toLocalTimestamp();
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public TimestampInterval toZonalInterval(TZID tZID) {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toZonalTimestamp(tZID);
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toZonalTimestamp(tZID);
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public TimestampInterval toZonalInterval(String string) {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toZonalTimestamp(string);
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toZonalTimestamp(string);
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public Duration<IsoUnit> getNominalDuration(Timezone timezone, IsoUnit ... isoUnitArray) {
        return this.toZonalInterval(timezone.getID()).getDuration(timezone, isoUnitArray);
    }

    public MachineTime<TimeUnit> getSimpleDuration() {
        boolean bl;
        Moment moment = (Moment)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = moment == null;
        if (bl) {
            moment = (Moment)this.getEnd().getTemporal();
        }
        MachineTime machineTime = (MachineTime)MachineTime.ON_POSIX_SCALE.between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)moment);
        if (bl) {
            return machineTime.plus(1L, (Object)TimeUnit.NANOSECONDS);
        }
        return machineTime;
    }

    public MachineTime<SI> getRealDuration() {
        boolean bl;
        Moment moment = (Moment)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = moment == null;
        if (bl) {
            moment = (Moment)this.getEnd().getTemporal();
        }
        MachineTime machineTime = (MachineTime)MachineTime.ON_UTC_SCALE.between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)moment);
        if (bl) {
            return machineTime.plus(1L, (Object)SI.NANOSECONDS);
        }
        return machineTime;
    }

    public MomentInterval move(long l, TimeUnit timeUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((Moment)this.getStart().getTemporal()).plus(l, (Object)timeUnit));
        Boundary<Object> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((Moment)this.getEnd().getTemporal()).plus(l, (Object)timeUnit));
        return new MomentInterval((Boundary<Moment>)boundary, (Boundary<Moment>)boundary2);
    }

    public MomentInterval move(long l, SI sI) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((Moment)this.getStart().getTemporal()).plus(l, sI));
        Boundary<Moment> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((Moment)this.getEnd().getTemporal()).plus(l, sI));
        return new MomentInterval((Boundary<Moment>)boundary, boundary2);
    }

    public static MomentInterval parse(String string, ChronoParser<Moment> chronoParser) throws ParseException {
        return MomentInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static MomentInterval parse(String string, ChronoParser<Moment> chronoParser, String string2) throws ParseException {
        ParseLog parseLog = new ParseLog();
        MomentInterval momentInterval = IntervalParser.parseCustom(string, MomentIntervalFactory.INSTANCE, chronoParser, string2, parseLog);
        if (parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (momentInterval == null) {
            throw new ParseException("Parsing of interval failed: " + string, parseLog.getPosition());
        }
        return momentInterval;
    }

    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, char c, ChronoParser<Moment> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c).parse(charSequence, parseLog, IsoInterval.extractDefaultAttributes(chronoParser));
    }

    public static MomentInterval parseISO(String string) throws ParseException {
        int n;
        int n2;
        int n3;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        int n4 = 0;
        int n5 = Math.min(string.length(), 117);
        boolean bl = true;
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        if (string.charAt(0) == 'P') {
            for (n3 = 1; n3 < n5; ++n3) {
                if (string.charAt(n3) != '/') continue;
                if (n3 + 1 == n5) {
                    throw new ParseException("Missing end component.", n5);
                }
                n4 = n3 + 1;
                break;
            }
        }
        n3 = 0;
        int n9 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n10 = -1;
        for (n2 = n4 + 1; n2 < n5; ++n2) {
            n = string.charAt(n2);
            if (bl5) {
                if (n == 80) {
                    bl5 = false;
                    break;
                }
                if (n == 84 || n8 > 0) {
                    ++n8;
                    continue;
                }
                if (n == 87) {
                    bl4 = true;
                } else if (n == 45 && n2 > n10 + 1) {
                    ++n9;
                }
                ++n7;
                continue;
            }
            if (n == 47) {
                if (n10 == -1) {
                    n10 = n2;
                    bl5 = true;
                    n8 = 0;
                    continue;
                }
                throw new ParseException("Interval with two slashes found: " + string, n2);
            }
            if (n == 84 || n8 > 0) {
                ++n8;
                continue;
            }
            if (n == 45) {
                ++n6;
                ++n3;
                continue;
            }
            if (n == 87) {
                ++n6;
                bl3 = true;
                continue;
            }
            ++n6;
        }
        if (bl5 && bl3 != bl4) {
            throw new ParseException("Mixed date styles not allowed.", n5);
        }
        n2 = string.charAt(n4);
        n = n6 - 4;
        if (n2 == 43 || n2 == 45) {
            n -= 2;
        }
        if (!bl3) {
            bl2 = n3 == 1 || n3 == 0 && n == 3;
        }
        boolean bl6 = n3 > 0;
        boolean bl7 = true;
        if (bl5) {
            if (n8 == 0) {
                bl7 = false;
                n8 = n7;
                n7 = 0;
            }
            bl = n6 == n7 && n3 == n9 && MomentInterval.hasSecondOffset(string, n5);
        }
        ChronoFormatter chronoFormatter = bl6 ? Iso8601Format.EXTENDED_DATE_TIME_OFFSET : Iso8601Format.BASIC_DATE_TIME_OFFSET;
        ChronoFormatter chronoFormatter2 = bl ? chronoFormatter : null;
        Parser parser = new Parser((ChronoParser<Moment>)chronoFormatter, (ChronoParser<Moment>)chronoFormatter2, bl6, bl3, bl2, n8, bl7);
        return (MomentInterval)parser.parse(string);
    }

    @Override
    IntervalFactory<Moment, MomentInterval> getFactory() {
        return MomentIntervalFactory.INSTANCE;
    }

    @Override
    MomentInterval getContext() {
        return this;
    }

    private static boolean hasSecondOffset(String string, int n) {
        char c;
        if (string.charAt(n - 1) == 'Z') {
            return true;
        }
        int n2 = Math.max(0, n - 6);
        for (int i = n - 1; i >= n2 && (c = string.charAt(i)) != 'T' && c != '/' && c != '.' && c != ','; --i) {
            if (c != '+' && c != '-') continue;
            return true;
        }
        return false;
    }

    private static Moment add(Moment moment, MachineTime<?> machineTime) {
        if (machineTime.getScale() == TimeScale.UTC) {
            MachineTime<?> machineTime2 = machineTime;
            return moment.plus(machineTime2);
        }
        MachineTime<?> machineTime3 = machineTime;
        return (Moment)moment.plus(machineTime3);
    }

    private static Moment subtract(Moment moment, MachineTime<?> machineTime) {
        if (machineTime.getScale() == TimeScale.UTC) {
            MachineTime<?> machineTime2 = machineTime;
            return moment.minus(machineTime2);
        }
        MachineTime<?> machineTime3 = machineTime;
        return (Moment)moment.minus(machineTime3);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SPX(this, 35);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class Parser
    extends IntervalParser<Moment, MomentInterval> {
        private final boolean extended;
        private final boolean weekStyle;
        private final boolean ordinalStyle;
        private final int protectedArea;
        private final boolean hasT;

        Parser(ChronoParser<Moment> chronoParser, ChronoParser<Moment> chronoParser2, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super(MomentIntervalFactory.INSTANCE, chronoParser, chronoParser2, BracketPolicy.SHOW_NEVER, Character.valueOf('/'));
            this.extended = bl;
            this.weekStyle = bl2;
            this.ordinalStyle = bl3;
            this.protectedArea = n;
            this.hasT = bl4;
        }

        @Override
        protected Moment parseReducedEnd(CharSequence charSequence, Moment moment, ParseLog parseLog, ParseLog parseLog2, AttributeQuery attributeQuery) {
            ChronoFormatter<Moment> chronoFormatter = this.createEndFormat(Moment.axis().preformat((Object)moment, attributeQuery), parseLog.getRawValues());
            return (Moment)chronoFormatter.parse(charSequence, parseLog2);
        }

        private ChronoFormatter<Moment> createEndFormat(ChronoDisplay chronoDisplay, ChronoEntity<?> chronoEntity) {
            int n;
            AdjustableElement adjustableElement;
            ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.class, (Locale)Locale.ROOT);
            AdjustableElement adjustableElement2 = adjustableElement = this.weekStyle ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
            if (this.extended) {
                n = (this.ordinalStyle ? 3 : 5) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
                builder.addCustomized((ChronoElement)adjustableElement, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(this.weekStyle ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR));
            } else {
                n = (this.ordinalStyle ? 3 : 4) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
                builder.addInteger((ChronoElement)adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
            }
            builder.endSection();
            if (this.weekStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 1 + this.protectedArea);
                builder.addCustomized((ChronoElement)Weekmodel.ISO.weekOfYear(), (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(this.extended ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR));
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedNumerical((ChronoElement)PlainDate.DAY_OF_WEEK, 1);
                builder.endSection();
            } else if (this.ordinalStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_YEAR, 3);
                builder.endSection();
            } else {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 2 + this.protectedArea);
                if (this.extended) {
                    builder.addCustomized((ChronoElement)PlainDate.MONTH_AS_NUMBER, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)FixedNumParser.CALENDAR_MONTH);
                } else {
                    builder.addFixedInteger((ChronoElement)PlainDate.MONTH_AS_NUMBER, 2);
                }
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_MONTH, 2);
                builder.endSection();
            }
            if (this.hasT) {
                builder.addLiteral('T');
            }
            builder.addCustomized((ChronoElement)PlainTime.COMPONENT, this.extended ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
            builder.startOptionalSection();
            builder.addTimezoneOffset(DisplayMode.SHORT, this.extended, Collections.singletonList("Z"));
            builder.endSection();
            for (ChronoElement<?> chronoElement : MomentIntervalFactory.INSTANCE.stdElements(chronoEntity)) {
                Parser.setDefault((ChronoFormatter.Builder<Moment>)builder, chronoElement, chronoDisplay);
            }
            Attributes attributes = new Attributes.Builder().setTimezone(chronoEntity.getTimezone()).build();
            return builder.build(attributes);
        }

        private static <V> void setDefault(ChronoFormatter.Builder<Moment> builder, ChronoElement<V> chronoElement, ChronoDisplay chronoDisplay) {
            builder.setDefault(chronoElement, chronoDisplay.get(chronoElement));
        }
    }
}

