/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.util.Comparator;
import net.time4j.engine.TimeLine;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;

final class IntervalComparator<T>
implements Comparator<ChronoInterval<T>> {
    private final boolean calendrical;
    private final TimeLine<T> axis;

    IntervalComparator(TimeLine<T> timeLine) {
        this.calendrical = timeLine.isCalendrical();
        this.axis = timeLine;
    }

    @Override
    public int compare(ChronoInterval<T> chronoInterval, ChronoInterval<T> chronoInterval2) {
        Boundary<T> boundary = chronoInterval.getStart();
        Boundary<T> boundary2 = chronoInterval2.getStart();
        if (boundary.isInfinite()) {
            if (boundary2.isInfinite()) {
                return this.compareEnd(chronoInterval, chronoInterval2);
            }
            return -1;
        }
        if (boundary2.isInfinite()) {
            return 1;
        }
        Object object = boundary.getTemporal();
        Object object2 = boundary2.getTemporal();
        if (boundary.isOpen()) {
            object = this.axis.stepForward(object);
        }
        if (boundary2.isOpen()) {
            object2 = this.axis.stepForward(object2);
        }
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        int n = this.axis.compare(object, object2);
        if (n == 0) {
            n = this.compareEnd(chronoInterval, chronoInterval2);
        }
        return n;
    }

    private int compareEnd(ChronoInterval<T> chronoInterval, ChronoInterval<T> chronoInterval2) {
        Boundary<T> boundary = chronoInterval.getEnd();
        Boundary<T> boundary2 = chronoInterval2.getEnd();
        if (boundary.isInfinite()) {
            if (boundary2.isInfinite()) {
                return 0;
            }
            return 1;
        }
        if (boundary2.isInfinite()) {
            return -1;
        }
        Object object = boundary.getTemporal();
        Object object2 = boundary2.getTemporal();
        if (this.calendrical) {
            if (boundary.isOpen()) {
                object = this.axis.stepBackwards(object);
            }
            if (boundary2.isOpen()) {
                object2 = this.axis.stepBackwards(object2);
            }
            if (object == null) {
                if (object2 == null) {
                    return 0;
                }
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
        } else {
            if (boundary.isClosed()) {
                object = this.axis.stepForward(object);
            }
            if (boundary2.isClosed()) {
                object2 = this.axis.stepForward(object2);
            }
            if (object == null) {
                if (object2 == null) {
                    return 0;
                }
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
        }
        return this.axis.compare(object, object2);
    }
}

