/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.time4j.SI;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.engine.RealTime;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.format.TimeSpanFormatter;
import net.time4j.range.SPX;
import net.time4j.scale.TimeScale;
import net.time4j.scale.UniversalTime;

public final class MachineTime<U>
implements RealTime<U>,
Comparable<MachineTime<U>>,
Serializable {
    private static final int MRD = 1000000000;
    private static final MachineTime<TimeUnit> POSIX_ZERO = new MachineTime(0L, 0, TimeScale.POSIX);
    private static final MachineTime<SI> UTC_ZERO = new MachineTime(0L, 0, TimeScale.UTC);
    public static final TimeMetric<TimeUnit, MachineTime<TimeUnit>> ON_POSIX_SCALE = new Metric<TimeUnit>(TimeScale.POSIX);
    public static final TimeMetric<TimeUnit, MachineTime<SI>> ON_UTC_SCALE = new Metric<SI>(TimeScale.UTC);
    private static final long serialVersionUID = -4150291820807606229L;
    private final transient long seconds;
    private final transient int nanos;
    private final transient TimeScale scale;

    private MachineTime(long l, int n, TimeScale timeScale) {
        while (n < 0) {
            n += 1000000000;
            l = MathUtils.safeSubtract((long)l, (long)1L);
        }
        while (n >= 1000000000) {
            n -= 1000000000;
            l = MathUtils.safeAdd((long)l, (long)1L);
        }
        if (l < 0L && n > 0) {
            ++l;
            n -= 1000000000;
        }
        this.seconds = l;
        this.nanos = n;
        this.scale = timeScale;
    }

    public static MachineTime<TimeUnit> of(long l, TimeUnit timeUnit) {
        if (timeUnit.compareTo(TimeUnit.SECONDS) >= 0) {
            long l2 = MathUtils.safeMultiply((long)l, (long)TimeUnit.SECONDS.convert(1L, timeUnit));
            return MachineTime.ofPosixUnits(l2, 0);
        }
        long l3 = MathUtils.safeMultiply((long)l, (long)TimeUnit.NANOSECONDS.convert(1L, timeUnit));
        long l4 = MathUtils.floorDivide((long)l3, (int)1000000000);
        int n = MathUtils.floorModulo((long)l3, (int)1000000000);
        return MachineTime.ofPosixUnits(l4, n);
    }

    public static MachineTime<SI> of(long l, SI sI) {
        switch (sI) {
            case SECONDS: {
                return MachineTime.ofSIUnits(l, 0);
            }
            case NANOSECONDS: {
                long l2 = MathUtils.floorDivide((long)l, (int)1000000000);
                int n = MathUtils.floorModulo((long)l, (int)1000000000);
                return MachineTime.ofSIUnits(l2, n);
            }
        }
        throw new UnsupportedOperationException(sI.name());
    }

    public static MachineTime<TimeUnit> ofPosixUnits(long l, int n) {
        if (l == 0L && n == 0) {
            return POSIX_ZERO;
        }
        return new MachineTime<TimeUnit>(l, n, TimeScale.POSIX);
    }

    public static MachineTime<SI> ofSIUnits(long l, int n) {
        if (l == 0L && n == 0) {
            return UTC_ZERO;
        }
        return new MachineTime<SI>(l, n, TimeScale.UTC);
    }

    public static MachineTime<TimeUnit> ofPosixSeconds(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Invalid value: " + d);
        }
        long l = (long)Math.floor(d);
        int n = (int)((d - (double)l) * 1.0E9);
        return MachineTime.ofPosixUnits(l, n);
    }

    public static MachineTime<TimeUnit> ofPosixSeconds(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, RoundingMode.FLOOR);
        int n = bigDecimal.subtract(bigDecimal2).multiply(BigDecimal.valueOf(1000000000L)).setScale(0, RoundingMode.DOWN).intValueExact();
        return MachineTime.ofPosixUnits(bigDecimal2.longValueExact(), n);
    }

    public static MachineTime<SI> ofSISeconds(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException("Invalid value: " + d);
        }
        long l = (long)Math.floor(d);
        int n = (int)((d - (double)l) * 1.0E9);
        return MachineTime.ofSIUnits(l, n);
    }

    public static MachineTime<SI> ofSISeconds(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, RoundingMode.FLOOR);
        int n = bigDecimal.subtract(bigDecimal2).multiply(BigDecimal.valueOf(1000000000L)).setScale(0, RoundingMode.DOWN).intValueExact();
        return MachineTime.ofSIUnits(bigDecimal2.longValueExact(), n);
    }

    public long getSeconds() {
        long l = this.seconds;
        if (this.nanos < 0) {
            --l;
        }
        return l;
    }

    public int getFraction() {
        int n = this.nanos;
        if (n < 0) {
            n += 1000000000;
        }
        return n;
    }

    public TimeScale getScale() {
        return this.scale;
    }

    public List<TimeSpan.Item<U>> getTotalLength() {
        U u;
        Object object;
        ArrayList<TimeSpan.Item> arrayList = new ArrayList<TimeSpan.Item>(2);
        if (this.seconds != 0L) {
            object = this.scale == TimeScale.UTC ? SI.SECONDS : TimeUnit.SECONDS;
            u = MachineTime.cast(object);
            arrayList.add(TimeSpan.Item.of((long)Math.abs(this.seconds), u));
        }
        if (this.nanos != 0) {
            object = this.scale == TimeScale.UTC ? SI.NANOSECONDS : TimeUnit.NANOSECONDS;
            u = MachineTime.cast(object);
            arrayList.add(TimeSpan.Item.of((long)Math.abs(this.nanos), u));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public boolean contains(Object object) {
        if (this.scale == TimeScale.POSIX && TimeUnit.SECONDS.equals(object) || this.scale == TimeScale.UTC && SI.SECONDS.equals(object)) {
            return this.seconds != 0L;
        }
        if (this.scale == TimeScale.POSIX && TimeUnit.NANOSECONDS.equals(object) || this.scale == TimeScale.UTC && SI.NANOSECONDS.equals(object)) {
            return this.nanos != 0;
        }
        return false;
    }

    public long getPartialAmount(Object object) {
        if (this.scale == TimeScale.POSIX && TimeUnit.SECONDS.equals(object) || this.scale == TimeScale.UTC && SI.SECONDS.equals(object)) {
            return Math.abs(this.seconds);
        }
        if (this.scale == TimeScale.POSIX && TimeUnit.NANOSECONDS.equals(object) || this.scale == TimeScale.UTC && SI.NANOSECONDS.equals(object)) {
            return Math.abs(this.nanos);
        }
        return 0L;
    }

    public boolean isNegative() {
        return this.seconds < 0L || this.nanos < 0;
    }

    public boolean isPositive() {
        return this.seconds > 0L || this.nanos > 0;
    }

    public boolean isEmpty() {
        return this.seconds == 0L && this.nanos == 0;
    }

    public MachineTime<U> plus(long l, U u) {
        long l2 = this.seconds;
        int n = this.nanos;
        if (this.scale == TimeScale.POSIX) {
            TimeUnit timeUnit = (TimeUnit)((Object)TimeUnit.class.cast(u));
            if (timeUnit.compareTo(TimeUnit.SECONDS) >= 0) {
                l2 = MathUtils.safeAdd((long)l2, (long)MathUtils.safeMultiply((long)l, (long)TimeUnit.SECONDS.convert(1L, timeUnit)));
            } else {
                long l3 = MathUtils.safeAdd((long)n, (long)MathUtils.safeMultiply((long)l, (long)TimeUnit.NANOSECONDS.convert(1L, timeUnit)));
                l2 = MathUtils.safeAdd((long)l2, (long)MathUtils.floorDivide((long)l3, (int)1000000000));
                n = MathUtils.floorModulo((long)l3, (int)1000000000);
            }
        } else {
            switch ((SI)SI.class.cast(u)) {
                case SECONDS: {
                    l2 = MathUtils.safeAdd((long)l2, (long)l);
                    break;
                }
                case NANOSECONDS: {
                    long l4 = MathUtils.safeAdd((long)n, (long)l);
                    l2 = MathUtils.safeAdd((long)l2, (long)MathUtils.floorDivide((long)l4, (int)1000000000));
                    n = MathUtils.floorModulo((long)l4, (int)1000000000);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(u.toString());
                }
            }
        }
        return new MachineTime<U>(l2, n, this.scale);
    }

    public MachineTime<U> plus(MachineTime<U> machineTime) {
        if (machineTime.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return machineTime;
        }
        long l = MathUtils.safeAdd((long)this.seconds, (long)machineTime.seconds);
        int n = this.nanos + machineTime.nanos;
        return new MachineTime<U>(l, n, this.scale);
    }

    public MachineTime<U> minus(long l, U u) {
        return this.plus(MathUtils.safeNegate((long)l), u);
    }

    public MachineTime<U> minus(MachineTime<U> machineTime) {
        if (machineTime.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return machineTime.inverse();
        }
        long l = MathUtils.safeSubtract((long)this.seconds, (long)machineTime.seconds);
        int n = this.nanos - machineTime.nanos;
        return new MachineTime<U>(l, n, this.scale);
    }

    public MachineTime<U> abs() {
        if (this.isNegative()) {
            return new MachineTime<U>(MathUtils.safeNegate((long)this.seconds), -this.nanos, this.scale);
        }
        return this;
    }

    public MachineTime<U> inverse() {
        if (this.isEmpty()) {
            return this;
        }
        return new MachineTime<U>(MathUtils.safeNegate((long)this.seconds), -this.nanos, this.scale);
    }

    public MachineTime<U> multipliedBy(long l) {
        if (l == 1L) {
            return this;
        }
        BigDecimal bigDecimal = this.toBigDecimal().multiply(BigDecimal.valueOf(l));
        MachineTime<TimeUnit> machineTime = this.scale == TimeScale.POSIX ? MachineTime.ofPosixSeconds(bigDecimal) : MachineTime.ofSISeconds(bigDecimal);
        return (MachineTime)MachineTime.cast(machineTime);
    }

    @Deprecated
    public MachineTime<U> dividedBy(long l) {
        return this.dividedBy(l, RoundingMode.HALF_UP);
    }

    public MachineTime<U> dividedBy(long l, RoundingMode roundingMode) {
        if (l == 1L) {
            return this;
        }
        BigDecimal bigDecimal = this.toBigDecimal().setScale(9, RoundingMode.FLOOR).divide(new BigDecimal(l), roundingMode);
        MachineTime<TimeUnit> machineTime = this.scale == TimeScale.POSIX ? MachineTime.ofPosixSeconds(bigDecimal) : MachineTime.ofSISeconds(bigDecimal);
        return (MachineTime)MachineTime.cast(machineTime);
    }

    public <T extends TimePoint<? super U, T>> T addTo(T t) {
        U u;
        U u2;
        if (this.scale == TimeScale.POSIX) {
            u2 = MachineTime.cast((Object)TimeUnit.SECONDS);
            u = MachineTime.cast((Object)TimeUnit.NANOSECONDS);
        } else {
            u2 = MachineTime.cast(SI.SECONDS);
            u = MachineTime.cast(SI.NANOSECONDS);
        }
        return (T)t.plus(this.seconds, u2).plus((long)this.nanos, u);
    }

    public <T extends TimePoint<? super U, T>> T subtractFrom(T t) {
        U u;
        U u2;
        if (this.scale == TimeScale.POSIX) {
            u2 = MachineTime.cast((Object)TimeUnit.SECONDS);
            u = MachineTime.cast((Object)TimeUnit.NANOSECONDS);
        } else {
            u2 = MachineTime.cast(SI.SECONDS);
            u = MachineTime.cast(SI.NANOSECONDS);
        }
        return (T)t.minus(this.seconds, u2).minus((long)this.nanos, u);
    }

    public boolean isShorterThan(MachineTime<U> machineTime) {
        return this.abs().compareTo(machineTime.abs()) < 0;
    }

    public boolean isLongerThan(MachineTime<U> machineTime) {
        return this.abs().compareTo(machineTime.abs()) > 0;
    }

    @Override
    public int compareTo(MachineTime<U> machineTime) {
        if (this.scale == machineTime.scale) {
            if (this.seconds < machineTime.seconds) {
                return -1;
            }
            if (this.seconds > machineTime.seconds) {
                return 1;
            }
            return this.nanos - machineTime.nanos;
        }
        throw new ClassCastException("Different time scales.");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MachineTime) {
            MachineTime machineTime = (MachineTime)object;
            return this.seconds == machineTime.seconds && this.nanos == machineTime.nanos && this.scale == machineTime.scale;
        }
        return false;
    }

    public int hashCode() {
        int n = 7;
        n = 23 * n + (int)(this.seconds ^ this.seconds >>> 32);
        n = 23 * n + this.nanos;
        n = 23 * n + this.scale.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.createNumber(stringBuilder);
        stringBuilder.append("s [");
        stringBuilder.append(this.scale.name());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public BigDecimal toBigDecimal() {
        StringBuilder stringBuilder = new StringBuilder();
        this.createNumber(stringBuilder);
        return new BigDecimal(stringBuilder.toString());
    }

    private void createNumber(StringBuilder stringBuilder) {
        if (this.isNegative()) {
            stringBuilder.append('-');
            stringBuilder.append(Math.abs(this.seconds));
        } else {
            stringBuilder.append(this.seconds);
        }
        if (this.nanos != 0) {
            stringBuilder.append('.');
            String string = String.valueOf(Math.abs(this.nanos));
            for (int i = 9 - string.length(); i > 0; --i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
    }

    private static <U> U cast(Object object) {
        return (U)object;
    }

    private Object writeReplace() {
        return new SPX(this, 7);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class Metric<U>
    implements TimeMetric<TimeUnit, MachineTime<U>> {
        private final TimeScale scale;

        private Metric(TimeScale timeScale) {
            this.scale = timeScale;
        }

        public <T extends TimePoint<? super TimeUnit, T>> MachineTime<U> between(T t, T t2) {
            int n;
            long l;
            if (this.scale == TimeScale.UTC && t instanceof UniversalTime) {
                UniversalTime universalTime = (UniversalTime)t;
                UniversalTime universalTime2 = (UniversalTime)t2;
                long l2 = universalTime2.getElapsedTime(TimeScale.UTC);
                long l3 = universalTime.getElapsedTime(TimeScale.UTC);
                if (l2 < 0L || l3 < 0L) {
                    throw new UnsupportedOperationException("Cannot calculate SI-duration before 1972-01-01.");
                }
                l = l2 - l3;
                n = universalTime2.getNanosecond(TimeScale.UTC) - universalTime.getNanosecond(TimeScale.UTC);
            } else if (t instanceof UnixTime) {
                UnixTime unixTime = (UnixTime)t;
                UnixTime unixTime2 = (UnixTime)t2;
                l = unixTime2.getPosixTime() - unixTime.getPosixTime();
                n = unixTime2.getNanosecond() - unixTime.getNanosecond();
            } else {
                throw new UnsupportedOperationException("Machine time requires objects of type 'UnixTime'.");
            }
            return new MachineTime(l, n, this.scale);
        }
    }

    private static class Normalized
    implements TimeSpan<TimeUnit> {
        private final TimeSpan<? super TimeUnit> duration;
        private final Set<TimeUnit> patternUnits;

        Normalized(TimeSpan<? super TimeUnit> timeSpan, Set<TimeUnit> set) {
            if (timeSpan == null) {
                throw new NullPointerException();
            }
            this.duration = timeSpan;
            this.patternUnits = set;
        }

        public List<TimeSpan.Item<TimeUnit>> getTotalLength() {
            throw new AssertionError((Object)"Never called.");
        }

        public boolean contains(TimeUnit timeUnit) {
            return true;
        }

        public long getPartialAmount(TimeUnit timeUnit) {
            if (timeUnit == TimeUnit.NANOSECONDS) {
                return this.duration.getPartialAmount((Object)TimeUnit.NANOSECONDS);
            }
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = this.duration.getPartialAmount((Object)TimeUnit.SECONDS);
            if (this.patternUnits.contains((Object)TimeUnit.DAYS)) {
                l = l4 / 86400L;
                l4 -= l * 86400L;
            }
            if (this.patternUnits.contains((Object)TimeUnit.HOURS)) {
                l2 = l4 / 3600L;
                l4 -= l2 * 3600L;
            }
            if (this.patternUnits.contains((Object)TimeUnit.MINUTES)) {
                l3 = l4 / 60L;
                l4 -= l3 * 60L;
            }
            switch (timeUnit) {
                case DAYS: {
                    return l;
                }
                case HOURS: {
                    return l2;
                }
                case MINUTES: {
                    return l3;
                }
                case SECONDS: {
                    return l4;
                }
            }
            throw new AssertionError((Object)"Never called.");
        }

        public boolean isNegative() {
            return this.duration.isNegative();
        }

        public boolean isPositive() {
            return this.duration.isPositive();
        }

        public boolean isEmpty() {
            return this.duration.isEmpty();
        }

        public <T extends TimePoint<? super TimeUnit, T>> T addTo(T t) {
            throw new AssertionError((Object)"Never called.");
        }

        public <T extends TimePoint<? super TimeUnit, T>> T subtractFrom(T t) {
            throw new AssertionError((Object)"Never called.");
        }
    }

    public static final class Formatter
    extends TimeSpanFormatter<TimeUnit, MachineTime<TimeUnit>> {
        private Formatter(String string) {
            super(TimeUnit.class, string);
        }

        public static Formatter ofPattern(String string) {
            return new Formatter(string);
        }

        public void print(TimeSpan<? super TimeUnit> timeSpan, Appendable appendable) throws IOException {
            String string = this.getPattern();
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            block0: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\'') {
                    ++i;
                    while (i < n) {
                        if (string.charAt(i) == '\'') {
                            if (i + 1 >= n || string.charAt(i + 1) != '\'') continue block0;
                            ++i;
                        }
                        ++i;
                    }
                    continue;
                }
                stringBuilder.append(c);
            }
            String string2 = stringBuilder.toString();
            EnumSet<TimeUnit> enumSet = EnumSet.noneOf(TimeUnit.class);
            if (string2.contains("D")) {
                enumSet.add(TimeUnit.DAYS);
            }
            if (string2.contains("h")) {
                enumSet.add(TimeUnit.HOURS);
            }
            if (string2.contains("m")) {
                enumSet.add(TimeUnit.MINUTES);
            }
            if (string2.contains("s")) {
                enumSet.add(TimeUnit.SECONDS);
            }
            if (string2.contains("f")) {
                enumSet.add(TimeUnit.NANOSECONDS);
            }
            super.print((TimeSpan)new Normalized(timeSpan, enumSet), appendable);
        }

        protected MachineTime<TimeUnit> convert(Map<TimeUnit, Long> map, boolean bl) {
            long l = 0L;
            int n = 0;
            if (map.containsKey((Object)TimeUnit.NANOSECONDS)) {
                n = MathUtils.safeCast((long)map.get((Object)TimeUnit.NANOSECONDS));
            }
            block6: for (Map.Entry<TimeUnit, Long> entry : map.entrySet()) {
                int n2;
                switch (entry.getKey()) {
                    case DAYS: {
                        n2 = 86400;
                        break;
                    }
                    case HOURS: {
                        n2 = 3600;
                        break;
                    }
                    case MINUTES: {
                        n2 = 60;
                        break;
                    }
                    case SECONDS: {
                        n2 = 1;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                l += MathUtils.safeMultiply((long)entry.getValue(), (long)n2);
            }
            if (bl) {
                l = MathUtils.safeNegate((long)l);
                n = -n;
            }
            return MachineTime.ofPosixUnits(l, n);
        }

        protected TimeUnit getUnit(char c) {
            switch (c) {
                case 'D': {
                    return TimeUnit.DAYS;
                }
                case 'h': {
                    return TimeUnit.HOURS;
                }
                case 'm': {
                    return TimeUnit.MINUTES;
                }
                case 's': {
                    return TimeUnit.SECONDS;
                }
                case 'f': {
                    return TimeUnit.NANOSECONDS;
                }
            }
            throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
        }
    }
}

