/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import java.util.Set;
import net.time4j.Duration;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeSpan;
import net.time4j.format.Attributes;
import net.time4j.format.ParseLog;
import net.time4j.range.Boundary;
import net.time4j.range.IntervalFactory;
import net.time4j.range.MomentInterval;
import net.time4j.range.TimestampIntervalFactory;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;

final class MomentIntervalFactory
implements IntervalFactory<Moment, MomentInterval> {
    static final MomentIntervalFactory INSTANCE = new MomentIntervalFactory();

    private MomentIntervalFactory() {
    }

    @Override
    public MomentInterval between(Boundary<Moment> boundary, Boundary<Moment> boundary2) {
        return new MomentInterval(boundary, boundary2);
    }

    @Override
    public Moment plusPeriod(Moment moment, String string, ParseLog parseLog, AttributeQuery attributeQuery) {
        Timezone timezone = MomentIntervalFactory.getTimezone(parseLog.getRawValues(), attributeQuery);
        PlainTimestamp plainTimestamp = moment.toZonalTimestamp(timezone.getID());
        try {
            return ((PlainTimestamp)plainTimestamp.plus((TimeSpan)Duration.parsePeriod((String)string))).in(timezone);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Moment minusPeriod(Moment moment, String string, ParseLog parseLog, AttributeQuery attributeQuery) {
        Timezone timezone = MomentIntervalFactory.getTimezone(parseLog.getRawValues(), attributeQuery);
        PlainTimestamp plainTimestamp = moment.toZonalTimestamp(timezone.getID());
        try {
            return ((PlainTimestamp)plainTimestamp.minus((TimeSpan)Duration.parsePeriod((String)string))).in(timezone);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public Set<ChronoElement<?>> stdElements(ChronoEntity<?> chronoEntity) {
        return TimestampIntervalFactory.INSTANCE.stdElements(chronoEntity);
    }

    @Override
    public boolean isCalendrical() {
        return false;
    }

    private static Timezone getTimezone(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery) {
        TZID tZID = null;
        if (chronoEntity.hasTimezone()) {
            tZID = chronoEntity.getTimezone();
        } else if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
            tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
        }
        if (tZID != null) {
            if (attributeQuery.contains(Attributes.TRANSITION_STRATEGY)) {
                TransitionStrategy transitionStrategy = (TransitionStrategy)attributeQuery.get(Attributes.TRANSITION_STRATEGY);
                return Timezone.of((TZID)tZID).with(transitionStrategy);
            }
            return Timezone.of((TZID)tZID);
        }
        throw new AssertionError((Object)"Timezone must exist if a moment was successfully parsed.");
    }
}

