/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import net.time4j.base.MathUtils;

public enum NumberSystem {
    ARABIC{

        @Override
        public String toNumeral(int n) {
            return String.valueOf(n);
        }

        @Override
        public int toInteger(String string) {
            return Integer.parseInt(string);
        }

        @Override
        public boolean contains(char c) {
            return c >= '0' && c <= '9';
        }
    }
    ,
    ETHIOPIC{

        @Override
        public String toNumeral(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Can only convert positive numbers: " + n);
            }
            String string = String.valueOf(n);
            int n2 = string.length() - 1;
            if (n2 % 2 == 0) {
                string = "0" + string;
                ++n2;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = n2; i >= 0; --i) {
                char c;
                char c2 = '\u0000';
                char c3 = '\u0000';
                char c4 = string.charAt(n2 - i);
                if ((c = string.charAt(n2 - --i)) != '0') {
                    c3 = (char)(c + 4920);
                }
                if (c4 != '0') {
                    c2 = (char)(c4 + 4929);
                }
                int n3 = i % 4 / 2;
                char c5 = '\u0000';
                if (i != 0) {
                    char c6 = n3 != 0 ? (c3 != '\u0000' || c2 != '\u0000' ? (char)'\u137b' : '\u0000') : (c5 = '\u137c');
                }
                if (c3 == '\u1369' && c2 == '\u0000' && n2 > 1 && (c5 == '\u137b' || i + 1 == n2)) {
                    c3 = '\u0000';
                }
                if (c2 != '\u0000') {
                    stringBuilder.append(c2);
                }
                if (c3 != '\u0000') {
                    stringBuilder.append(c3);
                }
                if (c5 == '\u0000') continue;
                stringBuilder.append(c5);
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string) {
            int n;
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = n = string.length() - 1; i >= 0; --i) {
                char c = string.charAt(i);
                if (c >= '\u1369' && c < '\u1372') {
                    n3 += '\u0001' + c - 4969;
                    continue;
                }
                if (c >= '\u1372' && c < '\u137b') {
                    n3 += ('\u0001' + c - 4978) * 10;
                    continue;
                }
                if (c == '\u137c') {
                    if (bl && n3 == 0) {
                        n3 = 1;
                    }
                    n2 = NumberSystem.add(n2, n3, n4);
                    n4 = bl ? (n4 *= 100) : (n4 *= 10000);
                    n3 = 0;
                    bl = false;
                    bl2 = true;
                    continue;
                }
                if (c != '\u137b') continue;
                n2 = NumberSystem.add(n2, n3, n4);
                n4 *= 100;
                n3 = 0;
                bl = true;
                bl2 = false;
            }
            if ((bl || bl2) && n3 == 0) {
                n3 = 1;
            }
            n2 = NumberSystem.add(n2, n3, n4);
            return n2;
        }

        @Override
        public boolean contains(char c) {
            return c >= '\u1369' && c <= '\u137c';
        }
    };

    private static final char ETHIOPIC_ONE = '\u1369';
    private static final char ETHIOPIC_TEN = '\u1372';
    private static final char ETHIOPIC_HUNDRED = '\u137b';
    private static final char ETHIOPIC_TEN_THOUSAND = '\u137c';

    public String toNumeral(int n) {
        throw new AbstractMethodError();
    }

    public int toInteger(String string) {
        throw new AbstractMethodError();
    }

    public boolean contains(char c) {
        throw new AbstractMethodError();
    }

    private static int add(int n, int n2, int n3) {
        return MathUtils.safeAdd(n, MathUtils.safeMultiply(n2, n3));
    }
}

