/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.format.CalendarType;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatPatternProvider;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;

public final class CalendarText {
    private static final Set<String> RTL;
    private static final FormatPatternProvider FORMAT_PATTERN_PROVIDER;
    public static final String ISO_CALENDAR_TYPE = "iso8601";
    private static final TextProvider JDK_PROVIDER;
    private static final TextProvider ROOT_PROVIDER;
    private static final ConcurrentMap<String, CalendarText> CACHE;
    private final String provider;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> stdMonths;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> leapMonths;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> quarters;
    private final Map<TextWidth, Map<OutputContext, TextAccessor>> weekdays;
    private final Map<TextWidth, TextAccessor> eras;
    private final Map<TextWidth, TextAccessor> meridiems;
    private final ResourceBundle textForms;
    private final MissingResourceException mre;

    /*
     * WARNING - void declaration
     */
    private CalendarText(String string, Locale locale, TextProvider textProvider) {
        void var10_27;
        void var9_18;
        void var11_34;
        void var10_23;
        void object;
        this.provider = textProvider.toString();
        this.stdMonths = Collections.unmodifiableMap(CalendarText.getMonths(string, locale, textProvider, false));
        Map<TextWidth, Map<OutputContext, TextAccessor>> map = CalendarText.getMonths(string, locale, textProvider, true);
        this.leapMonths = map == null ? this.stdMonths : Collections.unmodifiableMap(map);
        EnumMap enumMap = new EnumMap(TextWidth.class);
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> enumMap2 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap2.put(outputContext, new TextAccessor(textProvider.quarters(string, locale, textWidth, outputContext), locale));
            }
            enumMap.put(textWidth, enumMap2);
        }
        this.quarters = Collections.unmodifiableMap(enumMap);
        EnumMap enumMap2 = new EnumMap(TextWidth.class);
        Object enumMap3 = TextWidth.values();
        int n = ((TextWidth[])enumMap3).length;
        boolean bl = false;
        while (object < n) {
            TextWidth textWidth = enumMap3[object];
            EnumMap<OutputContext, TextAccessor> enumMap4 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap4.put(outputContext, new TextAccessor(textProvider.weekdays(string, locale, textWidth, outputContext), locale));
            }
            enumMap2.put(textWidth, enumMap4);
            ++object;
        }
        this.weekdays = Collections.unmodifiableMap(enumMap2);
        enumMap3 = new EnumMap(TextWidth.class);
        Object enumMap4 = TextWidth.values();
        int n2 = ((TextWidth[])enumMap4).length;
        boolean bl2 = false;
        while (var10_23 < n2) {
            TextWidth textWidth = enumMap4[var10_23];
            enumMap3.put(textWidth, new TextAccessor(textProvider.eras(string, locale, textWidth), locale));
            ++var10_23;
        }
        this.eras = Collections.unmodifiableMap(enumMap3);
        enumMap4 = new EnumMap(TextWidth.class);
        TextWidth[] textWidthArray = TextWidth.values();
        int n3 = textWidthArray.length;
        boolean bl3 = false;
        while (var11_34 < n3) {
            TextWidth textWidth = textWidthArray[var11_34];
            enumMap4.put(textWidth, new TextAccessor(textProvider.meridiems(string, locale, textWidth), locale));
            ++var11_34;
        }
        this.meridiems = Collections.unmodifiableMap(enumMap4);
        Object var9_16 = null;
        Object var10_25 = null;
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("calendar/" + string, locale, textProvider.getControl());
        }
        catch (MissingResourceException missingResourceException) {
            MissingResourceException missingResourceException2 = missingResourceException;
        }
        this.textForms = var9_18;
        this.mre = var10_27;
    }

    public static CalendarText getInstance(Chronology<?> chronology, Locale locale) {
        return CalendarText.getInstance(CalendarText.extractCalendarType(chronology), locale);
    }

    public static CalendarText getInstance(String string, Locale locale) {
        String string2;
        Object object;
        if (string == null) {
            throw new NullPointerException("Missing calendar type.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(locale.getLanguage());
        String string3 = locale.getCountry();
        if (!string3.isEmpty()) {
            stringBuilder.append('-');
            stringBuilder.append(string3);
        }
        if ((object = (CalendarText)CACHE.get(string2 = stringBuilder.toString())) == null) {
            Object object2;
            Object object3 = null;
            if (locale.getLanguage().isEmpty() && string.equals(ISO_CALENDAR_TYPE)) {
                object3 = ROOT_PROVIDER;
            } else {
                for (TextProvider textProvider : ResourceLoader.getInstance().services(TextProvider.class)) {
                    if (!CalendarText.isCalendarTypeSupported(textProvider, string) || !CalendarText.isLocaleSupported(textProvider, locale)) continue;
                    object3 = textProvider;
                    break;
                }
                if (object3 == null) {
                    object2 = JDK_PROVIDER;
                    if (CalendarText.isCalendarTypeSupported((TextProvider)object2, string) && CalendarText.isLocaleSupported((TextProvider)object2, locale)) {
                        object3 = object2;
                    }
                    if (object3 == null) {
                        object3 = ROOT_PROVIDER;
                    }
                }
            }
            object = new CalendarText(string, locale, (TextProvider)object3);
            object2 = CACHE.putIfAbsent(string2, (CalendarText)object);
            if (object2 != null) {
                object = object2;
            }
        }
        return object;
    }

    public TextAccessor getStdMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, false);
    }

    public TextAccessor getLeapMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, true);
    }

    public TextAccessor getQuarters(TextWidth textWidth, OutputContext outputContext) {
        return this.quarters.get((Object)textWidth).get((Object)outputContext);
    }

    public TextAccessor getWeekdays(TextWidth textWidth, OutputContext outputContext) {
        return this.weekdays.get((Object)textWidth).get((Object)outputContext);
    }

    public TextAccessor getEras(TextWidth textWidth) {
        return this.eras.get((Object)textWidth);
    }

    public TextAccessor getMeridiems(TextWidth textWidth) {
        return this.meridiems.get((Object)textWidth);
    }

    public <V extends Enum<V>> TextAccessor getTextForms(ChronoElement<V> chronoElement, String ... stringArray) {
        if (this.textForms == null) {
            throw new MissingResourceException(this.mre.getMessage(), this.mre.getClassName(), this.mre.getKey());
        }
        Enum[] enumArray = (Enum[])chronoElement.getType().getEnumConstants();
        int n = enumArray.length;
        String[] stringArray2 = new String[n];
        String string = CalendarText.getKeyPrefix(this.textForms, chronoElement.name());
        int n2 = CalendarEra.class.isAssignableFrom(chronoElement.getType()) ? 0 : 1;
        for (int i = 0; i < n; ++i) {
            int n3 = 0;
            String string2 = CalendarText.getKeyStart(string, 0, stringArray);
            String string3 = null;
            while (string2 != null) {
                String string4 = CalendarText.toKey(string2, i, n2);
                if (this.textForms.containsKey(string4)) {
                    string3 = string4;
                    break;
                }
                string2 = CalendarText.getKeyStart(string, ++n3, stringArray);
            }
            stringArray2[i] = string3 == null ? enumArray[i].name() : this.textForms.getString(string3);
        }
        return new TextAccessor(stringArray2, this.textForms.getLocale());
    }

    public static String getGMTPrefix(Locale locale) {
        CalendarText calendarText = CalendarText.getInstance(ISO_CALENDAR_TYPE, locale);
        if (calendarText.textForms == null) {
            return "GMT";
        }
        return calendarText.textForms.getString("prefixGMTOffset");
    }

    public static FormatPatternProvider getFormatPatterns() {
        return FORMAT_PATTERN_PROVIDER;
    }

    public static String getTimestampPattern(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        String string = FORMAT_PATTERN_PROVIDER.getDateTimePattern(displayMode, displayMode2, locale);
        return CalendarText.removeZones(string);
    }

    public String toString() {
        return this.provider;
    }

    public static void clearCache() {
        CACHE.clear();
    }

    static String extractCalendarType(Chronology<?> chronology) {
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? ISO_CALENDAR_TYPE : calendarType.value();
    }

    private TextAccessor getMonths(TextWidth textWidth, OutputContext outputContext, boolean bl) {
        if (bl) {
            return this.leapMonths.get((Object)textWidth).get((Object)outputContext);
        }
        return this.stdMonths.get((Object)textWidth).get((Object)outputContext);
    }

    private static Map<TextWidth, Map<OutputContext, TextAccessor>> getMonths(String string, Locale locale, TextProvider textProvider, boolean bl) {
        EnumMap<TextWidth, Map<OutputContext, TextAccessor>> enumMap = new EnumMap<TextWidth, Map<OutputContext, TextAccessor>>(TextWidth.class);
        boolean bl2 = false;
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, TextAccessor> enumMap2 = new EnumMap<OutputContext, TextAccessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                Object[] objectArray = textProvider.months(string, locale, textWidth, outputContext, bl);
                if (bl && !bl2) {
                    Object[] objectArray2 = textProvider.months(string, locale, textWidth, outputContext, false);
                    bl2 = !Arrays.equals(objectArray2, objectArray);
                }
                enumMap2.put(outputContext, new TextAccessor((String[])objectArray, locale));
            }
            enumMap.put(textWidth, enumMap2);
        }
        return !bl || bl2 ? enumMap : null;
    }

    private static boolean isCalendarTypeSupported(TextProvider textProvider, String string) {
        for (String string2 : textProvider.getSupportedCalendarTypes()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLocaleSupported(TextProvider textProvider, Locale locale) {
        String string = locale.getLanguage();
        for (Locale locale2 : textProvider.getAvailableLocales()) {
            if (!string.equals(locale2.getLanguage())) continue;
            return true;
        }
        return false;
    }

    private static String getKeyPrefix(ResourceBundle resourceBundle, String string) {
        if (resourceBundle.containsKey("useShortKeys") && "true".equals(resourceBundle.getString("useShortKeys")) && (string.equals("MONTH_OF_YEAR") || string.equals("DAY_OF_WEEK") || string.equals("QUARTER_OF_YEAR") || string.equals("ERA"))) {
            return string.substring(0, 1);
        }
        return string;
    }

    private static String getKeyStart(String string, int n, String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (stringArray.length < n) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder(string);
            boolean bl = true;
            for (int i = 0; i < stringArray.length - n; ++i) {
                if (bl) {
                    stringBuilder.append('(');
                    bl = false;
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(stringArray[i]);
            }
            if (!bl) {
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }
        return n > 0 ? null : string;
    }

    private static String toKey(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('_');
        stringBuilder.append(n + n2);
        return stringBuilder.toString();
    }

    private static String removeZones(String string) {
        int n;
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c == '\'') {
                if (n + 1 < n2 && string.charAt(n + 1) == '\'') {
                    stringBuilder.append(c);
                    ++n;
                } else {
                    bl = !bl;
                }
                stringBuilder.append(c);
                continue;
            }
            if (bl) {
                stringBuilder.append(c);
                continue;
            }
            if (c == 'z' || c == 'Z' || c == 'v' || c == 'V' || c == 'x' || c == 'X') continue;
            stringBuilder.append(c);
        }
        for (n = 0; n < stringBuilder.length(); ++n) {
            n2 = stringBuilder.charAt(n);
            if (n2 == 32 && n + 1 < stringBuilder.length() && stringBuilder.charAt(n + 1) == ' ') {
                stringBuilder.deleteCharAt(n);
                --n;
                continue;
            }
            if (n2 != 91 && n2 != 93 && n2 != 40 && n2 != 41) continue;
            stringBuilder.deleteCharAt(n);
            --n;
        }
        String string2 = stringBuilder.toString().trim();
        if (string2.endsWith(" '")) {
            string2 = string2.substring(0, string2.length() - 2) + "'";
        } else if (string2.endsWith(",")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    static {
        Object object = new HashSet<String>();
        object.add("ar");
        object.add("dv");
        object.add("fa");
        object.add("ha");
        object.add("he");
        object.add("iw");
        object.add("ji");
        object.add("ps");
        object.add("ur");
        object.add("yi");
        RTL = Collections.unmodifiableSet(object);
        object = new FormatPatterns(null);
        for (FormatPatternProvider formatPatternProvider : ResourceLoader.getInstance().services(FormatPatternProvider.class)) {
            object = new FormatPatterns(formatPatternProvider);
            if (formatPatternProvider.getClass().getName().startsWith("net.time4j.")) continue;
            break;
        }
        FORMAT_PATTERN_PROVIDER = object;
        JDK_PROVIDER = new JDKTextProvider();
        ROOT_PROVIDER = new FallbackProvider();
        CACHE = new ConcurrentHashMap<String, CalendarText>();
    }

    private static class FormatPatterns
    implements FormatPatternProvider {
        private final FormatPatternProvider delegate;

        FormatPatterns(FormatPatternProvider formatPatternProvider) {
            this.delegate = formatPatternProvider;
        }

        @Override
        public String getDatePattern(DisplayMode displayMode, Locale locale) {
            if (this.delegate == null) {
                int n = FormatPatterns.getFormatStyle(displayMode);
                DateFormat dateFormat = DateFormat.getDateInstance(n, locale);
                return FormatPatterns.getFormatPattern(dateFormat);
            }
            return this.delegate.getDatePattern(displayMode, locale);
        }

        @Override
        public String getTimePattern(DisplayMode displayMode, Locale locale) {
            String string;
            if (this.delegate == null) {
                int n = FormatPatterns.getFormatStyle(displayMode);
                DateFormat dateFormat = DateFormat.getTimeInstance(n, locale);
                string = FormatPatterns.getFormatPattern(dateFormat);
            } else {
                string = this.delegate.getTimePattern(displayMode, locale);
            }
            return CalendarText.removeZones(string);
        }

        @Override
        public String getDateTimePattern(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
            if (this.delegate == null) {
                int n = FormatPatterns.getFormatStyle(displayMode);
                int n2 = FormatPatterns.getFormatStyle(displayMode2);
                DateFormat dateFormat = DateFormat.getDateTimeInstance(n, n2, locale);
                return FormatPatterns.getFormatPattern(dateFormat);
            }
            return this.delegate.getDateTimePattern(displayMode, displayMode2, locale);
        }

        @Override
        public String getIntervalPattern(Locale locale) {
            if (this.delegate == null) {
                if (locale.getLanguage().isEmpty() && locale.getCountry().isEmpty()) {
                    return "{0}/{1}";
                }
                if (FormatPatterns.isTextRTL(locale)) {
                    return "{0} - {1}";
                }
                return "{0} - {1}";
            }
            return this.delegate.getIntervalPattern(locale);
        }

        private static int getFormatStyle(DisplayMode displayMode) {
            switch (displayMode) {
                case FULL: {
                    return 0;
                }
                case LONG: {
                    return 1;
                }
                case MEDIUM: {
                    return 2;
                }
                case SHORT: {
                    return 3;
                }
            }
            throw new UnsupportedOperationException("Unknown: " + displayMode);
        }

        private static String getFormatPattern(DateFormat dateFormat) {
            if (dateFormat instanceof SimpleDateFormat) {
                return ((SimpleDateFormat)SimpleDateFormat.class.cast(dateFormat)).toPattern();
            }
            throw new IllegalStateException("Cannot retrieve format pattern: " + dateFormat);
        }

        private static boolean isTextRTL(Locale locale) {
            return RTL.contains(locale.getLanguage());
        }
    }

    private static class FallbackProvider
    implements TextProvider {
        private FallbackProvider() {
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public Locale[] getAvailableLocales() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            if (textWidth == TextWidth.WIDE) {
                return new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13"};
            }
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"};
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"1", "2", "3", "4"};
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7"};
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"B", "A"};
            }
            return new String[]{"BC", "AD"};
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return new String[]{"AM", "PM"};
        }

        @Override
        public ResourceBundle.Control getControl() {
            return ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
        }

        public String toString() {
            return "FallbackProvider";
        }
    }

    private static class JDKTextProvider
    implements TextProvider {
        private JDKTextProvider() {
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            return new String[]{CalendarText.ISO_CALENDAR_TYPE};
        }

        @Override
        public Locale[] getAvailableLocales() {
            return DateFormatSymbols.getAvailableLocales();
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[12];
            int n = 0;
            for (Month month : Month.values()) {
                stringArray[n] = month.getDisplayName(textStyle, locale);
                ++n;
            }
            return stringArray;
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[4];
            for (int i = 0; i < 4; ++i) {
                LocalDate localDate = LocalDate.of(1970, i * 3 + 1, 1);
                stringArray[i] = new DateTimeFormatterBuilder().appendText(IsoFields.QUARTER_OF_YEAR, textStyle).toFormatter(locale).format(localDate);
            }
            return stringArray;
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, outputContext);
            String[] stringArray = new String[7];
            int n = 0;
            for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
                stringArray[n] = dayOfWeek.getDisplayName(textStyle, locale);
                ++n;
            }
            return stringArray;
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, OutputContext.FORMAT);
            String[] stringArray = new String[2];
            int n = 0;
            for (IsoEra isoEra : IsoEra.values()) {
                stringArray[n] = isoEra.getDisplayName(textStyle, locale);
                ++n;
            }
            return stringArray;
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
            TextStyle textStyle = JDKTextProvider.getStyle(textWidth, OutputContext.FORMAT);
            String[] stringArray = new String[2];
            for (int i = 0; i < 2; ++i) {
                LocalTime localTime = LocalTime.of(i * 12, 0);
                stringArray[i] = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.AMPM_OF_DAY, textStyle).toFormatter(locale).format(localTime);
            }
            return stringArray;
        }

        @Override
        public ResourceBundle.Control getControl() {
            return ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_DEFAULT);
        }

        public String toString() {
            return "JDKTextProvider";
        }

        private static TextStyle getStyle(TextWidth textWidth, OutputContext outputContext) {
            boolean bl = outputContext == OutputContext.STANDALONE;
            switch (textWidth) {
                case WIDE: {
                    return bl ? TextStyle.FULL_STANDALONE : TextStyle.FULL;
                }
                case ABBREVIATED: 
                case SHORT: {
                    return bl ? TextStyle.SHORT_STANDALONE : TextStyle.SHORT;
                }
                case NARROW: {
                    return bl ? TextStyle.NARROW_STANDALONE : TextStyle.NARROW;
                }
            }
            throw new UnsupportedOperationException(textWidth.name());
        }
    }
}

