/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.VariantSource;

public abstract class Calendrical<U, D extends Calendrical<U, D>>
extends TimePoint<U, D>
implements CalendarDate {
    public <T extends Calendrical<?, T>> T transform(Class<T> clazz) {
        String string = clazz.getName();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + string);
        }
        return (T)((Calendrical)this.transform(chronology.getCalendarSystem(), string));
    }

    public <T extends CalendarVariant<T>> T transform(Class<T> clazz, String string) {
        String string2 = clazz.getName();
        Chronology<T> chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Cannot find any chronology for given target type: " + string2);
        }
        return (T)((CalendarVariant)this.transform(chronology.getCalendarSystem(string), string2));
    }

    public <T extends CalendarVariant<T>> T transform(Class<T> clazz, VariantSource variantSource) {
        return this.transform(clazz, variantSource.getVariant());
    }

    @Override
    public boolean isBefore(CalendarDate calendarDate) {
        return this.compareByTime(calendarDate) < 0;
    }

    @Override
    public boolean isAfter(CalendarDate calendarDate) {
        return this.compareByTime(calendarDate) > 0;
    }

    @Override
    public boolean isSimultaneous(CalendarDate calendarDate) {
        return this == calendarDate || this.compareByTime(calendarDate) == 0;
    }

    @Override
    public int compareTo(D d) {
        Class clazz;
        Class clazz2 = this.getChronology().getChronoType();
        if (clazz2 != (clazz = ((TimePoint)d).getChronology().getChronoType())) {
            throw new ClassCastException("Cannot compare different types of dates, use instance of EpochDays as comparator instead.");
        }
        return this.compareByTime((CalendarDate)d);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Calendrical) {
            Class clazz;
            Calendrical calendrical = (Calendrical)object;
            Class clazz2 = this.getChronology().getChronoType();
            return clazz2 == (clazz = calendrical.getChronology().getChronoType()) && this.getDaysSinceEpochUTC() == calendrical.getDaysSinceEpochUTC();
        }
        return false;
    }

    @Override
    public int hashCode() {
        long l = this.getDaysSinceEpochUTC();
        return (int)(l ^ l >>> 32);
    }

    public D plus(CalendarDays calendarDays) {
        long l = Math.addExact(this.getDaysSinceEpochUTC(), calendarDays.getAmount());
        return (D)((Calendrical)this.getCalendarSystem().transform(l));
    }

    public D minus(CalendarDays calendarDays) {
        long l = Math.subtractExact(this.getDaysSinceEpochUTC(), calendarDays.getAmount());
        return (D)((Calendrical)this.getCalendarSystem().transform(l));
    }

    @Override
    public long getDaysSinceEpochUTC() {
        return this.getCalendarSystem().transform(this.getContext());
    }

    protected int compareByTime(CalendarDate calendarDate) {
        long l;
        long l2 = this.getDaysSinceEpochUTC();
        return l2 < (l = calendarDate.getDaysSinceEpochUTC()) ? -1 : (l2 == l ? 0 : 1);
    }

    private CalendarSystem<D> getCalendarSystem() {
        return ((TimeAxis)this.getChronology()).getCalendarSystem();
    }

    private <T> T transform(CalendarSystem<T> calendarSystem, String string) {
        long l = this.getDaysSinceEpochUTC();
        if (calendarSystem.getMinimumSinceUTC() > l || calendarSystem.getMaximumSinceUTC() < l) {
            throw new ArithmeticException("Cannot transform <" + l + "> to: " + string);
        }
        return calendarSystem.transform(l);
    }
}

