/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.base.UnixTime;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;

public abstract class BasicElement<V extends Comparable<V>>
implements ChronoElement<V>,
Serializable {
    private final String name;

    protected BasicElement(String string) {
        if (string.trim().isEmpty()) {
            throw new IllegalArgumentException("Element name is empty or contains only white space.");
        }
        this.name = string;
    }

    @Override
    public final String name() {
        return this.name;
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return ((Comparable)chronoDisplay.get(this)).compareTo(chronoDisplay2.get(this));
    }

    @Override
    public char getSymbol() {
        return '\u0000';
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            return this.name.equals(((BasicElement)object).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String string = this.getClass().getName();
        StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
        stringBuilder.append(string);
        stringBuilder.append('@');
        stringBuilder.append(this.name);
        return stringBuilder.toString();
    }

    protected <T extends ChronoEntity<T>> ElementRule<T, V> derive(Chronology<T> chronology) {
        return null;
    }

    protected ChronoElement<?> getParent() {
        return null;
    }

    protected String getVeto(Chronology<?> chronology) {
        if (this.isLocal() && UnixTime.class.isAssignableFrom(chronology.getChronoType())) {
            return "Accessing the local element [" + this.name + "] from a global type requires a timezone.\n" + "- Try to apply a zonal query like \"" + this.name + ".atUTC()\".\n" + "- Or try to first convert the global type to " + "a zonal timestamp: " + "\"moment.toZonalTimestamp(...)\".\n" + "- If used in formatting then consider " + "\"ChronoFormatter.withTimezone(TZID)\".";
        }
        return null;
    }
}

