/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.CalendarUnit;
import net.time4j.ElementOperator;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.ChronoOperator;

final class FullValueOperator
extends ElementOperator<PlainTime> {
    static final FullValueOperator ROUNDING_FULL_HOUR = new FullValueOperator(13);
    static final FullValueOperator ROUNDING_FULL_MINUTE = new FullValueOperator(14);
    static final FullValueOperator NEXT_FULL_HOUR = new FullValueOperator(15);
    static final FullValueOperator NEXT_FULL_MINUTE = new FullValueOperator(16);
    private final ChronoOperator<PlainTimestamp> tsop = plainTimestamp -> {
        PlainTime plainTime = this.doApply(plainTimestamp.getWallTime());
        if (plainTime.getHour() == 24) {
            return PlainTimestamp.of(plainTimestamp.getCalendarDate().plus(1L, CalendarUnit.DAYS), PlainTime.midnightAtStartOfDay());
        }
        return plainTimestamp.with(plainTime);
    };

    private FullValueOperator(int n) {
        super(PlainTime.COMPONENT, n);
    }

    @Override
    public PlainTime apply(PlainTime plainTime) {
        return this.doApply(plainTime);
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return this.tsop;
    }

    private PlainTime doApply(PlainTime plainTime) {
        int n = plainTime.getHour();
        int n2 = plainTime.getMinute();
        switch (this.getType()) {
            case 13: {
                if (n2 >= 30 && ++n == 25) {
                    n = 1;
                }
                return PlainTime.of(n);
            }
            case 14: {
                if (plainTime.getSecond() >= 30) {
                    if (n == 24) {
                        n = 0;
                        n2 = 1;
                    } else if (++n2 == 60) {
                        ++n;
                        n2 = 0;
                    }
                }
                return PlainTime.of(n, n2);
            }
            case 15: {
                if (++n == 25) {
                    n = 1;
                }
                return PlainTime.of(n);
            }
            case 16: {
                if (n == 24) {
                    n = 0;
                    n2 = 1;
                } else if (++n2 == 60) {
                    ++n;
                    n2 = 0;
                }
                return PlainTime.of(n, n2);
            }
        }
        throw new AssertionError((Object)("Unknown: " + this.getType()));
    }
}

