/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Period;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.IsoDateUnit;
import net.time4j.IsoUnit;
import net.time4j.JSR310DurationAdapter;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SPX;
import net.time4j.StdNormalizer;
import net.time4j.TemporalType;
import net.time4j.Weekcycle;
import net.time4j.base.MathUtils;
import net.time4j.engine.AbstractDuration;
import net.time4j.engine.AbstractMetric;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Normalizer;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.format.TimeSpanFormatter;
import net.time4j.tz.Timezone;

public final class Duration<U extends IsoUnit>
extends AbstractDuration<U>
implements Serializable {
    private static final char ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
    private static final long MRD = 1000000000L;
    private static final long MIO = 1000000L;
    private static final Duration ZERO = new Duration();
    private static final Formatter<CalendarUnit> CF_EXT_CAL = Duration.createAlternativeDateFormat(true, false);
    private static final Formatter<CalendarUnit> CF_EXT_ORD = Duration.createAlternativeDateFormat(true, true);
    private static final Formatter<CalendarUnit> CF_BAS_CAL = Duration.createAlternativeDateFormat(false, false);
    private static final Formatter<CalendarUnit> CF_BAS_ORD = Duration.createAlternativeDateFormat(false, true);
    private static final Formatter<ClockUnit> TF_EXT = Duration.createAlternativeTimeFormat(true);
    private static final Formatter<ClockUnit> TF_BAS = Duration.createAlternativeTimeFormat(false);
    private static final Comparator<TimeSpan.Item<? extends ChronoUnit>> ITEM_COMPARATOR = StdNormalizer.comparator();
    public static Normalizer<IsoUnit> STD_PERIOD = StdNormalizer.ofMixedUnits();
    public static Normalizer<CalendarUnit> STD_CALENDAR_PERIOD = StdNormalizer.ofCalendarUnits();
    public static Normalizer<ClockUnit> STD_CLOCK_PERIOD = StdNormalizer.ofClockUnits();
    private static final int PRINT_STYLE_NORMAL = 0;
    private static final int PRINT_STYLE_ISO = 1;
    private static final int PRINT_STYLE_XML = 2;
    private static final long serialVersionUID = -6321211763598951499L;
    private static final TimeMetric<CalendarUnit, Duration<CalendarUnit>> YMD_METRIC = Duration.in((IsoUnit[])new CalendarUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS});
    private static final TimeMetric<ClockUnit, Duration<ClockUnit>> CLOCK_METRIC = Duration.in((IsoUnit[])new ClockUnit[]{ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS});
    private static final TimeMetric<IsoDateUnit, Duration<IsoDateUnit>> WEEK_BASED_METRIC = Duration.in((IsoUnit[])new IsoDateUnit[]{CalendarUnit.weekBasedYears(), CalendarUnit.WEEKS, CalendarUnit.DAYS});
    private static final int SUPER_TYPE = -1;
    private static final int CALENDAR_TYPE = 0;
    private static final int CLOCK_TYPE = 1;
    private static final int WEEK_BASED_TYPE = 2;
    private final transient List<TimeSpan.Item<U>> items;
    private final transient boolean negative;

    Duration(List<TimeSpan.Item<U>> list, boolean bl) {
        boolean bl2 = list.isEmpty();
        if (bl2) {
            this.items = Collections.emptyList();
        } else {
            Collections.sort(list, ITEM_COMPARATOR);
            this.items = Collections.unmodifiableList(list);
        }
        this.negative = !bl2 && bl;
    }

    private Duration(Duration<U> duration, boolean bl) {
        this.items = duration.items;
        this.negative = bl != duration.negative;
    }

    private Duration() {
        this.items = Collections.emptyList();
        this.negative = false;
    }

    public static <U extends IsoUnit> Duration<U> ofZero() {
        return ZERO;
    }

    public static <U extends IsoUnit> Duration<U> of(long l, U u) {
        if (l == 0L) {
            return Duration.ofZero();
        }
        Object object = u;
        long l2 = l;
        if (l < 0L) {
            l2 = MathUtils.safeNegate(l);
        }
        if (u instanceof ClockUnit) {
            switch (u.getSymbol()) {
                case '3': {
                    object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
                    l2 = MathUtils.safeMultiply(l2, 1000000L);
                    break;
                }
                case '6': {
                    object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
                    l2 = MathUtils.safeMultiply(l2, 1000L);
                    break;
                }
            }
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(1);
        arrayList.add(TimeSpan.Item.of(l2, object));
        return new Duration<U>(arrayList, l < 0L);
    }

    public static Builder ofPositive() {
        return new Builder(false);
    }

    public static Builder ofNegative() {
        return new Builder(true);
    }

    public static Duration<CalendarUnit> ofCalendarUnits(int n, int n2, int n3) {
        ArrayList arrayList = new ArrayList(3);
        if (n != 0) {
            arrayList.add(TimeSpan.Item.of(n, CalendarUnit.YEARS));
        }
        if (n2 != 0) {
            arrayList.add(TimeSpan.Item.of(n2, CalendarUnit.MONTHS));
        }
        if (n3 != 0) {
            arrayList.add(TimeSpan.Item.of(n3, CalendarUnit.DAYS));
        }
        return new Duration<CalendarUnit>(arrayList, false);
    }

    public static Duration<ClockUnit> ofClockUnits(int n, int n2, int n3) {
        ArrayList arrayList = new ArrayList(3);
        if (n != 0) {
            arrayList.add(TimeSpan.Item.of(n, ClockUnit.HOURS));
        }
        if (n2 != 0) {
            arrayList.add(TimeSpan.Item.of(n2, ClockUnit.MINUTES));
        }
        if (n3 != 0) {
            arrayList.add(TimeSpan.Item.of(n3, ClockUnit.SECONDS));
        }
        return new Duration<ClockUnit>(arrayList, false);
    }

    public static Duration<IsoUnit> from(TemporalAmount temporalAmount) {
        Duration<IsoUnit> duration = Duration.ofZero();
        for (TemporalUnit temporalUnit : temporalAmount.getUnits()) {
            IsoUnit isoUnit;
            long l;
            block22: {
                block21: {
                    l = temporalAmount.get(temporalUnit);
                    if (l == 0L) continue;
                    if (!(temporalUnit instanceof java.time.temporal.ChronoUnit)) break block21;
                    switch ((java.time.temporal.ChronoUnit)java.time.temporal.ChronoUnit.class.cast(temporalUnit)) {
                        case NANOS: {
                            isoUnit = ClockUnit.NANOS;
                            break block22;
                        }
                        case MICROS: {
                            isoUnit = ClockUnit.MICROS;
                            break block22;
                        }
                        case MILLIS: {
                            isoUnit = ClockUnit.MILLIS;
                            break block22;
                        }
                        case SECONDS: {
                            isoUnit = ClockUnit.SECONDS;
                            break block22;
                        }
                        case MINUTES: {
                            isoUnit = ClockUnit.MINUTES;
                            break block22;
                        }
                        case HOURS: {
                            isoUnit = ClockUnit.HOURS;
                            break block22;
                        }
                        case HALF_DAYS: {
                            isoUnit = ClockUnit.HOURS;
                            l = Math.multiplyExact(l, 12L);
                            break block22;
                        }
                        case DAYS: {
                            isoUnit = CalendarUnit.DAYS;
                            break block22;
                        }
                        case WEEKS: {
                            isoUnit = CalendarUnit.WEEKS;
                            break block22;
                        }
                        case MONTHS: {
                            isoUnit = CalendarUnit.MONTHS;
                            break block22;
                        }
                        case YEARS: {
                            isoUnit = CalendarUnit.YEARS;
                            break block22;
                        }
                        case DECADES: {
                            isoUnit = CalendarUnit.DECADES;
                            break block22;
                        }
                        case CENTURIES: {
                            isoUnit = CalendarUnit.CENTURIES;
                            break block22;
                        }
                        case MILLENNIA: {
                            isoUnit = CalendarUnit.MILLENNIA;
                            break block22;
                        }
                        default: {
                            throw new IllegalArgumentException("Not supported: " + temporalUnit);
                        }
                    }
                }
                if (temporalUnit.equals(IsoFields.QUARTER_YEARS)) {
                    isoUnit = CalendarUnit.QUARTERS;
                } else if (temporalUnit.equals(IsoFields.WEEK_BASED_YEARS)) {
                    isoUnit = CalendarUnit.weekBasedYears();
                } else {
                    throw new IllegalArgumentException("Not supported: " + temporalUnit);
                }
            }
            duration = duration.plus(l, isoUnit);
        }
        return duration.with(STD_PERIOD);
    }

    public static Duration<ClockUnit> from(java.time.Duration duration) {
        return TemporalType.THREETEN_DURATION.translate(duration);
    }

    public static Duration<CalendarUnit> from(Period period) {
        return TemporalType.THREETEN_PERIOD.translate(period);
    }

    @SafeVarargs
    public static <U extends IsoUnit> TimeMetric<U, Duration<U>> in(U ... UArray) {
        return new Metric((IsoUnit[])UArray);
    }

    public static TimeMetric<CalendarUnit, Duration<CalendarUnit>> inYearsMonthsDays() {
        return YMD_METRIC;
    }

    public static TimeMetric<ClockUnit, Duration<ClockUnit>> inClockUnits() {
        return CLOCK_METRIC;
    }

    public static TimeMetric<IsoDateUnit, Duration<IsoDateUnit>> inWeekBasedUnits() {
        return WEEK_BASED_METRIC;
    }

    public static TimeMetric<IsoUnit, Duration<IsoUnit>> in(Timezone timezone, IsoUnit ... isoUnitArray) {
        return new ZonalMetric(timezone, isoUnitArray);
    }

    @Override
    public List<TimeSpan.Item<U>> getTotalLength() {
        return this.items;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public boolean contains(IsoUnit isoUnit) {
        if (isoUnit == null) {
            return false;
        }
        boolean bl = this.isFractionUnit(isoUnit);
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            TimeSpan.Item<U> item = this.items.get(i);
            IsoUnit isoUnit2 = (IsoUnit)item.getUnit();
            if (!isoUnit2.equals(isoUnit) && (!bl || !this.isFractionUnit(isoUnit2))) continue;
            return item.getAmount() > 0L;
        }
        return false;
    }

    @Override
    public long getPartialAmount(IsoUnit isoUnit) {
        if (isoUnit == null) {
            return 0L;
        }
        boolean bl = this.isFractionUnit(isoUnit);
        int n = this.items.size();
        for (int i = 0; i < n; ++i) {
            TimeSpan.Item<U> item = this.items.get(i);
            IsoUnit isoUnit2 = (IsoUnit)item.getUnit();
            if (isoUnit2.equals(isoUnit)) {
                return item.getAmount();
            }
            if (!bl || !this.isFractionUnit(isoUnit2)) continue;
            int n2 = isoUnit2.getSymbol() - 48;
            int n3 = isoUnit.getSymbol() - 48;
            int n4 = 1;
            int n5 = Math.abs(n2 - n3);
            for (int j = 0; j < n5; ++j) {
                n4 *= 10;
            }
            if (n2 >= n3) {
                return item.getAmount() / (long)n4;
            }
            return item.getAmount() * (long)n4;
        }
        return 0L;
    }

    public static <U extends IsoUnit, T extends TimePoint<? super U, T>> Comparator<Duration<U>> comparator(T t) {
        return new LengthComparator(t, null);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Duration<U> plus(long l, U object) {
        void var3_4;
        if (object == null) {
            throw new NullPointerException("Missing chronological unit.");
        }
        long l2 = l;
        Object object2 = object;
        boolean bl = false;
        if (l == 0L) {
            return this;
        }
        if (l < 0L) {
            l = MathUtils.safeNegate(l);
            bl = true;
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(this.getTotalLength());
        TimeSpan.Item<U> item = Duration.replaceFraction(l, object);
        if (item != null) {
            l = item.getAmount();
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
        }
        if (this.isEmpty()) {
            arrayList.add(item == null ? TimeSpan.Item.of(l, var3_4) : item);
            return new Duration<U>(arrayList, bl);
        }
        int n = this.getIndex((ChronoUnit)var3_4);
        boolean bl2 = this.isNegative();
        if (n < 0) {
            if (this.isNegative() != bl) return this.plus(Duration.of(l2, object2));
            arrayList.add(TimeSpan.Item.of(l, var3_4));
            return new Duration<U>(arrayList, bl2);
        } else {
            long l3 = MathUtils.safeAdd(MathUtils.safeMultiply(((TimeSpan.Item)arrayList.get(n)).getAmount(), (long)(this.isNegative() ? -1 : 1)), MathUtils.safeMultiply(l, (long)(bl ? -1 : 1)));
            if (l3 == 0L) {
                arrayList.remove(n);
                return new Duration<U>(arrayList, bl2);
            } else {
                if (this.count() != 1 && this.isNegative() != l3 < 0L) return this.plus(Duration.of(l2, object2));
                long l4 = l3 < 0L ? MathUtils.safeNegate(l3) : l3;
                arrayList.set(n, TimeSpan.Item.of(l4, var3_4));
                bl2 = l3 < 0L;
            }
        }
        return new Duration<U>(arrayList, bl2);
    }

    public Duration<U> plus(TimeSpan<? extends U> timeSpan) {
        Duration<? extends U> duration = Duration.merge(this, timeSpan);
        if (duration == null) {
            long[] lArray = new long[]{0L, 0L, 0L, 0L};
            if (Duration.summarize(this, lArray) && Duration.summarize(timeSpan, lArray)) {
                long l = lArray[0];
                long l2 = lArray[1];
                long l3 = lArray[2];
                long l4 = lArray[3];
                long l5 = l4 != 0L ? l4 : (l3 != 0L ? l3 : l2);
                if (!Duration.hasMixedSigns(l, l5)) {
                    boolean bl;
                    boolean bl2 = bl = l < 0L || l5 < 0L;
                    if (bl) {
                        l = MathUtils.safeNegate(l);
                        l2 = MathUtils.safeNegate(l2);
                        l3 = MathUtils.safeNegate(l3);
                        l4 = MathUtils.safeNegate(l4);
                    }
                    long l6 = l / 12L;
                    l %= 12L;
                    long l7 = 0L;
                    if (l4 != 0L) {
                        l7 = l4 % 1000000000L;
                        l3 = l4 / 1000000000L;
                    }
                    long l8 = l3 / 3600L;
                    long l9 = (l3 %= 3600L) / 60L;
                    l3 %= 60L;
                    HashMap<Enum, Long> hashMap = new HashMap<Enum, Long>();
                    hashMap.put(CalendarUnit.YEARS, l6);
                    hashMap.put(CalendarUnit.MONTHS, l);
                    hashMap.put(CalendarUnit.DAYS, l2);
                    hashMap.put(ClockUnit.HOURS, l8);
                    hashMap.put(ClockUnit.MINUTES, l9);
                    hashMap.put(ClockUnit.SECONDS, l3);
                    hashMap.put(ClockUnit.NANOS, l7);
                    return Duration.create(hashMap, bl);
                }
            }
            throw new IllegalStateException("Mixed signs in result time span not allowed: " + this + " PLUS " + timeSpan);
        }
        return duration;
    }

    public Duration<U> with(long l, U object) {
        long l2 = l < 0L ? MathUtils.safeNegate(l) : l;
        TimeSpan.Item<U> item = Duration.replaceFraction(l2, object);
        if (item != null) {
            l2 = item.getAmount();
            object = (IsoUnit)item.getUnit();
        }
        long l3 = this.getPartialAmount((IsoUnit)object);
        return this.plus(MathUtils.safeSubtract(MathUtils.safeMultiply(l2, l < 0L ? -1L : 1L), MathUtils.safeMultiply(l3, this.isNegative() ? -1L : 1L)), object);
    }

    public Duration<U> abs() {
        if (this.isNegative()) {
            return this.inverse();
        }
        return this;
    }

    @Override
    public Duration<U> inverse() {
        return this.multipliedBy(-1);
    }

    public Duration<U> multipliedBy(int n) {
        if (this.isEmpty() || n == 1) {
            return this;
        }
        if (n == 0) {
            return Duration.ofZero();
        }
        if (n == -1) {
            return new Duration<U>(this, true);
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(this.count());
        int n2 = Math.abs(n);
        int n3 = this.count();
        for (int i = 0; i < n3; ++i) {
            TimeSpan.Item<U> item = this.getTotalLength().get(i);
            arrayList.add(TimeSpan.Item.of(MathUtils.safeMultiply(item.getAmount(), (long)n2), item.getUnit()));
        }
        return new Duration<U>(arrayList, n < 0 != this.isNegative());
    }

    public List<Duration<U>> union(TimeSpan<? extends U> timeSpan) {
        Duration<? extends U> duration = Duration.merge(this, timeSpan);
        if (duration == null) {
            ArrayList<Duration<? extends U>> arrayList = new ArrayList<Duration<? extends U>>();
            arrayList.add(this);
            Duration<? extends U> duration2 = Duration.ofZero();
            Duration<? extends U> duration3 = duration2.plus(timeSpan);
            arrayList.add(duration3);
            return Collections.unmodifiableList(arrayList);
        }
        return Collections.singletonList(duration);
    }

    public static Duration<IsoUnit> compose(Duration<CalendarUnit> duration, Duration<ClockUnit> duration2) {
        Duration<CalendarUnit> duration3 = Duration.ofZero();
        return duration3.plus(duration).plus(duration2);
    }

    public Duration<CalendarUnit> toCalendarPeriod() {
        if (this.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
        for (TimeSpan.Item<U> item : this.items) {
            if (!(item.getUnit() instanceof CalendarUnit)) continue;
            arrayList.add(TimeSpan.Item.of(item.getAmount(), CalendarUnit.class.cast(item.getUnit())));
        }
        if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<CalendarUnit>(arrayList, this.isNegative());
    }

    public Duration<ClockUnit> toClockPeriod() {
        if (this.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
        for (TimeSpan.Item<U> item : this.items) {
            if (!(item.getUnit() instanceof ClockUnit)) continue;
            arrayList.add(TimeSpan.Item.of(item.getAmount(), ClockUnit.class.cast(item.getUnit())));
        }
        if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<ClockUnit>(arrayList, this.isNegative());
    }

    public Duration<ClockUnit> toClockPeriodWithDaysAs24Hours() {
        if (this.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
        long l = 0L;
        for (TimeSpan.Item<U> item : this.items) {
            if (item.getUnit() instanceof ClockUnit) {
                arrayList.add(TimeSpan.Item.of(item.getAmount(), ClockUnit.class.cast(item.getUnit())));
                continue;
            }
            if (!((IsoUnit)item.getUnit()).equals(CalendarUnit.DAYS)) continue;
            l = Math.multiplyExact(item.getAmount(), 24L);
        }
        if (l != 0L) {
            boolean bl = false;
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                TimeSpan.Item<ClockUnit> item = (TimeSpan.Item<ClockUnit>)arrayList.get(i);
                if (item.getUnit() != ClockUnit.HOURS) continue;
                bl = true;
                item = TimeSpan.Item.of(Math.addExact(item.getAmount(), l), ClockUnit.HOURS);
                arrayList.set(i, item);
                break;
            }
            if (!bl) {
                arrayList.add(TimeSpan.Item.of(l, ClockUnit.HOURS));
            }
        } else if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<ClockUnit>(arrayList, this.isNegative());
    }

    public TemporalAmount toTemporalAmount() {
        return new JSR310DurationAdapter(this);
    }

    public Duration<U> with(Normalizer<U> normalizer) {
        return Duration.convert(normalizer.normalize(this));
    }

    public static Normalizer<IsoUnit> approximateHours(int n) {
        return new ApproximateNormalizer(n, ClockUnit.HOURS);
    }

    public static Normalizer<IsoUnit> approximateMinutes(int n) {
        return new ApproximateNormalizer(n, ClockUnit.MINUTES);
    }

    public static Normalizer<IsoUnit> approximateSeconds(int n) {
        return new ApproximateNormalizer(n, ClockUnit.SECONDS);
    }

    public static Normalizer<IsoUnit> approximateMaxUnitOnly() {
        return new ApproximateNormalizer(false);
    }

    public static Normalizer<IsoUnit> approximateMaxUnitOrWeeks() {
        return new ApproximateNormalizer(true);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)Duration.class.cast(object);
            return this.negative == duration.negative && this.getTotalLength().equals(duration.getTotalLength());
        }
        return false;
    }

    public int hashCode() {
        int n = this.getTotalLength().hashCode();
        if (this.negative) {
            n ^= n;
        }
        return n;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toStringISO() {
        return this.toString(1);
    }

    public String toStringXML() {
        return this.toString(2);
    }

    public static Duration<IsoUnit> parsePeriod(String string) throws ParseException {
        return Duration.parsePeriod(string, IsoUnit.class);
    }

    public static Duration<CalendarUnit> parseCalendarPeriod(String string) throws ParseException {
        return Duration.parsePeriod(string, CalendarUnit.class);
    }

    public static Duration<ClockUnit> parseClockPeriod(String string) throws ParseException {
        return Duration.parsePeriod(string, ClockUnit.class);
    }

    public static Duration<IsoDateUnit> parseWeekBasedPeriod(String string) throws ParseException {
        return Duration.parsePeriod(string, IsoDateUnit.class);
    }

    public static Formatter<IsoUnit> formatter(String string) {
        return Formatter.ofPattern(string);
    }

    public static <U extends IsoUnit> Formatter<U> formatter(Class<U> clazz, String string) {
        return Formatter.ofPattern(clazz, string);
    }

    private String toString(int n) {
        IsoUnit isoUnit;
        if (n == 1 && this.isNegative()) {
            throw new ChronoException("Negative sign not allowed in ISO-8601.");
        }
        if (this.isEmpty()) {
            return "PT0S";
        }
        boolean bl = n == 2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isNegative()) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        boolean bl2 = false;
        boolean bl3 = false;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = this.count();
        block9: for (int i = 0; i < n2; ++i) {
            TimeSpan.Item<U> item = this.getTotalLength().get(i);
            isoUnit = (IsoUnit)item.getUnit();
            if (!bl2 && !isoUnit.isCalendrical()) {
                stringBuilder.append('T');
                bl2 = true;
            }
            long l4 = item.getAmount();
            int n3 = isoUnit.getSymbol();
            if (isoUnit == Weekcycle.YEARS) {
                bl3 = true;
            }
            if (n3 > 48 && n3 <= 57) {
                assert (n3 == 57);
                l = l4;
                continue;
            }
            if (n3 == 83) {
                l2 = l4;
                continue;
            }
            if (bl || n == 1) {
                switch (n3) {
                    case 68: {
                        if (l3 != 0L) {
                            l4 = MathUtils.safeAdd(l4, l3);
                            l3 = 0L;
                        }
                        stringBuilder.append(l4);
                        break;
                    }
                    case 72: 
                    case 77: 
                    case 89: {
                        stringBuilder.append(l4);
                        break;
                    }
                    case 87: {
                        if (n2 == 1) {
                            if (bl) {
                                stringBuilder.append(MathUtils.safeMultiply(l4, 7L));
                                n3 = 68;
                                break;
                            }
                            stringBuilder.append(l4);
                            break;
                        }
                        l3 = MathUtils.safeMultiply(l4, 7L);
                        if (this.contains(CalendarUnit.DAYS)) continue block9;
                        stringBuilder.append(l3);
                        l3 = 0L;
                        n3 = 68;
                        break;
                    }
                    case 81: {
                        stringBuilder.append(MathUtils.safeMultiply(l4, 3L));
                        n3 = 77;
                        break;
                    }
                    case 69: {
                        stringBuilder.append(MathUtils.safeMultiply(l4, 10L));
                        n3 = 89;
                        break;
                    }
                    case 67: {
                        stringBuilder.append(MathUtils.safeMultiply(l4, 100L));
                        n3 = 89;
                        break;
                    }
                    case 73: {
                        stringBuilder.append(MathUtils.safeMultiply(l4, 1000L));
                        n3 = 89;
                        break;
                    }
                    default: {
                        String string = bl ? "XML" : "ISO";
                        throw new ChronoException("Special units cannot be output in " + string + "-mode: " + this.toString(0));
                    }
                }
            } else {
                stringBuilder.append(l4);
            }
            if (n3 == 0) {
                stringBuilder.append('{');
                stringBuilder.append(isoUnit);
                stringBuilder.append('}');
                continue;
            }
            stringBuilder.append((char)n3);
        }
        if (l != 0L) {
            l2 = MathUtils.safeAdd(l2, l / 1000000000L);
            stringBuilder.append(l2);
            stringBuilder.append(bl ? (char)'.' : (char)ISO_DECIMAL_SEPARATOR);
            String string = String.valueOf(l % 1000000000L);
            int n4 = 9 - string.length();
            for (n2 = 0; n2 < n4; ++n2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
            stringBuilder.append('S');
        } else if (l2 != 0L) {
            stringBuilder.append(l2);
            stringBuilder.append('S');
        }
        if (bl3) {
            boolean bl4;
            boolean bl5 = bl4 = !bl2;
            if (bl4) {
                int n5 = this.count();
                for (n2 = 0; n2 < n5; ++n2) {
                    isoUnit = this.getTotalLength().get(n2).getUnit();
                    if (isoUnit == Weekcycle.YEARS || isoUnit == CalendarUnit.WEEKS || isoUnit == CalendarUnit.DAYS) continue;
                    bl4 = false;
                    break;
                }
            }
            if (!bl4) {
                n2 = stringBuilder.indexOf("Y");
                stringBuilder.replace(n2, n2 + 1, "{WEEK_BASED_YEARS}");
            }
        }
        return stringBuilder.toString();
    }

    private static boolean hasMixedSigns(long l, long l2) {
        return l < 0L && l2 > 0L || l > 0L && l2 < 0L;
    }

    private int count() {
        return this.getTotalLength().size();
    }

    private static <U> boolean isEmpty(TimeSpan<U> timeSpan) {
        List<TimeSpan.Item<U>> list = timeSpan.getTotalLength();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (list.get(i).getAmount() <= 0L) continue;
            return false;
        }
        return true;
    }

    private static <U extends IsoUnit> Duration<U> create(Map<U, Long> map, boolean bl) {
        if (map.isEmpty()) {
            return Duration.ofZero();
        }
        ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>(map.size());
        long l = 0L;
        for (Map.Entry<U, Long> entry : map.entrySet()) {
            long l2 = entry.getValue();
            if (l2 == 0L) continue;
            IsoUnit isoUnit = (IsoUnit)entry.getKey();
            if (isoUnit == ClockUnit.MILLIS) {
                l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l2, 1000000L));
                continue;
            }
            if (isoUnit == ClockUnit.MICROS) {
                l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l2, 1000L));
                continue;
            }
            if (isoUnit == ClockUnit.NANOS) {
                l = MathUtils.safeAdd(l, l2);
                continue;
            }
            arrayList.add(TimeSpan.Item.of(l2, isoUnit));
        }
        if (l != 0L) {
            IsoUnit isoUnit = (IsoUnit)Duration.cast(ClockUnit.NANOS);
            arrayList.add(TimeSpan.Item.of(l, isoUnit));
        } else if (arrayList.isEmpty()) {
            return Duration.ofZero();
        }
        return new Duration<U>(arrayList, bl);
    }

    private int getIndex(ChronoUnit chronoUnit) {
        return Duration.getIndex(chronoUnit, this.getTotalLength());
    }

    private static <U extends ChronoUnit> int getIndex(ChronoUnit chronoUnit, List<TimeSpan.Item<U>> list) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            ChronoUnit chronoUnit2 = (ChronoUnit)list.get(n3).getUnit();
            int n4 = StdNormalizer.compare(chronoUnit2, chronoUnit);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    private static <U extends IsoUnit> TimeSpan.Item<U> replaceFraction(long l, U object) {
        if (object.equals(ClockUnit.MILLIS)) {
            l = MathUtils.safeMultiply(l, 1000000L);
            object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
        } else if (object.equals(ClockUnit.MICROS)) {
            l = MathUtils.safeMultiply(l, 1000L);
            object = (IsoUnit)Duration.cast(ClockUnit.NANOS);
        } else {
            return null;
        }
        return TimeSpan.Item.of(l, object);
    }

    /*
     * WARNING - void declaration
     */
    private static <U extends IsoUnit> Duration<U> merge(Duration<U> duration, TimeSpan<? extends U> timeSpan) {
        int n;
        if (duration.isEmpty()) {
            if (Duration.isEmpty(timeSpan)) {
                return duration;
            }
            if (timeSpan instanceof Duration) {
                return (Duration)Duration.cast(timeSpan);
            }
        }
        HashMap<Object, Long> hashMap = new HashMap<Object, Long>();
        int n2 = super.count();
        for (n = 0; n < n2; ++n) {
            TimeSpan.Item<U> item = duration.getTotalLength().get(n);
            hashMap.put(item.getUnit(), MathUtils.safeMultiply(item.getAmount(), (long)(duration.isNegative() ? -1 : 1)));
        }
        n = timeSpan.isNegative() ? 1 : 0;
        int n3 = timeSpan.getTotalLength().size();
        for (n2 = 0; n2 < n3; ++n2) {
            void object;
            Map.Entry entry = timeSpan.getTotalLength().get(n2);
            IsoUnit isoUnit = (IsoUnit)((TimeSpan.Item)((Object)entry)).getUnit();
            long l = ((TimeSpan.Item)((Object)entry)).getAmount();
            TimeSpan.Item<IsoUnit> item = Duration.replaceFraction(l, isoUnit);
            if (item != null) {
                l = item.getAmount();
                IsoUnit l2 = item.getUnit();
            }
            if (hashMap.containsKey(object)) {
                hashMap.put(object, MathUtils.safeAdd((Long)hashMap.get(object), MathUtils.safeMultiply(l, (long)(n != 0 ? -1 : 1))));
                continue;
            }
            hashMap.put(object, MathUtils.safeMultiply(l, (long)(n != 0 ? -1 : 1)));
        }
        n2 = 0;
        if (duration.isNegative() == n) {
            n2 = n;
        } else {
            n3 = 1;
            for (Map.Entry entry : hashMap.entrySet()) {
                int n4;
                int n5 = n4 = (Long)entry.getValue() < 0L ? 1 : 0;
                if (n3 != 0) {
                    n2 = n4;
                    n3 = 0;
                    continue;
                }
                if (n2 == n4) continue;
                return null;
            }
        }
        if (n2 != 0) {
            for (Map.Entry entry : hashMap.entrySet()) {
                long l = (Long)entry.getValue();
                hashMap.put(entry.getKey(), l < 0L ? MathUtils.safeNegate(l) : l);
            }
        }
        return Duration.create(hashMap, n2 != 0);
    }

    private static <U extends IsoUnit> boolean summarize(TimeSpan<? extends U> timeSpan, long[] lArray) {
        long l = lArray[0];
        long l2 = lArray[1];
        long l3 = lArray[2];
        long l4 = lArray[3];
        for (TimeSpan.Item<U> item : timeSpan.getTotalLength()) {
            Enum enum_;
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            long l5 = item.getAmount();
            if (timeSpan.isNegative()) {
                l5 = MathUtils.safeNegate(l5);
            }
            if (isoUnit instanceof CalendarUnit) {
                enum_ = (CalendarUnit)CalendarUnit.class.cast(isoUnit);
                switch (1.$SwitchMap$net$time4j$CalendarUnit[enum_.ordinal()]) {
                    case 1: {
                        l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l5, 12000L));
                        break;
                    }
                    case 2: {
                        l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l5, 1200L));
                        break;
                    }
                    case 3: {
                        l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l5, 120L));
                        break;
                    }
                    case 4: {
                        l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l5, 12L));
                        break;
                    }
                    case 5: {
                        l = MathUtils.safeAdd(l, MathUtils.safeMultiply(l5, 3L));
                        break;
                    }
                    case 6: {
                        l = MathUtils.safeAdd(l, l5);
                        break;
                    }
                    case 7: {
                        l2 = MathUtils.safeAdd(l2, MathUtils.safeMultiply(l5, 7L));
                        break;
                    }
                    case 8: {
                        l2 = MathUtils.safeAdd(l2, l5);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(enum_.name());
                    }
                }
                continue;
            }
            if (isoUnit instanceof ClockUnit) {
                enum_ = (ClockUnit)ClockUnit.class.cast(isoUnit);
                switch (1.$SwitchMap$net$time4j$ClockUnit[enum_.ordinal()]) {
                    case 1: {
                        l3 = MathUtils.safeAdd(l3, MathUtils.safeMultiply(l5, 3600L));
                        break;
                    }
                    case 2: {
                        l3 = MathUtils.safeAdd(l3, MathUtils.safeMultiply(l5, 60L));
                        break;
                    }
                    case 3: {
                        l3 = MathUtils.safeAdd(l3, l5);
                        break;
                    }
                    case 4: {
                        l4 = MathUtils.safeAdd(l4, MathUtils.safeMultiply(l5, 1000000L));
                        break;
                    }
                    case 5: {
                        l4 = MathUtils.safeAdd(l4, MathUtils.safeMultiply(l5, 1000L));
                        break;
                    }
                    case 6: {
                        l4 = MathUtils.safeAdd(l4, l5);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(enum_.name());
                    }
                }
                continue;
            }
            return false;
        }
        if (l4 != 0L) {
            l4 = MathUtils.safeAdd(l4, MathUtils.safeMultiply(l2, 86400000000000L));
            l4 = MathUtils.safeAdd(l4, MathUtils.safeMultiply(l3, 1000000000L));
            l2 = 0L;
            l3 = 0L;
        } else if (l3 != 0L) {
            l3 = MathUtils.safeAdd(l3, MathUtils.safeMultiply(l2, 86400L));
            l2 = 0L;
        }
        lArray[0] = l;
        lArray[1] = l2;
        lArray[2] = l3;
        lArray[3] = l4;
        return true;
    }

    private static <U extends IsoUnit> Duration<U> convert(TimeSpan<U> timeSpan) {
        if (timeSpan instanceof Duration) {
            return (Duration)Duration.cast(timeSpan);
        }
        Duration<U> duration = Duration.ofZero();
        return duration.plus(timeSpan);
    }

    private boolean isFractionUnit(IsoUnit isoUnit) {
        char c = isoUnit.getSymbol();
        return c >= '1' && c <= '9';
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private static <U extends IsoUnit> Duration<U> parsePeriod(String string, Class<U> clazz) throws ParseException {
        int n = 0;
        boolean bl = false;
        if (string.length() == 0) {
            throw new ParseException("Empty period string.", n);
        }
        if (string.charAt(0) == '-') {
            bl = true;
            n = 1;
        }
        try {
            int n2;
            if (string.charAt(n) != 'P') {
                throw new ParseException("Format symbol 'P' expected: " + string, n);
            }
            ArrayList<TimeSpan.Item<U>> arrayList = new ArrayList<TimeSpan.Item<U>>();
            boolean bl2 = (n2 = string.indexOf(84, ++n)) == -1;
            int n3 = -1;
            if (clazz == CalendarUnit.class) {
                n3 = 0;
            } else if (clazz == ClockUnit.class) {
                n3 = 1;
            } else if (clazz == IsoDateUnit.class) {
                n3 = 2;
            }
            if (bl2) {
                if (n3 == 1) {
                    throw new ParseException("Format symbol 'T' expected: " + string, n);
                }
                Duration.parse(string, n, string.length(), n3 == -1 ? 0 : n3, arrayList);
            } else {
                if (n3 == 0 || n3 == 2) {
                    throw new ParseException("Unexpected time component found: " + string, n2);
                }
                boolean bl3 = false;
                if (n2 > n) {
                    if (n3 == 1) {
                        throw new ParseException("Unexpected date component found: " + string, n);
                    }
                    bl3 = Duration.parse(string.substring(0, n2), n, n2, 0, arrayList);
                }
                if (bl3) {
                    Duration.parseAlt(string, n2 + 1, string.length(), false, arrayList);
                } else {
                    Duration.parse(string, n2 + 1, string.length(), 1, arrayList);
                }
            }
            return new Duration<U>(arrayList, bl);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ParseException parseException = new ParseException("Unexpected termination of period string: " + string, n);
            parseException.initCause(indexOutOfBoundsException);
            throw parseException;
        }
    }

    private static <U extends ChronoUnit> boolean parse(String string, int n, int n2, int n3, List<TimeSpan.Item<U>> list) throws ParseException {
        char c = string.charAt(n2 - 1);
        if (c >= '0' && c <= '9' && n3 != 2) {
            Duration.parseAlt(string, n, n2, n3 == 0, list);
            return true;
        }
        if (n == n2) {
            throw new ParseException(string, n);
        }
        StringBuilder stringBuilder = null;
        boolean bl = false;
        ChronoUnit chronoUnit = null;
        int n4 = n;
        boolean bl2 = false;
        for (int i = n; i < n2; ++i) {
            long l;
            char c2 = string.charAt(i);
            if (c2 >= '0' && c2 <= '9') {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    bl = false;
                    n4 = i;
                }
                stringBuilder.append(c2);
                continue;
            }
            if (c2 == ',' || c2 == '.') {
                if (stringBuilder == null || n3 != 1) {
                    throw new ParseException("Decimal separator misplaced: " + string, i);
                }
                bl = true;
                l = Duration.parseAmount(string, stringBuilder.toString(), n4);
                chronoUnit = Duration.addParsedItem(ClockUnit.SECONDS, chronoUnit, l, string, i, list);
                stringBuilder = null;
                bl2 = true;
                continue;
            }
            if (bl) {
                throw new ParseException("Unexpected char '" + c2 + "' found: " + string, i);
            }
            if (bl2) {
                if (c2 != 'S') {
                    throw new ParseException("Second symbol expected: " + string, i);
                }
                if (stringBuilder == null) {
                    throw new ParseException("Decimal separator misplaced: " + string, i - 1);
                }
                if (stringBuilder.length() > 9) {
                    stringBuilder.delete(9, stringBuilder.length());
                }
                for (int j = stringBuilder.length(); j < 9; ++j) {
                    stringBuilder.append('0');
                }
                bl = true;
                l = Duration.parseAmount(string, stringBuilder.toString(), n4);
                stringBuilder = null;
                chronoUnit = Duration.addParsedItem(ClockUnit.NANOS, chronoUnit, l, string, i, list);
                continue;
            }
            bl = true;
            l = Duration.parseAmount(string, stringBuilder == null ? String.valueOf(c2) : stringBuilder.toString(), n4);
            stringBuilder = null;
            IsoUnit isoUnit = n3 == 1 ? Duration.parseTimeSymbol(c2, string, i) : (n3 == 2 ? Duration.parseWeekBasedSymbol(c2, string, i) : Duration.parseDateSymbol(c2, string, i));
            chronoUnit = Duration.addParsedItem(isoUnit, chronoUnit, l, string, i, list);
        }
        if (!bl) {
            throw new ParseException("Unit symbol expected: " + string, n2);
        }
        return false;
    }

    private static <U extends ChronoUnit> void parseAlt(String string, int n, int n2, boolean bl, List<TimeSpan.Item<U>> list) throws ParseException {
        boolean bl2 = false;
        if (bl) {
            ChronoUnit chronoUnit;
            long l;
            long l2;
            if (n + 4 < n2) {
                boolean bl3 = bl2 = string.charAt(n + 4) == '-';
            }
            boolean bl4 = bl2 ? n + 8 == n2 : n + 7 == n2;
            Duration duration = (Duration)Duration.getAlternativeDateFormat(bl2, bl4).parse(string, n);
            long l3 = duration.getPartialAmount(CalendarUnit.YEARS);
            if (bl4) {
                l2 = 0L;
                l = duration.getPartialAmount(CalendarUnit.DAYS);
            } else {
                l2 = duration.getPartialAmount(CalendarUnit.MONTHS);
                l = duration.getPartialAmount(CalendarUnit.DAYS);
                if (l2 > 12L) {
                    throw new ParseException("ISO-8601 prohibits months-part > 12: " + string, n + 4 + (bl2 ? 1 : 0));
                }
                if (l > 30L) {
                    throw new ParseException("ISO-8601 prohibits days-part > 30: " + string, n + 6 + (bl2 ? 2 : 0));
                }
            }
            if (l3 > 0L) {
                chronoUnit = (ChronoUnit)Duration.cast(CalendarUnit.YEARS);
                list.add(TimeSpan.Item.of(l3, chronoUnit));
            }
            if (l2 > 0L) {
                chronoUnit = (ChronoUnit)Duration.cast(CalendarUnit.MONTHS);
                list.add(TimeSpan.Item.of(l2, chronoUnit));
            }
            if (l > 0L) {
                chronoUnit = (ChronoUnit)Duration.cast(CalendarUnit.DAYS);
                list.add(TimeSpan.Item.of(l, chronoUnit));
            }
        } else {
            long l;
            long l4;
            long l5;
            Duration duration;
            long l6;
            if (n + 2 < n2) {
                boolean bl5 = bl2 = string.charAt(n + 2) == ':';
            }
            if ((l6 = (duration = (Duration)Duration.getAlternativeTimeFormat(bl2).parse(string, n)).getPartialAmount(ClockUnit.HOURS)) > 0L) {
                if (l6 > 24L) {
                    throw new ParseException("ISO-8601 prohibits hours-part > 24: " + string, n);
                }
                ChronoUnit chronoUnit = (ChronoUnit)Duration.cast(ClockUnit.HOURS);
                list.add(TimeSpan.Item.of(l6, chronoUnit));
            }
            if ((l5 = duration.getPartialAmount(ClockUnit.MINUTES)) > 0L) {
                if (l5 > 60L) {
                    throw new ParseException("ISO-8601 prohibits minutes-part > 60: " + string, n + 2 + (bl2 ? 1 : 0));
                }
                ChronoUnit chronoUnit = (ChronoUnit)Duration.cast(ClockUnit.MINUTES);
                list.add(TimeSpan.Item.of(l5, chronoUnit));
            }
            if ((l4 = duration.getPartialAmount(ClockUnit.SECONDS)) > 0L) {
                if (l4 > 60L) {
                    throw new ParseException("ISO-8601 prohibits seconds-part > 60: " + string, n + 4 + (bl2 ? 2 : 0));
                }
                ChronoUnit chronoUnit = (ChronoUnit)Duration.cast(ClockUnit.SECONDS);
                list.add(TimeSpan.Item.of(l4, chronoUnit));
            }
            if ((l = duration.getPartialAmount(ClockUnit.NANOS)) > 0L) {
                ChronoUnit chronoUnit = (ChronoUnit)Duration.cast(ClockUnit.NANOS);
                list.add(TimeSpan.Item.of(l, chronoUnit));
            }
        }
    }

    private static Formatter<CalendarUnit> createAlternativeDateFormat(boolean bl, boolean bl2) {
        String string = bl ? (bl2 ? "YYYY-DDD" : "YYYY-MM-DD") : (bl2 ? "YYYYDDD" : "YYYYMMDD");
        return Formatter.ofPattern(CalendarUnit.class, string);
    }

    private static Formatter<CalendarUnit> getAlternativeDateFormat(boolean bl, boolean bl2) {
        if (bl) {
            return bl2 ? CF_EXT_ORD : CF_EXT_CAL;
        }
        return bl2 ? CF_BAS_ORD : CF_BAS_CAL;
    }

    private static Formatter<ClockUnit> createAlternativeTimeFormat(boolean bl) {
        String string = bl ? "hh[:mm[:ss[,fffffffff]]]" : "hh[mm[ss[,fffffffff]]]";
        return Formatter.ofPattern(ClockUnit.class, string);
    }

    private static Formatter<ClockUnit> getAlternativeTimeFormat(boolean bl) {
        return bl ? TF_EXT : TF_BAS;
    }

    private static CalendarUnit parseDateSymbol(char c, String string, int n) throws ParseException {
        switch (c) {
            case 'I': {
                return CalendarUnit.MILLENNIA;
            }
            case 'C': {
                return CalendarUnit.CENTURIES;
            }
            case 'E': {
                return CalendarUnit.DECADES;
            }
            case 'Y': {
                return CalendarUnit.YEARS;
            }
            case 'Q': {
                return CalendarUnit.QUARTERS;
            }
            case 'M': {
                return CalendarUnit.MONTHS;
            }
            case 'W': {
                return CalendarUnit.WEEKS;
            }
            case 'D': {
                return CalendarUnit.DAYS;
            }
        }
        throw new ParseException("Symbol '" + c + "' not supported: " + string, n);
    }

    private static ClockUnit parseTimeSymbol(char c, String string, int n) throws ParseException {
        switch (c) {
            case 'H': {
                return ClockUnit.HOURS;
            }
            case 'M': {
                return ClockUnit.MINUTES;
            }
            case 'S': {
                return ClockUnit.SECONDS;
            }
        }
        throw new ParseException("Symbol '" + c + "' not supported: " + string, n);
    }

    private static IsoDateUnit parseWeekBasedSymbol(char c, String string, int n) throws ParseException {
        switch (c) {
            case 'Y': {
                return CalendarUnit.weekBasedYears();
            }
            case 'W': {
                return CalendarUnit.WEEKS;
            }
            case 'D': {
                return CalendarUnit.DAYS;
            }
        }
        throw new ParseException("Symbol '" + c + "' not supported: " + string, n);
    }

    private static <U extends ChronoUnit> ChronoUnit addParsedItem(ChronoUnit chronoUnit, ChronoUnit chronoUnit2, long l, String string, int n, List<TimeSpan.Item<U>> list) throws ParseException {
        if (chronoUnit2 == null || Double.compare(chronoUnit.getLength(), chronoUnit2.getLength()) < 0) {
            if (l != 0L) {
                ChronoUnit chronoUnit3 = (ChronoUnit)Duration.cast(chronoUnit);
                list.add(TimeSpan.Item.of(l, chronoUnit3));
            }
            return chronoUnit;
        }
        if (Double.compare(chronoUnit.getLength(), chronoUnit2.getLength()) == 0) {
            throw new ParseException("Duplicate unit items: " + string, n);
        }
        throw new ParseException("Wrong order of unit items: " + string, n);
    }

    private static long parseAmount(String string, String string2, int n) throws ParseException {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ParseException parseException = new ParseException(string, n);
            parseException.initCause(numberFormatException);
            throw parseException;
        }
    }

    private Object writeReplace() {
        return new SPX(this, 6);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class ApproximateNormalizer
    implements Normalizer<IsoUnit> {
        private final boolean daysToWeeks;
        private final int steps;
        private final ClockUnit unit;

        ApproximateNormalizer(boolean bl) {
            this.daysToWeeks = bl;
            this.steps = 1;
            this.unit = null;
        }

        ApproximateNormalizer(int n, ClockUnit clockUnit) {
            if (n < 1) {
                throw new IllegalArgumentException("Step width is not positive: " + n);
            }
            if (clockUnit.compareTo(ClockUnit.SECONDS) > 0) {
                throw new IllegalArgumentException("Unsupported unit.");
            }
            this.daysToWeeks = false;
            this.steps = n;
            this.unit = clockUnit;
        }

        @Override
        public Duration<IsoUnit> normalize(TimeSpan<? extends IsoUnit> timeSpan) {
            double d = 0.0;
            IsoUnit isoUnit = null;
            int n = timeSpan.getTotalLength().size();
            for (int i = 0; i < n; ++i) {
                TimeSpan.Item<? extends IsoUnit> item = timeSpan.getTotalLength().get(i);
                d += (double)item.getAmount() * item.getUnit().getLength();
                if (isoUnit != null || item.getAmount() <= 0L) continue;
                isoUnit = item.getUnit();
            }
            if (isoUnit == null) {
                return Duration.ofZero();
            }
            ClockUnit clockUnit = this.unit == null ? isoUnit : this.unit;
            double d2 = clockUnit.getLength() * (double)this.steps;
            long l = (long)(d + d2 / 2.0);
            int n2 = (int)Math.floor(d2);
            l = MathUtils.floorDivide(l, n2) * (long)n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = ApproximateNormalizer.safeCast((double)l / CalendarUnit.YEARS.getLength());
            l = (long)((double)l - (double)n5 * CalendarUnit.YEARS.getLength());
            int n6 = ApproximateNormalizer.safeCast((double)l / CalendarUnit.MONTHS.getLength());
            l = (long)((double)l - (double)n6 * CalendarUnit.MONTHS.getLength());
            int n7 = ApproximateNormalizer.safeCast((double)l / CalendarUnit.WEEKS.getLength());
            l = (long)((double)l - (double)n7 * CalendarUnit.WEEKS.getLength());
            int n8 = ApproximateNormalizer.safeCast((double)l / CalendarUnit.DAYS.getLength());
            l = (long)((double)l - (double)n8 * CalendarUnit.DAYS.getLength());
            int n9 = ApproximateNormalizer.safeCast((double)l / ClockUnit.HOURS.getLength());
            if (ClockUnit.HOURS.equals(this.unit)) {
                n9 /= this.steps;
                n9 *= this.steps;
            } else {
                l = (long)((double)l - (double)n9 * ClockUnit.HOURS.getLength());
                n3 = ApproximateNormalizer.safeCast((double)l / ClockUnit.MINUTES.getLength());
                if (ClockUnit.MINUTES.equals(this.unit)) {
                    n3 /= this.steps;
                    n3 *= this.steps;
                } else {
                    l = (long)((double)l - (double)n3 * ClockUnit.MINUTES.getLength());
                    n4 = ApproximateNormalizer.safeCast((double)l / ClockUnit.SECONDS.getLength());
                    n4 /= this.steps;
                    n4 *= this.steps;
                }
            }
            n8 += n7 * 7;
            n7 = 0;
            if (this.unit == null) {
                if (n5 > 0) {
                    n4 = 0;
                    n3 = 0;
                    n9 = 0;
                    n8 = 0;
                    n6 = 0;
                } else if (n6 > 0) {
                    n4 = 0;
                    n3 = 0;
                    n9 = 0;
                    n8 = 0;
                } else if (n8 > 0) {
                    if (n8 >= 7 && this.daysToWeeks) {
                        n7 = (int)(((double)n8 + 3.5) / 7.0);
                        n8 = 0;
                    }
                    n4 = 0;
                    n3 = 0;
                    n9 = 0;
                } else if (n9 > 0) {
                    n4 = 0;
                    n3 = 0;
                } else if (n3 > 0) {
                    n4 = 0;
                }
                if (n7 > 0) {
                    return Duration.of(timeSpan.isNegative() ? (long)(-n7) : (long)n7, CalendarUnit.WEEKS);
                }
            }
            AbstractDuration abstractDuration = Duration.ofPositive().years(n5).months(n6).days(n8).hours(n9).minutes(n3).seconds(n4).build();
            if (timeSpan.isNegative()) {
                abstractDuration = abstractDuration.inverse();
            }
            return abstractDuration;
        }

        private static int safeCast(double d) {
            if (d < -2.147483648E9 || d > 2.147483647E9) {
                throw new ArithmeticException("Out of range: " + d);
            }
            return (int)d;
        }
    }

    private static class LengthComparator<U extends IsoUnit, T extends TimePoint<? super U, T>>
    implements Comparator<Duration<U>> {
        private final T base;

        private LengthComparator(T t) {
            if (t == null) {
                throw new NullPointerException("Missing base time point.");
            }
            this.base = t;
        }

        @Override
        public int compare(Duration<U> duration, Duration<U> duration2) {
            boolean bl = duration.isNegative();
            boolean bl2 = duration2.isNegative();
            if (bl && !bl2) {
                return -1;
            }
            if (!bl && bl2) {
                return 1;
            }
            if (duration.isEmpty() && duration2.isEmpty()) {
                return 0;
            }
            return ((TimePoint)((TimePoint)this.base).plus(duration)).compareTo(((TimePoint)this.base).plus(duration2));
        }

        /* synthetic */ LengthComparator(TimePoint timePoint, 1 var2_2) {
            this(timePoint);
        }
    }

    private static class Metric<U extends IsoUnit>
    extends AbstractMetric<U, Duration<U>> {
        @SafeVarargs
        private Metric(U ... UArray) {
            super(UArray.length > 1, UArray);
        }

        @Override
        protected Duration<U> createEmptyTimeSpan() {
            return Duration.ofZero();
        }

        @Override
        protected Duration<U> createTimeSpan(List<TimeSpan.Item<U>> list, boolean bl) {
            return new Duration<U>(list, bl);
        }

        @Override
        protected TimeSpan.Item<U> resolve(TimeSpan.Item<U> item) {
            IsoUnit isoUnit = (IsoUnit)item.getUnit();
            if (isoUnit.equals(ClockUnit.MILLIS)) {
                return TimeSpan.Item.of(Math.multiplyExact(item.getAmount(), 1000000L), ClockUnit.NANOS);
            }
            if (isoUnit.equals(ClockUnit.MICROS)) {
                return TimeSpan.Item.of(Math.multiplyExact(item.getAmount(), 1000L), ClockUnit.NANOS);
            }
            return item;
        }
    }

    public static final class Formatter<U extends IsoUnit>
    extends TimeSpanFormatter<U, Duration<U>> {
        private static final String JODA_PATTERN = "'P'[-#################Y'Y'][-#################M'M'][-#################W'W'][-#################D'D']['T'[-#################h'H'][-#################m'M'][-#################s'S'[.fffffffff]]]";

        private Formatter(Class<U> clazz, String string) {
            super(clazz, string);
        }

        public static Formatter<IsoUnit> ofJodaStyle() {
            return Formatter.ofPattern(IsoUnit.class, JODA_PATTERN);
        }

        public static Formatter<IsoUnit> ofPattern(String string) {
            return Formatter.ofPattern(IsoUnit.class, string);
        }

        public static <U extends IsoUnit> Formatter<U> ofPattern(Class<U> clazz, String string) {
            return new Formatter<U>(clazz, string);
        }

        public String format(TemporalAmount temporalAmount) {
            return this.format(Duration.from(temporalAmount));
        }

        public void print(TemporalAmount temporalAmount, Appendable appendable) throws IOException {
            this.print(Duration.from(temporalAmount), appendable);
        }

        @Override
        protected Duration<U> convert(Map<U, Long> map, boolean bl) {
            return Duration.create(map, bl);
        }

        @Override
        protected U getUnit(char c) {
            Enum enum_;
            switch (c) {
                case 'I': {
                    enum_ = CalendarUnit.MILLENNIA;
                    break;
                }
                case 'C': {
                    enum_ = CalendarUnit.CENTURIES;
                    break;
                }
                case 'E': {
                    enum_ = CalendarUnit.DECADES;
                    break;
                }
                case 'Y': {
                    enum_ = CalendarUnit.YEARS;
                    break;
                }
                case 'Q': {
                    enum_ = CalendarUnit.QUARTERS;
                    break;
                }
                case 'M': {
                    enum_ = CalendarUnit.MONTHS;
                    break;
                }
                case 'W': {
                    enum_ = CalendarUnit.WEEKS;
                    break;
                }
                case 'D': {
                    enum_ = CalendarUnit.DAYS;
                    break;
                }
                case 'h': {
                    enum_ = ClockUnit.HOURS;
                    break;
                }
                case 'm': {
                    enum_ = ClockUnit.MINUTES;
                    break;
                }
                case 's': {
                    enum_ = ClockUnit.SECONDS;
                    break;
                }
                case 'f': {
                    enum_ = ClockUnit.NANOS;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
                }
            }
            try {
                return (U)enum_;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(classCastException.getMessage(), classCastException);
            }
        }
    }

    private static class ZonalMetric
    implements TimeMetric<IsoUnit, Duration<IsoUnit>> {
        private final Timezone tz;
        private final TimeMetric<IsoUnit, Duration<IsoUnit>> metric;

        private ZonalMetric(Timezone timezone, IsoUnit ... isoUnitArray) {
            if (timezone == null) {
                throw new NullPointerException("Missing timezone.");
            }
            this.tz = timezone;
            this.metric = new Metric<IsoUnit>(isoUnitArray);
        }

        @Override
        public <T extends TimePoint<? super IsoUnit, T>> Duration<IsoUnit> between(T t, T t2) {
            T t3 = t;
            T t4 = t2;
            boolean bl = false;
            if (t.compareTo(t2) > 0) {
                t3 = t2;
                t4 = t;
                bl = true;
            }
            int n = this.getOffset(t3);
            int n2 = this.getOffset(t4);
            t4 = t4.plus(n - n2, (ClockUnit)ClockUnit.SECONDS);
            AbstractDuration abstractDuration = this.metric.between(t3, t4);
            if (bl) {
                abstractDuration = abstractDuration.inverse();
            }
            return abstractDuration;
        }

        private int getOffset(ChronoEntity<?> chronoEntity) {
            return this.tz.getStrategy().getOffset(chronoEntity.get(PlainDate.COMPONENT), chronoEntity.get(PlainTime.COMPONENT), this.tz).getIntegralAmount();
        }
    }

    public static class Builder {
        private final List<TimeSpan.Item<IsoUnit>> items = new ArrayList<TimeSpan.Item<IsoUnit>>(10);
        private final boolean negative;
        private boolean millisSet = false;
        private boolean microsSet = false;
        private boolean nanosSet = false;

        Builder(boolean bl) {
            this.negative = bl;
        }

        public Builder years(int n) {
            this.set(n, CalendarUnit.YEARS);
            return this;
        }

        public Builder months(int n) {
            this.set(n, CalendarUnit.MONTHS);
            return this;
        }

        public Builder days(int n) {
            this.set(n, CalendarUnit.DAYS);
            return this;
        }

        public Builder hours(int n) {
            this.set(n, ClockUnit.HOURS);
            return this;
        }

        public Builder minutes(int n) {
            this.set(n, ClockUnit.MINUTES);
            return this;
        }

        public Builder seconds(int n) {
            this.set(n, ClockUnit.SECONDS);
            return this;
        }

        public Builder millis(int n) {
            this.millisCalled();
            this.update(n, 1000000L);
            return this;
        }

        public Builder micros(int n) {
            this.microsCalled();
            this.update(n, 1000L);
            return this;
        }

        public Builder nanos(int n) {
            this.nanosCalled();
            this.update(n, 1L);
            return this;
        }

        public Duration<IsoUnit> build() {
            if (this.items.isEmpty()) {
                throw new IllegalStateException("Not set any amount and unit.");
            }
            return new Duration<IsoUnit>(this.items, this.negative);
        }

        private void set(long l, IsoUnit isoUnit) {
            int n = this.items.size();
            for (int i = 0; i < n; ++i) {
                if (this.items.get(i).getUnit() != isoUnit) continue;
                throw new IllegalStateException("Already registered: " + isoUnit);
            }
            if (l != 0L) {
                TimeSpan.Item<IsoUnit> item = TimeSpan.Item.of(l, isoUnit);
                this.items.add(item);
            }
        }

        private void update(long l, long l2) {
            if (l >= 0L) {
                ClockUnit clockUnit = ClockUnit.NANOS;
                for (int i = this.items.size() - 1; i >= 0; --i) {
                    TimeSpan.Item<IsoUnit> item = this.items.get(i);
                    if (!item.getUnit().equals(ClockUnit.NANOS)) continue;
                    this.items.set(i, TimeSpan.Item.of(MathUtils.safeAdd(MathUtils.safeMultiply(l, l2), item.getAmount()), clockUnit));
                    return;
                }
                if (l != 0L) {
                    this.items.add(TimeSpan.Item.of(MathUtils.safeMultiply(l, l2), clockUnit));
                }
            } else {
                throw new IllegalArgumentException("Illegal negative amount: " + l);
            }
        }

        private void millisCalled() {
            if (this.millisSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.MILLIS.name());
            }
            this.millisSet = true;
        }

        private void microsCalled() {
            if (this.microsSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.MICROS.name());
            }
            this.microsSet = true;
        }

        private void nanosCalled() {
            if (this.nanosSet) {
                throw new IllegalStateException("Called twice for: " + ClockUnit.NANOS.name());
            }
            this.nanosSet = true;
        }
    }
}

